/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.editor;

import com.jogamp.opengl.GLContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.combinations.Combinators;
import org.simantics.db.request.Read;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.NodeMap;
import org.simantics.g3d.scenegraph.RenderListener;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.toolbar.ToolComposite;
import org.simantics.g3d.vtk.action.RemoveAction;
import org.simantics.g3d.vtk.action.vtkAction;
import org.simantics.g3d.vtk.common.HoverHighlighter;
import org.simantics.g3d.vtk.common.NodeSelectionProvider2;
import org.simantics.g3d.vtk.common.SelectionHighlighter;
import org.simantics.g3d.vtk.common.VTKNodeMap;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.swt.ContextMenuListener;
import org.simantics.g3d.vtk.swt.FocusAction;
import org.simantics.g3d.vtk.swt.InteractiveVtkComposite;
import org.simantics.g3d.vtk.swt.RotateAction;
import org.simantics.g3d.vtk.swt.TranslateAction;
import org.simantics.g3d.vtk.swt.vtkCameraAndSelectorAction;
import org.simantics.g3d.vtk.utils.AxesDisplay;
import org.simantics.g3d.vtk.utils.GridDisplay;
import org.simantics.objmap.graph.IMapping;
import org.simantics.objmap.graph.Mappings;
import org.simantics.objmap.graph.schema.IMappingSchema;
import org.simantics.plant3d.actions.AddComponentAction;
import org.simantics.plant3d.actions.AddEquipmentAction;
import org.simantics.plant3d.actions.AddNozzleAction;
import org.simantics.plant3d.actions.RemoveAndSplitAction;
import org.simantics.plant3d.actions.ReversePipeRunAction;
import org.simantics.plant3d.actions.RoutePipeAction;
import org.simantics.plant3d.actions.TranslateFreeVariableLengthAction;
import org.simantics.plant3d.actions.TranslateInlineAction;
import org.simantics.plant3d.editor.P3DContentOutlinePage;
import org.simantics.plant3d.editor.P3DNodeMap;
import org.simantics.plant3d.scenegraph.EndComponent;
import org.simantics.plant3d.scenegraph.Equipment;
import org.simantics.plant3d.scenegraph.IP3DNode;
import org.simantics.plant3d.scenegraph.IP3DVisualNode;
import org.simantics.plant3d.scenegraph.InlineComponent;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.SchemaBuilder;
import org.simantics.plant3d.scenegraph.TurnComponent;
import org.simantics.plant3d.scenegraph.controlpoint.ControlPointFactory;
import org.simantics.plant3d.utils.ComponentUtils;
import org.simantics.plant3d.utils.Item;
import org.simantics.plant3d.utils.P3DUtil;
import org.simantics.selectionview.StandardPropertyPage;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorPart;
import org.simantics.ui.workbench.editor.input.InputValidationCombinators;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ExceptionUtils;
import vtk.vtkCameraPass;
import vtk.vtkDefaultPass;
import vtk.vtkGaussianBlurPass;
import vtk.vtkLightsPass;
import vtk.vtkProp3D;
import vtk.vtkRenderPass;
import vtk.vtkRenderPassCollection;
import vtk.vtkRenderer;
import vtk.vtkSSAAPass;
import vtk.vtkSequencePass;
import vtk.vtkSimpleMotionBlurPass;

public class Plant3DEditor
extends ResourceEditorPart {
    private Composite parent;
    protected ToolComposite toolComposite;
    private Resource input;
    private InteractiveVtkComposite panel;
    private P3DRootNode rootNode;
    private IMapping<Resource, INode> mapping;
    protected NodeSelectionProvider2<Resource, INode> selectionProvider;
    protected vtkCameraAndSelectorAction cameraAction;
    protected FocusAction focusAction;
    protected TranslateAction translateAction;
    protected TranslateInlineAction translateInlineAction;
    protected TranslateFreeVariableLengthAction translateFreeVariableLengthAction;
    protected RotateAction rotateAction;
    protected RemoveAction removeAction;
    protected RemoveAndSplitAction removeSplitAction;
    protected RoutePipeAction routePipeAction;
    protected AddComponentAction addComponentAction;
    protected ReversePipeRunAction reversePipeRunAction;
    private P3DNodeMap nodeMap;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    protected int upDirection = 1;
    ParametrizedRead<IResourceEditorInput, Boolean> INPUT_VALIDATOR = Combinators.compose((ParametrizedRead)InputValidationCombinators.hasURI(), (ParametrizedRead)InputValidationCombinators.extractInputResource());
    protected Menu contextMenu;

    protected ParametrizedRead<IResourceEditorInput, Boolean> getInputValidator() {
        return this.INPUT_VALIDATOR;
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.activateValidation();
        IResourceEditorInput rei = (IResourceEditorInput)this.getEditorInput();
        this.input = rei.getResource();
        this.toolComposite = new ToolComposite(parent, 2048);
        this.toolComposite.setVisible(true);
        this.panel = new InteractiveVtkComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.getPanel().getComponent());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.toolComposite);
        this.hookContextMenu();
        this.createScene();
        new ContextMenuListener(this.panel, this.contextMenu);
        this.cameraAction = this.createCameraAction();
        switch (this.upDirection) {
            case 0: {
                this.cameraAction.setUpDirection(new double[]{1.0, 0.0, 0.0});
                break;
            }
            case 1: {
                this.cameraAction.setUpDirection(new double[]{0.0, 1.0, 0.0});
                break;
            }
            case 2: {
                this.cameraAction.setUpDirection(new double[]{0.0, 0.0, 1.0});
            }
        }
        this.panel.setDefaultAction((vtkAction)this.cameraAction);
        this.panel.useDefaultAction();
        this.panel.setPickType(4);
        try {
            ControlPointFactory.preloadCache((RequestProcessor)Simantics.getSession(), this.getLibraryUri());
            ComponentUtils.preloadCache((RequestProcessor)Simantics.getSession());
        }
        catch (Exception e) {
            ExceptionUtils.logAndShowError((String)"Cannot open Plant3D editor", (Throwable)e);
            return;
        }
        try {
            this.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    IMappingSchema<Resource, INode> schema = Plant3DEditor.this.getSchema(graph);
                    Plant3DEditor.this.mapping = Mappings.createWithListening(schema);
                    Plant3DEditor.this.setRootNode((P3DRootNode)((Object)Plant3DEditor.this.mapping.map(graph, (Object)Plant3DEditor.this.input)));
                    try {
                        P3DUtil.finalizeDBLoad(Plant3DEditor.this.rootNode);
                        Plant3DEditor.this.nodeMap = Plant3DEditor.this.createNodeMap(Plant3DEditor.this.getSession(), Plant3DEditor.this.mapping, (VtkView)Plant3DEditor.this.panel, Plant3DEditor.this.rootNode);
                    }
                    catch (Exception e) {
                        throw new DatabaseException((Throwable)e);
                    }
                }
            });
            if (this.rootNode == null) {
                throw new RuntimeException("Scenegraph loading failed.");
            }
            this.populate();
            this.selectionProvider = this.createSelectionProvider();
            this.cameraAction.addSelectionChangedListener(this.selectionProvider);
            this.cameraAction.addHoverChangedListener(this.createHoverHighlhighter());
            this.selectionProvider.addSelectionChangedListener(this.createSelectionHighlighter());
            this.getSite().setSelectionProvider(this.selectionProvider);
            this.getSite().getPage().addPostSelectionListener(this.selectionProvider);
            final IPartListener2 partListener2 = new IPartListener2(){

                public void partClosed(IWorkbenchPartReference partRef) {
                    if (partRef.getPart(false) != Plant3DEditor.this) {
                        return;
                    }
                    if (Plant3DEditor.this.panel != null && !Plant3DEditor.this.panel.isDisposed()) {
                        Plant3DEditor.this.setFocus();
                        GLContext ctx = Plant3DEditor.this.panel.getComponent().getContext();
                        if (ctx != null && !ctx.isCurrent()) {
                            ctx.makeCurrent();
                        }
                        Plant3DEditor.this.rootNode.enablePipingRules(false);
                        Plant3DEditor.this.nodeMap.delete();
                        Plant3DEditor.this.rootNode.enablePipingRules(true);
                        Plant3DEditor.this.mapping.dispose();
                        Plant3DEditor.this.panel.dispose();
                    }
                }
            };
            this.getSite().getPage().addPartListener(partListener2);
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Plant3DEditor.this.getSite().getPage().removePostSelectionListener(Plant3DEditor.this.selectionProvider);
                    Plant3DEditor.this.getSite().getPage().removePartListener(partListener2);
                }
            });
        }
        catch (DatabaseException e1) {
            ExceptionUtils.logAndShowError((String)"Cannot open Plant3D editor", (Throwable)e1);
            return;
        }
        this.createActions();
    }

    public void setUpDirection(int upDirection) {
        this.upDirection = upDirection;
    }

    protected vtkCameraAndSelectorAction createCameraAction() {
        return new vtkCameraAndSelectorAction(this.panel);
    }

    protected NodeSelectionProvider2<Resource, INode> createSelectionProvider() {
        return new NodeSelectionProvider2((IEditorPart)this, this.mapping, (VTKNodeMap)this.nodeMap);
    }

    protected HoverHighlighter<Resource> createHoverHighlhighter() {
        return new HoverHighlighter((VtkView)this.panel, (VTKNodeMap)this.nodeMap);
    }

    protected SelectionHighlighter<Resource> createSelectionHighlighter() {
        return new SelectionHighlighter((VtkView)this.panel, (VTKNodeMap)this.nodeMap);
    }

    protected String getLibraryUri() {
        return "http://www.simantics.org/Plant3D-0.1/Builtin";
    }

    protected void createActions() {
        this.focusAction = new FocusAction((VtkView)this.panel, this.cameraAction);
        this.translateAction = new TranslateAction(this.panel, (VTKNodeMap)this.nodeMap, this.toolComposite);
        this.translateInlineAction = new TranslateInlineAction(this.panel, (VTKNodeMap<?, ? extends INode>)this.nodeMap, this.toolComposite);
        this.translateFreeVariableLengthAction = new TranslateFreeVariableLengthAction(this.panel, this.getRootNode(), this.toolComposite);
        this.rotateAction = new RotateAction(this.panel, (VTKNodeMap)this.nodeMap, this.toolComposite);
        this.removeAction = new RemoveAction((VTKNodeMap)this.nodeMap);
        this.removeSplitAction = new RemoveAndSplitAction((VTKNodeMap<?, ? extends INode>)this.nodeMap);
        this.routePipeAction = new RoutePipeAction(this.panel, this.rootNode, this.toolComposite);
        this.addComponentAction = new AddComponentAction(this.panel, this.rootNode, this.getLibraryUri());
        this.reversePipeRunAction = new ReversePipeRunAction((VTKNodeMap<?, ? extends INode>)this.nodeMap);
    }

    public void populate() {
        ThreadUtils.asyncExec((IThreadWorkQueue)this.panel.getThreadQueue(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Plant3DEditor.this.nodeMap.setChangeTracking(false);
                Plant3DEditor.this.nodeMap.populate();
                Plant3DEditor.this.nodeMap.setChangeTracking(true);
                Plant3DEditor.this.panel.addListener(new RenderListener(){

                    public void preRender() {
                    }

                    public void postRender() {
                        (this).Plant3DEditor.this.panel.removeListener((RenderListener)this);
                        try {
                            P3DUtil.finalizeDBLoad2((this).Plant3DEditor.this.rootNode);
                            if ((this).Plant3DEditor.this.nodeMap.getMapping().isRangeModified()) {
                                (this).Plant3DEditor.this.nodeMap.commit("Load sync");
                            }
                        }
                        catch (Exception e) {
                            ExceptionUtils.logAndShowError((String)"Failed to load model correctly", (Throwable)e);
                        }
                        Plant3DEditor.this.onEditorInitializationComplete();
                        ArrayList<vtkProp3D> props = new ArrayList<vtkProp3D>();
                        Plant3DEditor.collectProps((INode)(this).Plant3DEditor.this.rootNode, props);
                        Plant3DEditor.this.fitToWindow(props);
                    }
                });
            }
        });
    }

    protected void onEditorInitializationComplete() {
    }

    protected IMappingSchema<Resource, INode> getSchema(ReadGraph graph) throws DatabaseException {
        IMappingSchema<Resource, INode> schema = SchemaBuilder.getSchema(graph);
        return schema;
    }

    protected P3DNodeMap createNodeMap(Session session, IMapping<Resource, INode> mapping, VtkView panel, P3DRootNode rootNode) {
        return new P3DNodeMap(session, mapping, panel, rootNode);
    }

    public void setFocus() {
        this.panel.getComponent().setFocus();
    }

    protected void createScene() {
        vtkRenderer ren1 = this.panel.getRenderer();
        boolean multiPass = false;
        boolean blur = false;
        boolean ssaa = false;
        boolean mblur = false;
        if (multiPass) {
            vtkLightsPass lightsPass = new vtkLightsPass();
            vtkDefaultPass defaultPass = new vtkDefaultPass();
            vtkRenderPassCollection passes = new vtkRenderPassCollection();
            passes.AddItem((vtkRenderPass)lightsPass);
            passes.AddItem((vtkRenderPass)defaultPass);
            vtkSequencePass seq = new vtkSequencePass();
            seq.SetPasses(passes);
            vtkCameraPass cameraPass = new vtkCameraPass();
            cameraPass.SetDelegatePass((vtkRenderPass)seq);
            if (blur) {
                vtkGaussianBlurPass blurPass = new vtkGaussianBlurPass();
                blurPass.SetDelegatePass((vtkRenderPass)cameraPass);
                ren1.SetPass((vtkRenderPass)blurPass);
            } else if (ssaa) {
                vtkSSAAPass ssaaPass = new vtkSSAAPass();
                ssaaPass.SetDelegatePass((vtkRenderPass)cameraPass);
                ren1.SetPass((vtkRenderPass)ssaaPass);
            } else if (mblur) {
                vtkSimpleMotionBlurPass mBlurPass = new vtkSimpleMotionBlurPass();
                mBlurPass.SetDelegatePass((vtkRenderPass)cameraPass);
                ren1.SetPass((vtkRenderPass)mBlurPass);
            } else {
                ren1.SetPass((vtkRenderPass)cameraPass);
            }
        }
        ren1.SetNearClippingPlaneTolerance(0.001);
        ren1.SetBackground2(1.0, 1.0, 1.0);
        ren1.SetBackground(0.9, 0.9, 0.9);
        ren1.SetGradientBackground(true);
        int dir = 1 << this.upDirection;
        GridDisplay gridDisplay = new GridDisplay((VtkView)this.panel, dir);
        gridDisplay.show();
        AxesDisplay axesDisplay = new AxesDisplay((VtkView)this.panel);
        axesDisplay.show();
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Plant3DEditor.this.createContextMenu(manager);
            }
        });
        this.contextMenu = menuMgr.createContextMenu((Control)this.parent);
    }

    protected void createContextMenu(IMenuManager m) {
        List selected = this.selectionProvider.getSelectedNodes();
        this.createFocusMenu(m, selected);
        m.add((IContributionItem)new Separator());
        try {
            if (selected.size() == 0) {
                m.add((IAction)new AddEquipmentAction(this.rootNode, this.getLibraryUri()));
            } else if (selected.size() == 1) {
                IP3DNode node = (IP3DNode)selected.get(0);
                if (node instanceof Equipment) {
                    m.add((IAction)this.translateAction);
                    m.add((IAction)this.rotateAction);
                    for (Item eq : P3DUtil.getNozzles((RequestProcessor)Simantics.getSession(), this.getLibraryUri())) {
                        AddNozzleAction add = new AddNozzleAction(this.rootNode, eq);
                        add.setEquipment((Equipment)node);
                        m.add((IAction)add);
                    }
                    m.add((IAction)this.removeAction);
                } else if (node instanceof Nozzle) {
                    Nozzle nozzle = (Nozzle)node;
                    if (!nozzle.isFixed()) {
                        m.add((IAction)this.translateAction);
                        m.add((IAction)this.rotateAction);
                    }
                    m.add((IAction)this.routePipeAction);
                    this.routePipeAction.setComponent(nozzle);
                    this.routePipeAction.setEnabled(nozzle.getNext() == null && nozzle.getPrevious() == null);
                    m.add((IAction)this.addComponentAction);
                    this.addComponentAction.setComponent(nozzle);
                    m.add((IAction)this.removeAction);
                } else if (node instanceof TurnComponent) {
                    m.add((IAction)this.translateAction);
                    TurnComponent component = (TurnComponent)node;
                    m.add((IAction)this.routePipeAction);
                    this.routePipeAction.setComponent(component);
                    this.routePipeAction.setEnabled(component.getNext() == null || component.getPrevious() == null);
                    m.add((IAction)this.addComponentAction);
                    this.addComponentAction.setComponent(component);
                    m.add((IAction)this.removeAction);
                    m.add((IAction)this.removeSplitAction);
                    this.removeSplitAction.setNode((INode)node);
                } else if (node instanceof EndComponent) {
                    m.add((IAction)this.translateAction);
                    m.add((IAction)this.addComponentAction);
                    this.addComponentAction.setComponent((PipelineComponent)node);
                    m.add((IAction)this.removeAction);
                } else if (node instanceof InlineComponent) {
                    InlineComponent component = (InlineComponent)node;
                    if (component.isVariableLength()) {
                        m.add((IAction)this.translateFreeVariableLengthAction);
                    } else {
                        m.add((IAction)this.translateInlineAction);
                    }
                    m.add((IAction)this.routePipeAction);
                    this.routePipeAction.setComponent(component);
                    m.add((IAction)this.addComponentAction);
                    this.addComponentAction.setComponent(component);
                    m.add((IAction)this.removeAction);
                    m.add((IAction)this.removeSplitAction);
                    this.removeSplitAction.setNode((INode)node);
                } else if (node instanceof PipeRun) {
                    m.add((IAction)this.reversePipeRunAction);
                    m.add((IAction)this.removeAction);
                    this.reversePipeRunAction.setNode((INode)node);
                } else {
                    m.add((IAction)this.removeAction);
                }
                this.translateAction.setNode((IG3DNode)node);
                this.translateInlineAction.setNode(node);
                this.translateFreeVariableLengthAction.setNode(node);
                this.rotateAction.setNode((IG3DNode)node);
                this.removeAction.setNode((INode)node);
            }
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
    }

    protected void createFocusMenu(IMenuManager m, List<INode> selected) {
        m.add(this.createFitToWindowAction(selected));
        if (!selected.isEmpty()) {
            ArrayList<vtkProp3D> actors = new ArrayList<vtkProp3D>();
            for (INode n : selected) {
                Plant3DEditor.collectProps(n, actors);
            }
            if (actors.size() > 0) {
                this.focusAction.setProps(new ArrayList<vtkProp3D>(actors));
                m.add((IAction)this.focusAction);
            }
        }
    }

    protected IAction createFitToWindowAction(List<INode> selected) {
        return new FitToWindow(selected);
    }

    private IContentOutlinePage createOutline() {
        if (this.rootNode == null || this.selectionProvider == null) {
            return null;
        }
        P3DContentOutlinePage outlinePage = new P3DContentOutlinePage(this.rootNode, this.selectionProvider){

            @Override
            protected void createContextMenu(IMenuManager manager) {
                Plant3DEditor.this.createContextMenu(manager);
            }
        };
        outlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Plant3DEditor.this.selectionProvider.selectionChanged(event);
            }
        });
        return outlinePage;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(IPropertyPage.class)) {
            return adapter.cast(new StandardPropertyPage(this.getSite(), this.getPropertyContexts()));
        }
        if (adapter.isAssignableFrom(ISelectionProvider.class)) {
            return adapter.cast(this.selectionProvider);
        }
        if (adapter.isAssignableFrom(IContentOutlinePage.class)) {
            return adapter.cast(this.createOutline());
        }
        if (adapter.isAssignableFrom(NodeMap.class)) {
            return adapter.cast((Object)this.nodeMap);
        }
        if (adapter.isAssignableFrom(INode.class)) {
            return adapter.cast((Object)this.rootNode);
        }
        if (adapter.isAssignableFrom(IMapping.class)) {
            return adapter.cast(this.mapping);
        }
        if (adapter.isAssignableFrom(VtkView.class)) {
            return adapter.cast(this.panel);
        }
        return (T)super.getAdapter(adapter);
    }

    public Set<String> getPropertyContexts() {
        HashSet<String> result = new HashSet<String>();
        result.add("http://www.simantics.org/Project-1.2/ProjectBrowseContext");
        result.add("http://www.simantics.org/Plant3D-0.1/P3DSelectionBrowseContext");
        return result;
    }

    public InteractiveVtkComposite getPanel() {
        return this.panel;
    }

    public P3DRootNode getRootNode() {
        return this.rootNode;
    }

    protected void setRootNode(P3DRootNode rootNode) {
        this.rootNode = rootNode;
    }

    public IMapping<Resource, INode> getMapping() {
        return this.mapping;
    }

    public P3DNodeMap getNodeMap() {
        return this.nodeMap;
    }

    public void fitToWindow(Collection<vtkProp3D> props) {
        this.cameraAction.fitToView(props);
    }

    protected static void collectProps(INode node, List<vtkProp3D> props) {
        if (node instanceof IP3DVisualNode) {
            props.addAll(((IP3DVisualNode)node).getActors());
        }
        if (node instanceof ParentNode) {
            for (INode n : ((ParentNode)node).getNodes()) {
                Plant3DEditor.collectProps(n, props);
            }
        }
    }

    protected class FitToWindow
    extends Action {
        private List<INode> selected;

        public FitToWindow(List<INode> selected) {
            super("Fit to Window");
            this.selected = selected;
        }

        public void run() {
            ArrayList<vtkProp3D> props = new ArrayList<vtkProp3D>();
            List<INode> collection = !this.selected.isEmpty() ? this.selected : Plant3DEditor.this.getRootNode().getChild();
            for (INode n : collection) {
                Plant3DEditor.collectProps(n, props);
            }
            Plant3DEditor.this.fitToWindow(props);
            Plant3DEditor.this.getPanel().refresh();
        }
    }
}

