/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.actions;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.simantics.db.Resource;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.math.Ray;
import org.simantics.g3d.scenegraph.NodeMap;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.toolbar.ToolComposite;
import org.simantics.g3d.tools.ConstraintDetector;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.gizmo.TranslateAxisGizmo;
import org.simantics.g3d.vtk.swt.InteractiveVtkComposite;
import org.simantics.g3d.vtk.swt.vtkSwtAction;
import org.simantics.g3d.vtk.utils.vtkUtil;
import org.simantics.plant3d.Activator;
import org.simantics.plant3d.gizmo.ConstraintPointGizmo;
import org.simantics.plant3d.gizmo.SplitPointSelectionGizmo;
import org.simantics.plant3d.gizmo.TerminalSelectionGizmo;
import org.simantics.plant3d.scenegraph.EndComponent;
import org.simantics.plant3d.scenegraph.InlineComponent;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.TurnComponent;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import org.simantics.plant3d.utils.ComponentUtils;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ExceptionUtils;
import vtk.vtkProp;
import vtk.vtkRenderer;
import vtk.vtkTextActor;

public class RoutePipeAction
extends vtkSwtAction {
    LockType lock = LockType.NONE;
    boolean lockForced;
    private double BRANCH_SNAP_DISTANCE = 0.05;
    private double NOZZLE_SNAP_DISTANCE = 0.05;
    private static double BRANCH_DOT_PRODUCT = 0.95;
    private static double ALIGN_DOT_PRODUCT = 0.99;
    private double istep = 10.0;
    private int decimals = 2;
    private P3DRootNode root;
    protected PipelineComponent startComponent;
    protected PipeRun pipeRun;
    private boolean allowBranches;
    protected TranslateAxisGizmo translateAxisGizmo = new TranslateAxisGizmo();
    private SplitPointSelectionGizmo splitPointSelectionGizmo;
    private ConstraintPointGizmo constraintPointGizmo;
    private TerminalSelectionGizmo terminalSelectionGizmo;
    private NodeMap<Resource, vtkProp, INode> nodeMap;
    protected ToolState state = ToolState.NOT_ACTIVE;
    private ConstraintDetector detector;
    protected boolean useDefault = false;
    protected Vector3d direction = null;
    protected Vector3d previousPosition = null;
    protected Vector3d currentPosition = null;
    boolean step = false;
    PipelineComponent endTo = null;
    PipeControlPoint.PositionType endType = null;
    PipeControlPoint endPort = null;
    boolean reversed = false;
    private Set<PipeControlPoint.PositionType> allowed = new HashSet<PipeControlPoint.PositionType>();
    protected ToolComposite toolComposite;
    protected Combo axisCombo;
    protected Button cameraButton;
    protected List<PipelineComponent> added = new ArrayList<PipelineComponent>();
    boolean startRemovable = false;
    INode hoverObject = null;
    vtkTextActor infoActor;

    public RoutePipeAction(InteractiveVtkComposite panel, P3DRootNode root, ToolComposite toolComposite) {
        this(panel, root, toolComposite, true);
    }

    public RoutePipeAction(InteractiveVtkComposite panel, P3DRootNode root, ToolComposite toolComposite, boolean allowBranches) {
        super(panel);
        this.root = root;
        this.allowBranches = allowBranches;
        this.setText("Route Pipe");
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.simantics.plant3d", (String)"icons/Straight.png"));
        this.nodeMap = root.getNodeMap();
        this.splitPointSelectionGizmo = new SplitPointSelectionGizmo((VtkView)panel);
        this.terminalSelectionGizmo = new TerminalSelectionGizmo((VtkView)panel);
        this.constraintPointGizmo = new ConstraintPointGizmo((VtkView)panel);
        this.detector = new org.simantics.g3d.vtk.swt.ConstraintDetector((VtkView)panel);
        this.toolComposite = toolComposite;
    }

    public void setComponent(PipelineComponent component) {
        this.startComponent = component;
        this.allowed.clear();
        if (this.startComponent.getNext() == null) {
            this.allowed.add(PipeControlPoint.PositionType.NEXT);
        }
        if (this.startComponent.getPrevious() == null && !(this.startComponent instanceof Nozzle)) {
            this.allowed.add(PipeControlPoint.PositionType.PREVIOUS);
        }
        if (this.allowBranches && this.startComponent instanceof InlineComponent && !this.startComponent.getControlPoint().isFixedLength()) {
            this.allowed.add(PipeControlPoint.PositionType.SPLIT);
        }
        this.setEnabled(this.allowed.size() > 0);
    }

    protected void createTools(ToolComposite toolComposite) {
        Label label = new Label((Composite)toolComposite, 8);
        label.setText("Route direction:");
        this.axisCombo = new Combo((Composite)toolComposite, 8);
        this.axisCombo.add("X");
        this.axisCombo.add("Y");
        this.axisCombo.add("Z");
        this.axisCombo.add("XY");
        this.axisCombo.add("XZ");
        this.axisCombo.add("YZ");
        this.axisCombo.add("None");
        this.axisCombo.add("Custom");
        this.axisCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo c = (Combo)e.getSource();
                RoutePipeAction.this.setLockType(LockType.values()[c.getSelectionIndex()], false);
                RoutePipeAction.this.panel.getComponent().setFocus();
            }
        });
        this.axisCombo.select(this.lock.ordinal());
        this.cameraButton = new Button((Composite)toolComposite, 2);
        this.cameraButton.setText("Camera");
        this.cameraButton.setSelection(this.useDefault);
        this.cameraButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RoutePipeAction.this.setUseDefault(((Button)e.getSource()).getSelection());
                RoutePipeAction.this.panel.getComponent().setFocus();
            }
        });
        Button close = new Button((Composite)toolComposite, 8);
        close.setText("Close");
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RoutePipeAction.this.panel.useDefaultAction();
            }
        });
        toolComposite.relayout();
    }

    public void deattach() {
        this.deactivate();
        this.setDBUndo(true);
        if (this.toolComposite != null) {
            this.toolComposite.clear();
            this.axisCombo = null;
            this.cameraButton = null;
        }
        this.startComponent = null;
        this.deattachUI();
        super.deattach();
        this.panel.refresh();
    }

    public void attach() {
        if (this.startComponent == null) {
            return;
        }
        if (this.toolComposite != null) {
            this.createTools(this.toolComposite);
        }
        this.setDBUndo(false);
        super.attach();
        ThreadUtils.asyncExec((IThreadWorkQueue)this.panel.getThreadQueue(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    RoutePipeAction.this.activate();
                }
                catch (Exception e) {
                    RoutePipeAction.this.deattach();
                    ExceptionUtils.logAndShowError((Throwable)e);
                }
            }
        });
    }

    private void deattachUI() {
        this.panel.lock();
        if (this.translateAxisGizmo.isAttached()) {
            this.translateAxisGizmo.deattach();
        }
        if (this.splitPointSelectionGizmo.isAttached()) {
            this.splitPointSelectionGizmo.deattach();
        }
        if (this.terminalSelectionGizmo.isAttached()) {
            this.terminalSelectionGizmo.deattach();
        }
        if (this.constraintPointGizmo.isAttached()) {
            this.constraintPointGizmo.deattach();
        }
        if (this.infoActor != null) {
            this.panel.getRenderer().RemoveActor((vtkProp)this.infoActor);
            this.infoActor.Delete();
            this.infoActor = null;
        }
        this.panel.unlock();
    }

    public boolean keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.panel.useDefaultAction();
        }
        if (this.lock != LockType.CUSTOM || !this.lockForced) {
            if ((e.getModifiersEx() & 0x40) > 0) {
                if (e.getKeyCode() == 88) {
                    if (this.lock != LockType.XY && this.lock != LockType.XZ) {
                        this.setLockType(LockType.XY, false);
                    } else if (this.lock == LockType.XY) {
                        this.setLockType(LockType.XZ, false);
                    } else {
                        this.setLockType(LockType.NONE, false);
                    }
                }
                if (e.getKeyCode() == 89) {
                    if (this.lock != LockType.XY && this.lock != LockType.YZ) {
                        this.setLockType(LockType.XY, false);
                    } else if (this.lock == LockType.XY) {
                        this.setLockType(LockType.YZ, false);
                    } else {
                        this.setLockType(LockType.NONE, false);
                    }
                }
                if (e.getKeyCode() == 90) {
                    if (this.lock != LockType.XZ && this.lock != LockType.YZ) {
                        this.setLockType(LockType.XZ, false);
                    } else if (this.lock == LockType.XZ) {
                        this.setLockType(LockType.YZ, false);
                    } else {
                        this.setLockType(LockType.NONE, false);
                    }
                }
            } else {
                if (e.getKeyCode() == 88) {
                    if (this.lock != LockType.X) {
                        this.setLockType(LockType.X, false);
                    } else {
                        this.setLockType(LockType.NONE, false);
                    }
                }
                if (e.getKeyCode() == 89) {
                    if (this.lock != LockType.Y) {
                        this.setLockType(LockType.Y, false);
                    } else {
                        this.setLockType(LockType.NONE, false);
                    }
                }
                if (e.getKeyCode() == 90) {
                    if (this.lock != LockType.Z) {
                        this.setLockType(LockType.Z, false);
                    } else {
                        this.setLockType(LockType.NONE, false);
                    }
                }
                if (e.getKeyCode() == 76 && this.direction != null) {
                    if (this.lock != LockType.CUSTOM) {
                        this.setLockType(LockType.CUSTOM, false);
                    } else {
                        this.setLockType(LockType.NONE, false);
                    }
                }
            }
        }
        if (e.getKeyCode() == 67) {
            this.setUseDefault(!this.useDefault);
        }
        this.update();
        return true;
    }

    private void setUseDefault(boolean b) {
        this.useDefault = b;
        if (this.useDefault) {
            this.setInfoText("Rotating camera");
        }
        if (this.cameraButton != null) {
            this.cameraButton.setSelection(this.useDefault);
        }
    }

    private void update() {
        this.panel.refresh();
    }

    private void update(double x, double y) {
        switch (this.state) {
            case NOT_ACTIVE: {
                return;
            }
            case INITIALIZING: {
                return;
            }
            case SELECTING_POSITION: {
                return;
            }
            case SELECTING_SPLIT: {
                return;
            }
            case ROUTING: {
                this.updateRouting(x, y);
            }
        }
    }

    protected void activate() throws Exception {
        this.state = ToolState.INITIALIZING;
        this.added.clear();
        if (this.allowed.size() == 1) {
            this.pipeRun = this.startComponent.getPipeRun();
            PipeControlPoint start = this.startComponent.getControlPoint();
            boolean requiresBranching = false;
            if (start.getNext() == null) {
                this.reversed = false;
            } else if (start.getPrevious() == null) {
                this.reversed = true;
            } else {
                requiresBranching = true;
            }
            if (requiresBranching) {
                this.activateSplit(start);
            } else {
                this.activateNextPrev(start);
            }
        } else {
            if (this.allowed.size() == 0) {
                this.panel.useDefaultAction();
                this.state = ToolState.NOT_ACTIVE;
                return;
            }
            this.terminalSelectionGizmo.setComponent(this.startComponent, this.allowed);
            this.terminalSelectionGizmo.attach((VtkView)this.panel);
            this.state = ToolState.SELECTING_POSITION;
            this.update();
        }
    }

    protected void activateNextPrev(PipeControlPoint start) throws Exception {
        if (!this.reversed && start.isDualInline()) {
            start = start.getDualSub();
        } else if (this.reversed && start.isDualSub()) {
            start = start.parent;
        }
        this.pipeRun = start.getPipeRun();
        this.setPreviousPosition(start.getWorldPosition());
        boolean startWithTurn = false;
        if (this.startComponent instanceof Nozzle) {
            this.direction = this.startComponent.getControlPoint().getDirectedControlPointDirection();
            this.lock = LockType.CUSTOM;
            this.lockForced = true;
        } else if (this.startComponent instanceof PipelineComponent) {
            if (this.startComponent instanceof InlineComponent) {
                this.direction = this.startComponent.getControlPoint().getInlineDir();
                if (this.reversed) {
                    this.direction.negate();
                }
                this.lock = LockType.CUSTOM;
                this.lockForced = true;
                if (((InlineComponent)this.startComponent).isVariableLength()) {
                    startWithTurn = true;
                    this.direction = null;
                    this.lock = LockType.NONE;
                    this.lockForced = false;
                }
                Vector3d v = new Vector3d();
                if (!this.reversed) {
                    start.getControlPointEnds((Tuple3d)v, (Tuple3d)this.previousPosition);
                } else {
                    start.getControlPointEnds((Tuple3d)this.previousPosition, (Tuple3d)v);
                }
            } else if (this.startComponent instanceof TurnComponent) {
                if (start.asFixedAngle()) {
                    this.direction = this.startComponent.getControlPoint().getPathLegDirection(this.reversed ? PipeControlPoint.Direction.PREVIOUS : PipeControlPoint.Direction.NEXT);
                    this.lock = LockType.CUSTOM;
                    this.lockForced = start.isFixedAngle();
                } else {
                    this.direction = null;
                    this.lock = LockType.NONE;
                    this.lockForced = false;
                }
            } else if (this.startComponent instanceof EndComponent) {
                throw new Exception("Not supported");
            }
        } else {
            throw new Exception("Not supported");
        }
        this.currentPosition = new Vector3d(this.previousPosition);
        this.state = ToolState.ROUTING;
        if (this.direction != null) {
            this.direction.normalize();
        }
        this.startRemovable = start.isDeletable();
        start.setDeletable(false);
        if (startWithTurn) {
            this.addPoint();
        } else {
            if (this.direction != null) {
                this.currentPosition.add((Tuple3d)this.direction);
            }
            InlineComponent straight = ComponentUtils.createStraight(this.root);
            PipeControlPoint straightCP = straight.getControlPoint();
            straight.setName(this.pipeRun.getUniqueName("Pipe"));
            this.pipeRun.addChild(straight);
            this.added.add(straight);
            if (!this.reversed) {
                start.setNext(straightCP);
                straightCP.setPrevious(start);
            } else {
                start.setPrevious(straightCP);
                straightCP.setNext(start);
            }
        }
        this.translateAxisGizmo.attach((VtkView)this.panel);
        this.setPreviousPosition(this.previousPosition);
        this.updateCurrentPoint();
        this.updateWidget();
    }

    protected void setPreviousPosition(Vector3d v) {
        this.previousPosition = new Vector3d(v);
        if (this.translateAxisGizmo.isAttached()) {
            this.translateAxisGizmo.setPosition((Tuple3d)this.previousPosition);
        }
    }

    private void activateBranch(PipeControlPoint start) throws Exception {
        this.pipeRun = start.getPipeRun();
        this.setPreviousPosition(start.getWorldPosition());
        this.direction = null;
        this.lock = LockType.NONE;
        this.currentPosition = new Vector3d(this.previousPosition);
        this.state = ToolState.ROUTING;
        if (this.direction != null) {
            this.direction.normalize();
        }
        this.startRemovable = start.isDeletable();
        start.setDeletable(false);
        if (this.direction != null) {
            this.currentPosition.add((Tuple3d)this.direction);
        }
        InlineComponent straight = ComponentUtils.createStraight(this.root);
        PipeControlPoint straightCP = straight.getControlPoint();
        straight.setName(this.pipeRun.getUniqueName("Pipe"));
        this.pipeRun.addChild(straight);
        this.added.add(straight);
        if (!this.reversed) {
            start.setNext(straightCP);
            straightCP.setPrevious(start);
        } else {
            start.setPrevious(straightCP);
            straightCP.setNext(start);
        }
        this.translateAxisGizmo.attach((VtkView)this.panel);
        this.setPreviousPosition(this.previousPosition);
        this.updateCurrentPoint();
        this.updateWidget();
    }

    private void activateSplit(PipeControlPoint start) throws Exception {
        Point3d p1 = new Point3d();
        Point3d p2 = new Point3d();
        start.getInlineControlPointEnds((Tuple3d)p1, (Tuple3d)p2);
        this.splitPointSelectionGizmo.setSplit(p1, p2);
        this.splitPointSelectionGizmo.attach((VtkView)this.panel);
        this.state = ToolState.SELECTING_SPLIT;
    }

    public void deactivate() {
        if (this.added.size() > 0) {
            for (PipelineComponent component : this.added) {
                component.getControlPoint().setDeletable(true);
            }
            for (PipelineComponent comp : this.added) {
                comp.getControlPoint().requestUpdate();
            }
            try {
                this.root.updatePipingRules();
                this.nodeMap.commit("Route pipe");
            }
            catch (Exception e) {
                ExceptionUtils.logAndShowError((Throwable)e);
            }
            this.added.clear();
        }
        this.startComponent.getControlPoint().setDeletable(this.startRemovable);
        this.direction = null;
        this.setLockType(LockType.NONE, true);
        this.startComponent = null;
        this.endTo = null;
        this.endPort = null;
        this.endType = null;
        this.pipeRun = null;
        this.allowed.clear();
        this.currentPosition = null;
        this.previousPosition = null;
        this.startRemovable = false;
        this.detector.clearConstraintHighlights();
        this.state = ToolState.NOT_ACTIVE;
        this.setEnabled(false);
    }

    private void setLockType(LockType type, boolean force) {
        if ((type != LockType.CUSTOM || this.direction != null && this.added.size() <= 0) && (force || this.lock != LockType.CUSTOM || !this.lockForced || this.added.size() > 0)) {
            this.lock = type;
            switch (this.lock) {
                case NONE: 
                case CUSTOM: {
                    this.translateAxisGizmo.setType(6);
                    break;
                }
                case X: {
                    this.translateAxisGizmo.setType(0);
                    break;
                }
                case Y: {
                    this.translateAxisGizmo.setType(1);
                    break;
                }
                case Z: {
                    this.translateAxisGizmo.setType(2);
                    break;
                }
                case XY: {
                    this.translateAxisGizmo.setType(3);
                    break;
                }
                case XZ: {
                    this.translateAxisGizmo.setType(4);
                    break;
                }
                case YZ: {
                    this.translateAxisGizmo.setType(5);
                }
            }
        }
        this.updateWidget();
    }

    private void updateWidget() {
        if (this.axisCombo != null) {
            this.axisCombo.select(this.lock.ordinal());
            this.axisCombo.setEnabled(!this.lockForced || this.lock != LockType.CUSTOM);
        }
    }

    public boolean mousePressed(MouseEvent e) {
        if (this.useDefault) {
            this.getDefaultAction().mousePressed(e);
        }
        return true;
    }

    public boolean mouseReleased(MouseEvent e) {
        if (this.useDefault) {
            this.getDefaultAction().mouseReleased(e);
        }
        return true;
    }

    public boolean mouseWheelMoved(MouseWheelEvent e) {
        if (this.useDefault) {
            this.getDefaultAction().mouseWheelMoved(e);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mouseClicked(MouseEvent e) {
        if (this.useDefault) {
            this.getDefaultAction().mouseClicked(e);
            return true;
        }
        if (this.state == ToolState.ROUTING) {
            try {
                if (e.getClickCount() != 1) return true;
                if (e.getButton() == 1) {
                    if (this.added.size() <= 0) throw new RuntimeException("RoutePipeAction initialization has failed, no added components found");
                    this.setLockType(LockType.NONE, true);
                    if (this.endTo != null) {
                        this.endPiping();
                        return true;
                    } else {
                        this.addPoint();
                    }
                    return true;
                }
                if (e.getButton() == 2) {
                    this.updateConstraints();
                    return true;
                }
                if (e.getButton() != 3) return true;
                this.endPiping();
                return true;
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            return true;
        }
        if (this.state == ToolState.SELECTING_POSITION) {
            if (e.getClickCount() != 1 || e.getButton() != 1) return true;
            int type = this.panel.getPickType();
            this.panel.setPickType(5);
            vtkProp[] picked = this.panel.pick(e.getX(), e.getY());
            this.panel.setPickType(type);
            PipeControlPoint.PositionType position = this.terminalSelectionGizmo.getPickedPosition(picked);
            if (position == null) return true;
            this.terminalSelectionGizmo.deattach();
            try {
                if (position == PipeControlPoint.PositionType.SPLIT) {
                    this.activateSplit(this.startComponent.getControlPoint());
                    return true;
                }
                if (position == PipeControlPoint.PositionType.NEXT || position == PipeControlPoint.PositionType.PREVIOUS) {
                    this.reversed = position == PipeControlPoint.PositionType.PREVIOUS;
                    this.activateNextPrev(this.startComponent.getControlPoint());
                    return true;
                }
                this.panel.useDefaultAction();
                return true;
            }
            catch (Exception err) {
                ExceptionUtils.logAndShowError((Throwable)err);
                this.panel.useDefaultAction();
            }
            return true;
        }
        if (this.state != ToolState.SELECTING_SPLIT || e.getClickCount() != 1 || e.getButton() != 1) return true;
        Tuple3d t = this.splitPointSelectionGizmo.getSplitPoint();
        this.splitPointSelectionGizmo.deattach();
        if (t == null) {
            this.panel.useDefaultAction();
            return true;
        }
        try {
            Vector3d pos = new Vector3d(t);
            InlineComponent branchSplit = ComponentUtils.createBranchSplit((InlineComponent)this.startComponent, pos);
            PipeControlPoint branchSplitCP = branchSplit.getControlPoint();
            this.reversed = false;
            PipeRun newRun = new PipeRun();
            String n = this.root.getUniqueName("PipeRun");
            newRun.setName(n);
            this.root.addChild((INode)newRun);
            PipeControlPoint pcp = new PipeControlPoint(branchSplit, newRun);
            branchSplitCP.children.add(pcp);
            pcp.parent = branchSplitCP;
            pcp.setWorldOrientation(branchSplitCP.getWorldOrientation());
            pcp.setWorldPosition(branchSplitCP.getWorldPosition());
            this.startComponent = branchSplit;
            this.activateBranch(pcp);
            return true;
        }
        catch (Exception err) {
            ExceptionUtils.logAndShowError((Throwable)err);
            this.panel.useDefaultAction();
        }
        return true;
    }

    private void updateConstraints() {
        this.detector.clearConstraints();
        this.constraintPointGizmo.clearPositions();
        if (this.hoverObject == null) {
            if (this.constraintPointGizmo.isAttached()) {
                this.constraintPointGizmo.deattach();
            }
            return;
        }
        if (this.hoverObject instanceof Nozzle) {
            n = (Nozzle)this.hoverObject;
            this.detector.addContraintPoint(new Point3d((Tuple3d)n.getWorldPosition()));
        } else if (this.hoverObject instanceof InlineComponent) {
            InlineComponent c = (InlineComponent)this.hoverObject;
            Point3d p1 = new Point3d();
            Point3d p2 = new Point3d();
            c.getEnds((Tuple3d)p1, (Tuple3d)p2);
            this.detector.addContraintPoint(p1);
            this.detector.addContraintPoint(p2);
            this.detector.addContraintPoint(new Point3d((Tuple3d)c.getWorldPosition()));
        } else if (this.hoverObject instanceof TurnComponent) {
            n = (TurnComponent)this.hoverObject;
            this.detector.addContraintPoint(new Point3d((Tuple3d)n.getWorldPosition()));
        }
        if (this.detector.getConstraintPoints().size() > 0) {
            for (Point3d p : this.detector.getConstraintPoints()) {
                this.constraintPointGizmo.addPosition(new Vector3d((Tuple3d)p));
            }
            if (this.constraintPointGizmo.isAttached()) {
                this.constraintPointGizmo.deattach();
            }
            this.constraintPointGizmo.attach((VtkView)this.panel);
        }
    }

    public boolean mouseMoved(MouseEvent e) {
        if (this.useDefault) {
            this.getDefaultAction().mouseMoved(e);
            return true;
        }
        this.step = (e.getModifiers() & 2) > 0;
        this.update(e.getX(), e.getY());
        return true;
    }

    public boolean mouseDragged(MouseEvent e) {
        if (this.useDefault) {
            this.getDefaultAction().mouseDragged(e);
        }
        return true;
    }

    private List<INode> isOverNode(int x, int y) {
        ArrayList<INode> nodes = new ArrayList<INode>();
        vtkProp[] picked = this.panel.pick2(x, y);
        if (picked != null) {
            int i = 0;
            while (i < picked.length) {
                nodes.add(this.nodeMap.getNode((Object)picked[i]));
                ++i;
            }
        }
        return nodes;
    }

    protected void updateRouting(double x, double y) {
        if (this.useDefault) {
            return;
        }
        this.endTo = null;
        this.endType = null;
        this.endPort = null;
        Ray ray = vtkUtil.createMouseRay((vtkRenderer)this.panel.getRenderer(), (double)x, (double)y);
        Vector3d o = new Vector3d((Tuple3d)ray.pos);
        Vector3d d = ray.dir;
        if (!this.updateCurrentPoint(o, d)) {
            return;
        }
        double[] mu = new double[2];
        List<INode> hover = this.isOverNode((int)x, (int)y);
        this.hoverObject = hover.size() > 0 ? hover.get(0) : null;
        if (this.hoverObject != null && this.hoverObject.equals(this.getLast())) {
            boolean set = false;
            int i = 1;
            while (i < hover.size()) {
                this.hoverObject = hover.get(i);
                if (!this.getLast().equals(this.hoverObject)) {
                    set = true;
                    break;
                }
                ++i;
            }
            if (!set) {
                this.hoverObject = null;
            }
        }
        if (this.hoverObject != null) {
            if (this.lock == LockType.NONE) {
                if (this.hoverObject instanceof Nozzle && this.endingToNozzle(this.hoverObject, o, d)) {
                    this.endTo = (Nozzle)this.hoverObject;
                } else if (this.hoverObject instanceof InlineComponent && ((InlineComponent)this.hoverObject).isVariableLength()) {
                    this.endTo = (InlineComponent)this.hoverObject;
                    this.endType = this.endingToStraight((INode)this.endTo, mu, o, d);
                    if (this.endType == null) {
                        this.endTo = null;
                    }
                } else if (this.hoverObject instanceof PipelineComponent && (this.endPort = this.endingToComponent(this.hoverObject, o, d)) != null) {
                    this.endTo = (PipelineComponent)this.hoverObject;
                } else {
                    this.updateRoute(o, d);
                }
            } else if (this.hoverObject instanceof InlineComponent && ((InlineComponent)this.hoverObject).isVariableLength() && (this.endType = this.endingLockToStraight(this.hoverObject, mu, new Point3d((Tuple3d)this.currentPosition))) != null) {
                this.endTo = (InlineComponent)this.hoverObject;
            } else if (this.hoverObject instanceof Nozzle && this.endingLockToNozzle(this.hoverObject)) {
                this.endTo = (Nozzle)this.hoverObject;
            } else if (this.hoverObject instanceof PipelineComponent && (this.endPort = this.endingLockToComponent(this.hoverObject)) != null) {
                this.endTo = (PipelineComponent)this.hoverObject;
            } else {
                this.updateRoute(o, d);
            }
            if (this.added.contains(this.endTo)) {
                this.endTo = null;
            }
        } else {
            this.updateRoute(o, d);
        }
        this.panel.refresh();
    }

    protected boolean updateCurrentPoint(Vector3d o, Vector3d d) {
        Vector3d point = new Vector3d(this.previousPosition);
        switch (this.lock) {
            case X: {
                MathTools.intersectStraightStraight((Tuple3d)point, (Vector3d)new Vector3d(1.0, 0.0, 0.0), (Tuple3d)o, (Vector3d)d, (Tuple3d)this.currentPosition, (Tuple3d)new Vector3d());
                if (!this.step) break;
                this.currentPosition.x = (double)Math.round(this.istep * this.currentPosition.x) / this.istep;
                BigDecimal bx = new BigDecimal(this.currentPosition.x);
                bx.setScale(this.decimals, 4);
                this.currentPosition.x = bx.doubleValue();
                break;
            }
            case Y: {
                MathTools.intersectStraightStraight((Tuple3d)point, (Vector3d)new Vector3d(0.0, 1.0, 0.0), (Tuple3d)o, (Vector3d)d, (Tuple3d)this.currentPosition, (Tuple3d)new Vector3d());
                if (!this.step) break;
                this.currentPosition.y = (double)Math.round(this.istep * this.currentPosition.y) / this.istep;
                BigDecimal bx = new BigDecimal(this.currentPosition.y);
                bx.setScale(this.decimals, 4);
                this.currentPosition.y = bx.doubleValue();
                break;
            }
            case Z: {
                MathTools.intersectStraightStraight((Tuple3d)point, (Vector3d)new Vector3d(0.0, 0.0, 1.0), (Tuple3d)o, (Vector3d)d, (Tuple3d)this.currentPosition, (Tuple3d)new Vector3d());
                if (!this.step) break;
                this.currentPosition.z = (double)Math.round(this.istep * this.currentPosition.z) / this.istep;
                BigDecimal bx = new BigDecimal(this.currentPosition.z);
                bx.setScale(this.decimals, 4);
                this.currentPosition.z = bx.doubleValue();
                break;
            }
            case XY: {
                MathTools.intersectStraightPlane((Tuple3d)o, (Vector3d)d, (Tuple3d)point, (Vector3d)new Vector3d(0.0, 0.0, 1.0), (Tuple3d)this.currentPosition);
                break;
            }
            case XZ: {
                MathTools.intersectStraightPlane((Tuple3d)o, (Vector3d)d, (Tuple3d)point, (Vector3d)new Vector3d(0.0, 1.0, 0.0), (Tuple3d)this.currentPosition);
                break;
            }
            case YZ: {
                MathTools.intersectStraightPlane((Tuple3d)o, (Vector3d)d, (Tuple3d)point, (Vector3d)new Vector3d(1.0, 0.0, 0.0), (Tuple3d)this.currentPosition);
                break;
            }
            case NONE: {
                Vector3d normal = new Vector3d(this.panel.getRenderer().GetActiveCamera().GetDirectionOfProjection());
                normal.normalize();
                MathTools.intersectStraightPlane((Tuple3d)o, (Vector3d)d, (Tuple3d)point, (Vector3d)normal, (Tuple3d)this.currentPosition);
                break;
            }
            case CUSTOM: {
                MathTools.intersectStraightStraight((Tuple3d)point, (Vector3d)new Vector3d(this.direction), (Tuple3d)o, (Vector3d)d, (Tuple3d)this.currentPosition, (Tuple3d)new Vector3d());
                double dist = MathTools.distanceFromPlane((Vector3d)new Vector3d(this.currentPosition), (Vector3d)this.direction, (Tuple3d)this.previousPosition);
                if (!(dist < 0.0)) break;
                this.currentPosition.set((Tuple3d)this.previousPosition);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private Vector3d getLockDir() {
        switch (this.lock) {
            case CUSTOM: {
                return this.direction;
            }
            case X: {
                return new Vector3d(1.0, 0.0, 0.0);
            }
            case Y: {
                return new Vector3d(0.0, 1.0, 0.0);
            }
            case Z: {
                return new Vector3d(0.0, 0.0, 1.0);
            }
        }
        return null;
    }

    protected void updateRoute(Vector3d o, Vector3d d) {
        this.detector.clearConstraintHighlights();
        Point3d previousPipePoint = new Point3d((Tuple3d)this.previousPosition);
        Object s = "";
        if (this.lock == LockType.NONE) {
            Point3d p = this.detector.getSnappedPoint(o, d, new Vector3d((Tuple3d)previousPipePoint));
            if (p != null) {
                this.currentPosition = new Vector3d((Tuple3d)p);
            }
            s = (String)s + this.detector.getSnapString();
        } else {
            Vector3d dir = new Vector3d(this.currentPosition);
            dir.sub((Tuple3d)previousPipePoint);
            Point3d p = this.detector.getPointSnap(new Vector3d((Tuple3d)previousPipePoint), dir);
            if (p != null) {
                this.currentPosition = new Vector3d((Tuple3d)p);
            }
            s = (String)s + this.detector.getSnapString();
        }
        this.updateCurrentPoint();
        s = (String)s + this.currentPosition.toString();
        this.setInfoText((String)s);
    }

    private void setInfoText(String text) {
        if (this.infoActor == null) {
            this.infoActor = new vtkTextActor();
            this.infoActor.GetTextProperty().SetColor(0.0, 0.0, 0.0);
            this.infoActor.GetTextProperty().ShadowOff();
            this.infoActor.GetTextProperty().ItalicOff();
            this.infoActor.GetTextProperty().BoldOff();
            this.infoActor.GetTextProperty().SetFontSize(18);
            this.infoActor.GetTextProperty().Delete();
            this.infoActor.GetProperty().SetColor(0.0, 0.0, 0.0);
            this.infoActor.GetProperty().Delete();
            this.infoActor.SetPosition(10.0, 10.0);
            this.panel.getRenderer().AddActor((vtkProp)this.infoActor);
        }
        this.infoActor.SetInput(text);
    }

    private boolean endingToNozzle(INode nozzleNode, Vector3d o, Vector3d d) {
        Nozzle nozzle = (Nozzle)nozzleNode;
        PipeControlPoint pcp = nozzle.getControlPoint();
        if (pcp != null && (pcp.getNext() != null || pcp.getPrevious() != null)) {
            return false;
        }
        this.currentPosition = pcp.getWorldPosition();
        Point3d previousPipePoint = new Point3d((Tuple3d)this.previousPosition);
        Point3d p = this.detector.getSnappedPoint(o, d, new Vector3d((Tuple3d)previousPipePoint));
        if (p != null && MathTools.distance((Tuple3d)p, (Tuple3d)this.currentPosition) > this.NOZZLE_SNAP_DISTANCE) {
            return false;
        }
        this.updateCurrentPoint();
        this.setInfoText("Connect to nozzle " + String.valueOf(this.currentPosition));
        return true;
    }

    private PipeControlPoint.PositionType endingToStraight(INode straightNode, double[] mu, Vector3d o, Vector3d d) {
        InlineComponent s = (InlineComponent)straightNode;
        Point3d sStart = new Point3d();
        Point3d sEnd = new Point3d();
        s.getEnds((Tuple3d)sStart, (Tuple3d)sEnd);
        Point3d previousPipePoint = new Point3d((Tuple3d)this.previousPosition);
        Point3d currentPipePoint = new Point3d((Tuple3d)this.currentPosition);
        if (this.lock == LockType.NONE) {
            Point3d p = this.detector.getSnappedPoint(o, d, new Vector3d((Tuple3d)previousPipePoint));
            if (p != null) {
                this.currentPosition = new Vector3d((Tuple3d)p);
                PipeControlPoint.PositionType t = this.endingLockToStraight((INode)s, mu, currentPipePoint);
                if (t != null) {
                    return t;
                }
                this.detector.clearConstraintHighlights();
            }
        } else {
            throw new RuntimeException("Lock shouldn't be on");
        }
        Vector3d sDir = new Vector3d((Tuple3d)sEnd);
        sDir.sub((Tuple3d)sStart);
        MathTools.intersectStraightStraight((Tuple3d)sStart, (Vector3d)sDir, (Tuple3d)o, (Vector3d)d, (Tuple3d)this.currentPosition, (Tuple3d)new Point3d(), (double[])mu);
        this.updateCurrentPoint();
        return this.endingToStraight(mu, s, sStart, sEnd, currentPipePoint);
    }

    private PipeControlPoint.PositionType endingToStraight(double[] mu, InlineComponent s, Point3d sStart, Point3d sEnd, Point3d currentPipePoint) {
        Object info = "";
        boolean connectPrev = false;
        boolean connectNext = false;
        boolean branch = false;
        if (mu[0] < 0.1) {
            connectPrev = true;
        } else if (mu[0] > 0.9) {
            connectNext = true;
        }
        if (connectPrev) {
            PipeControlPoint pcp = s.getControlPoint();
            if (pcp.getPrevious() != null) {
                connectPrev = false;
            }
        } else if (connectNext) {
            PipeControlPoint pcp = s.getControlPoint();
            if (pcp.getNext() != null) {
                connectNext = false;
            }
        } else {
            Vector3d dir = s.getControlPoint().getPathLegDirection(PipeControlPoint.Direction.NEXT);
            Vector3d currDir = this.getLast().getControlPoint().getPathLegDirection(PipeControlPoint.Direction.NEXT);
            dir.normalize();
            currDir.normalize();
            double dot = dir.dot(currDir);
            System.out.println(dot + " " + String.valueOf(currDir) + " " + String.valueOf(dir));
            branch = !(dot > BRANCH_DOT_PRODUCT) && !(dot < -BRANCH_DOT_PRODUCT);
        }
        if (connectNext || connectPrev) {
            info = (String)info + "Connect pipes :";
        } else if (branch) {
            info = (String)info + "Create a Branch :";
        }
        this.setInfoText((String)info + String.valueOf(this.currentPosition) + " " + Math.max(0.0, Math.min(mu[0], 1.0)));
        if (connectNext) {
            this.currentPosition.set((Tuple3d)sEnd);
            this.updateCurrentPoint();
            return PipeControlPoint.PositionType.NEXT;
        }
        if (connectPrev) {
            this.currentPosition.set((Tuple3d)sStart);
            this.updateCurrentPoint();
            return PipeControlPoint.PositionType.PREVIOUS;
        }
        if (branch && this.allowBranches) {
            return PipeControlPoint.PositionType.SPLIT;
        }
        this.currentPosition.set((Tuple3d)currentPipePoint);
        this.updateCurrentPoint();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PipeControlPoint endingToComponent(INode componentNode, Vector3d o, Vector3d d) {
        PipelineComponent component = (PipelineComponent)componentNode;
        PipeControlPoint pcp = component.getControlPoint();
        PipeControlPoint connect = null;
        if (component instanceof EndComponent) {
            if (pcp.getNext() != null || pcp.getPrevious() != null) {
                return null;
            }
            connect = pcp;
        } else if (component instanceof TurnComponent) {
            if (pcp.getNext() != null && pcp.getPrevious() != null) return null;
            connect = pcp;
        } else if (component instanceof InlineComponent) {
            if (pcp.getNext() != null && pcp.getPrevious() != null) return null;
            connect = pcp;
        }
        if (connect == null) return null;
        this.currentPosition.set((Tuple3d)connect.getWorldPosition());
        this.updateCurrentPoint();
        this.setInfoText("Connect to " + component.getName());
        return connect;
    }

    private PipeControlPoint.PositionType endingLockToStraight(INode straightNode, double[] mu, Point3d currentPipePoint) {
        InlineComponent s = (InlineComponent)straightNode;
        Point3d sStart = new Point3d();
        Point3d sEnd = new Point3d();
        s.getControlPoint().getInlineControlPointEnds((Tuple3d)sStart, (Tuple3d)sEnd);
        Vector3d sDir = new Vector3d((Tuple3d)sEnd);
        sDir.sub((Tuple3d)sStart);
        Vector3d dir = new Vector3d(this.currentPosition);
        Point3d prev = new Point3d((Tuple3d)this.previousPosition);
        dir.sub((Tuple3d)prev);
        Vector3d branchPoint = new Vector3d();
        Vector3d routePoint = new Vector3d();
        MathTools.intersectStraightStraight((Tuple3d)sStart, (Vector3d)sDir, (Tuple3d)new Vector3d((Tuple3d)prev), (Vector3d)dir, (Tuple3d)branchPoint, (Tuple3d)routePoint, (double[])mu);
        routePoint.sub((Tuple3d)branchPoint);
        if (routePoint.lengthSquared() > this.BRANCH_SNAP_DISTANCE) {
            return null;
        }
        return this.endingToStraight(mu, s, sStart, sEnd, currentPipePoint);
    }

    private boolean endingLockToNozzle(INode nozzleNode) {
        Nozzle nozzle = (Nozzle)nozzleNode;
        Vector3d dir = new Vector3d(this.currentPosition);
        Point3d prev = new Point3d((Tuple3d)this.previousPosition);
        dir.sub((Tuple3d)prev);
        Vector3d nozzleLoc = nozzle.getWorldPosition();
        double[] u = new double[1];
        Vector3d closest = MathTools.closestPointOnStraight((Tuple3d)new Point3d((Tuple3d)nozzleLoc), (Tuple3d)new Point3d(prev), (Vector3d)new Vector3d(dir), (double[])u);
        double dist = MathTools.distanceSquared((Tuple3d)nozzleLoc, (Tuple3d)closest);
        if (dist < this.BRANCH_SNAP_DISTANCE) {
            this.currentPosition.set((Tuple3d)nozzleLoc);
            this.updateCurrentPoint();
            this.setInfoText("Connect to nozzle (l) :" + String.valueOf(this.currentPosition));
            return true;
        }
        return false;
    }

    private PipeControlPoint endingLockToComponent(INode componentNode) {
        return null;
    }

    protected void addTurn() throws Exception {
        InlineComponent previous = (InlineComponent)this.getLast();
        PipeControlPoint previousCP = previous.getControlPoint();
        TurnComponent turn = ComponentUtils.createTurn(this.root);
        PipeControlPoint turnCP = turn.getControlPoint();
        turn.setName(this.pipeRun.getUniqueName("Elbow"));
        this.pipeRun.addChild(turn);
        this.added.add(turn);
        turnCP.setDeletable(false);
        if (!this.reversed) {
            previousCP.setNext(turnCP);
            turnCP.setPrevious(previousCP);
        } else {
            previousCP.setPrevious(turnCP);
            turnCP.setNext(previousCP);
        }
        turnCP.setWorldPosition(this.currentPosition);
        turnCP.setTurnAngle(0.0);
        turnCP.setLength(0.0);
    }

    protected void addStraight() throws Exception {
        TurnComponent turn = (TurnComponent)this.getLast();
        PipeControlPoint turnCP = turn.getControlPoint();
        InlineComponent straight = ComponentUtils.createStraight(this.root);
        PipeControlPoint straightCP = straight.getControlPoint();
        straight.setName(this.pipeRun.getUniqueName("Pipe"));
        this.pipeRun.addChild(straight);
        this.added.add(straight);
        if (!this.reversed) {
            turnCP.setNext(straightCP);
            straightCP.setPrevious(turnCP);
        } else {
            turnCP.setPrevious(straightCP);
            straightCP.setNext(turnCP);
        }
        turnCP.setWorldPosition(this.currentPosition);
        turnCP.setTurnAngle(0.0);
        turnCP.setLength(0.0);
        straightCP.setWorldPosition(this.currentPosition);
        straightCP.setLength(0.0);
    }

    protected void addPoint() throws Exception {
        this.addTurn();
        this.addStraight();
        this.setPreviousPosition(this.currentPosition);
        this.updateCurrentPoint();
    }

    protected void updateCurrentPoint() {
        InlineComponent straight = (InlineComponent)this.added.get(this.added.size() - 1);
        double l = !this.reversed ? straight.getPrevious().getControlPoint().getInlineLength() : straight.getNext().getControlPoint().getInlineLength();
        Vector3d v = new Vector3d();
        v.sub((Tuple3d)this.currentPosition, (Tuple3d)this.previousPosition);
        double length = v.length();
        if (length > MathTools.NEAR_ZERO) {
            v.scale(1.0 / length);
            v.scale(0.5 * (length + l));
            v.add((Tuple3d)this.previousPosition);
            straight.getControlPoint().setWorldPosition(v);
            straight.getControlPoint().setLength(length);
        }
        try {
            straight.getControlPoint().positionUpdate(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PipelineComponent getLast() {
        if (this.added.size() == 0) {
            return this.startComponent;
        }
        return this.added.get(this.added.size() - 1);
    }

    public void removePoint() {
        if (this.added.size() < 3) {
            return;
        }
        InlineComponent straight = (InlineComponent)this.added.remove(this.added.size() - 1);
        TurnComponent turn = (TurnComponent)this.added.remove(this.added.size() - 1);
        straight.getControlPoint().remove();
        turn.getControlPoint().remove();
        if (this.added.size() > 1) {
            this.setPreviousPosition(this.added.get(this.added.size() - 2).getWorldPosition());
        } else {
            this.setPreviousPosition(this.startComponent.getWorldPosition());
            if (this.direction != null) {
                this.setLockType(LockType.CUSTOM, true);
            }
        }
    }

    protected void endPiping() throws Exception {
        this.state = ToolState.NOT_ACTIVE;
        if (this.endTo != null) {
            if (this.endType == PipeControlPoint.PositionType.NEXT || this.endType == PipeControlPoint.PositionType.PREVIOUS && this.endTo instanceof InlineComponent) {
                Vector3d dir = this.endTo.getControlPoint().getPathLegDirection(PipeControlPoint.Direction.NEXT);
                Vector3d currDir = this.getLast().getControlPoint().getPathLegDirection(PipeControlPoint.Direction.NEXT);
                dir.normalize();
                currDir.normalize();
                double dot = dir.dot(currDir);
                System.out.println(dot + " " + String.valueOf(currDir) + " " + String.valueOf(dir));
                if (dot < ALIGN_DOT_PRODUCT && dot > -ALIGN_DOT_PRODUCT) {
                    this.addTurn();
                }
            }
            ComponentUtils.connect(this.getLast(), this.endTo, this.endType, this.currentPosition);
        }
        this.panel.useDefaultAction();
    }

    static enum LockType {
        X,
        Y,
        Z,
        XY,
        XZ,
        YZ,
        NONE,
        CUSTOM;

    }

    protected static enum ToolState {
        NOT_ACTIVE,
        INITIALIZING,
        SELECTING_POSITION,
        SELECTING_SPLIT,
        ROUTING;

    }
}

