/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.internal;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.objmap.backward.IBackwardLinkType;
import org.simantics.objmap.bidirectional.IBidirectionalLinkType;
import org.simantics.objmap.bidirectional.IBidirectionalMapping;
import org.simantics.objmap.bidirectional.IBidirectionalMappingSchema;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardLinkType;
import org.simantics.objmap.internal.BidirectionalLink;

public class BidirectionalMapping<Domain, Range>
implements IBidirectionalMapping<Domain, Range> {
    IBidirectionalMappingSchema<Domain, Range> schema;
    THashMap<Domain, BidirectionalLink<Domain, Range>> forwardMap = new THashMap();
    THashMap<Range, BidirectionalLink<Domain, Range>> backwardMap = new THashMap();
    ArrayList<BidirectionalLink<Domain, Range>> modifiedDomain = new ArrayList();
    ArrayList<BidirectionalLink<Domain, Range>> modifiedRange = new ArrayList();

    private void markDomainModified(BidirectionalLink<Domain, Range> link) {
        if (!link.domainModified) {
            link.domainModified = true;
            this.modifiedDomain.add(link);
        }
    }

    private void markRangeModified(BidirectionalLink<Domain, Range> link) {
        if (!link.rangeModified) {
            link.rangeModified = true;
            this.modifiedRange.add(link);
        }
    }

    public BidirectionalMapping(IBidirectionalMappingSchema<Domain, Range> schema) {
        this.schema = schema;
    }

    private BidirectionalLink<Domain, Range> addLink(IBidirectionalLinkType<Domain, Range> linkType, Domain domainElement, Range rangeElement) {
        BidirectionalLink<Domain, Range> link = new BidirectionalLink<Domain, Range>(linkType, domainElement, rangeElement);
        this.forwardMap.put(domainElement, link);
        this.backwardMap.put(rangeElement, link);
        return link;
    }

    @Override
    public Set<Domain> getDomain() {
        return Collections.unmodifiableSet(this.forwardMap.keySet());
    }

    @Override
    public Range get(Domain domainElement) {
        BidirectionalLink link = (BidirectionalLink)this.forwardMap.get(domainElement);
        if (link == null) {
            return null;
        }
        return link.rangeElement;
    }

    @Override
    public Range map(ReadGraph graph, Domain domainElement) throws MappingException {
        Range result = this.get(domainElement);
        if (result == null) {
            IForwardLinkType linkType = this.schema.linkTypeOfDomainElement(graph, (Object)domainElement);
            Object rangeElement = linkType.createRangeElement(graph, domainElement);
            this.addLink((IBidirectionalLinkType<Domain, Range>)linkType, domainElement, rangeElement);
            linkType.createRange(graph, this, domainElement, rangeElement);
        }
        return result;
    }

    public Collection<Range> updateRange(ReadGraph graph) throws MappingException {
        ArrayList updated = new ArrayList(Math.max(10, this.modifiedDomain.size()));
        for (BidirectionalLink<Domain, Range> link : this.modifiedDomain) {
            link.domainModified = false;
            if (!link.linkType.updateRange(graph, this, link.domainElement, link.rangeElement)) continue;
            updated.add(link.rangeElement);
        }
        this.modifiedDomain.clear();
        return updated;
    }

    @Override
    public Set<Range> getRange() {
        return Collections.unmodifiableSet(this.backwardMap.keySet());
    }

    @Override
    public Domain inverseGet(Range rangeElement) {
        BidirectionalLink link = (BidirectionalLink)this.backwardMap.get(rangeElement);
        if (link == null) {
            return null;
        }
        return link.domainElement;
    }

    @Override
    public Domain inverseMap(WriteGraph graph, Range rangeElement) throws MappingException {
        Domain result = this.inverseGet(rangeElement);
        if (result == null) {
            IBackwardLinkType linkType = this.schema.linkTypeOfRangeElement((ReadGraph)graph, (Object)rangeElement);
            Object domainElement = linkType.createDomainElement(graph, rangeElement);
            this.addLink((IBidirectionalLinkType<Domain, Range>)linkType, domainElement, rangeElement);
            linkType.createDomain(graph, this, domainElement, rangeElement);
        }
        return result;
    }

    public Collection<Domain> updateDomain(WriteGraph graph) throws MappingException {
        ArrayList updated = new ArrayList(Math.max(10, this.modifiedRange.size()));
        for (BidirectionalLink<Domain, Range> link : this.modifiedRange) {
            link.rangeModified = false;
            if (!link.linkType.updateDomain(graph, this, link.domainElement, link.rangeElement)) continue;
            updated.add(link.domainElement);
        }
        this.modifiedDomain.clear();
        return updated;
    }
}

