/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbench;
import org.simantics.Simantics;
import org.simantics.db.management.ISessionContext;
import org.simantics.g3d.wizard.IExportModel;
import org.simantics.g3d.wizard.ModelExportWizardPage;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.workbench.StringMemento;

public abstract class ModelExportWizard<T extends IExportModel>
extends Wizard
implements IExportWizard {
    private static final int MAX_RECENT_EXPORT_PATHS = 10;
    Deque<String> recentExportPaths;
    boolean overwrite;
    T exportModel;
    private static final String TAG_PATH = "path";
    private static final String ATTR_NAME = "name";

    protected abstract T createExportModel(Deque<String> var1);

    protected abstract ModelExportWizardPage<T> createExportPage(T var1);

    protected abstract IPersistentPreferenceStore getPreferenceStore();

    protected abstract IRunnableWithProgress createExportRunnable(T var1);

    protected abstract String getExportLocationId();

    protected abstract String getExportOverwriteId();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.readPreferences();
        ISessionContext ctx = Simantics.getSessionContext();
        if (ctx == null) {
            return;
        }
        IProject project = (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
        if (project == null) {
            return;
        }
        this.exportModel = this.createExportModel(this.recentExportPaths);
        ((IExportModel)this.exportModel).setSelection(selection.getFirstElement());
        ((IExportModel)this.exportModel).setOverwrite(this.overwrite);
    }

    public void addPages() {
        super.addPages();
        if (this.exportModel != null) {
            this.addPage((IWizardPage)this.createExportPage(this.exportModel));
        }
    }

    public boolean performFinish() {
        try {
            this.recentExportPaths.addFirst(((IExportModel)this.exportModel).getExportLocation().getAbsolutePath());
            ModelExportWizard.removeDuplicates(this.recentExportPaths);
            if (this.recentExportPaths.size() > 10) {
                this.recentExportPaths.pollLast();
            }
            this.writePreferences();
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((String)"Failed to write preferences", (Throwable)e);
        }
        if (((IExportModel)this.exportModel).usesFile()) {
            File outputFile = ((IExportModel)this.exportModel).getExportLocation();
            if (outputFile.exists()) {
                if (!outputFile.isFile()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"File Problem", (String)("Output target is not a file " + outputFile.getAbsolutePath()));
                    return false;
                }
                if (!((IExportModel)this.exportModel).isOverwrite()) {
                    boolean ok = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Overwrite", (String)("A file by the name " + outputFile.getAbsolutePath() + " contains files.\n\nDo you want to overwrite the files?"));
                    if (!ok) {
                        return false;
                    }
                    if (!outputFile.delete()) {
                        MessageDialog.openError((Shell)this.getShell(), (String)"Delete Problem", (String)("Could not overwrite previously existing file " + outputFile.getAbsolutePath()));
                        return false;
                    }
                }
            }
        } else {
            File outputFolder = ((IExportModel)this.exportModel).getExportLocation();
            if (outputFolder.exists()) {
                boolean ok;
                if (!outputFolder.isDirectory()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Folder Problem", (String)("Output target is not a folder " + outputFolder.getAbsolutePath()));
                    return false;
                }
                String[] files = outputFolder.list();
                if (files.length > 0 && !((IExportModel)this.exportModel).isOverwrite() && !(ok = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Overwrite", (String)("A folder by the name " + outputFolder.getAbsolutePath() + " contains files.\n\nDo you want to overwrite the files?")))) {
                    return false;
                }
            } else if (!outputFolder.mkdir()) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Folder Problem", (String)("Could not create new folder " + String.valueOf(outputFolder)));
                return false;
            }
        }
        try {
            this.getContainer().run(true, true, this.createExportRunnable(this.exportModel));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            if (t instanceof IOException) {
                ErrorLogger.defaultLogError((String)"An I/O problem occurred while exporting the model. See exception for details.", (Throwable)t);
                cp.setErrorMessage("An I/O problem occurred while exporting the model.\n\nMessage: " + e.getMessage());
            } else {
                ErrorLogger.defaultLogError((String)"Unexpected exception while exporting the model. See exception for details.", (Throwable)t);
                cp.setErrorMessage("Unexpected exception while exporting the model. See error log for details.\n\nMessage: " + e.getMessage());
            }
            return false;
        }
        catch (InterruptedException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
            return false;
        }
        return true;
    }

    private boolean readPreferences() {
        IPersistentPreferenceStore store = this.getPreferenceStore();
        String recentPathsPref = store.getString(this.getExportLocationId());
        this.recentExportPaths = ModelExportWizard.decodePaths(recentPathsPref);
        this.overwrite = store.getBoolean(this.getExportOverwriteId());
        return true;
    }

    private void writePreferences() throws IOException {
        IPersistentPreferenceStore store = this.getPreferenceStore();
        store.putValue(this.getExportLocationId(), ModelExportWizard.encodePaths(this.recentExportPaths));
        store.setValue(this.getExportOverwriteId(), ((IExportModel)this.exportModel).isOverwrite());
        if (store.needsSaving()) {
            store.save();
        }
    }

    public static Deque<String> decodePaths(String recentPathsPref) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            StringMemento sm = new StringMemento(recentPathsPref);
            IMemento[] iMementoArray = sm.getChildren(TAG_PATH);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento m = iMementoArray[n2];
                String name = m.getString(ATTR_NAME);
                if (name != null && !name.isEmpty()) {
                    result.add(name);
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    public static String encodePaths(Deque<String> recentPaths) {
        StringMemento sm = new StringMemento();
        for (String path : recentPaths) {
            IMemento m = sm.createChild(TAG_PATH);
            m.putString(ATTR_NAME, path);
        }
        return sm.toString();
    }

    public static <T> void removeDuplicates(Iterable<String> iter) {
        TreeSet<String> dups = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Iterator<String> it = iter.iterator();
        while (it.hasNext()) {
            String path = it.next();
            if (dups.add(path)) continue;
            it.remove();
        }
    }
}

