/*
 * Decompiled with CFR 0.152.
 */
package org.jcae.opencascade;

import java.io.PrintStream;
import java.util.Arrays;
import org.jcae.opencascade.jni.BRepTools;
import org.jcae.opencascade.jni.BRep_Builder;
import org.jcae.opencascade.jni.BRep_Tool;
import org.jcae.opencascade.jni.IGESControl_Reader;
import org.jcae.opencascade.jni.STEPControl_Reader;
import org.jcae.opencascade.jni.TopAbs_ShapeEnum;
import org.jcae.opencascade.jni.TopExp_Explorer;
import org.jcae.opencascade.jni.TopoDS_Edge;
import org.jcae.opencascade.jni.TopoDS_Face;
import org.jcae.opencascade.jni.TopoDS_Iterator;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.jcae.opencascade.jni.TopoDS_Vertex;

public class Utilities {
    private static final int TAB = 2;

    public static void dumpTopology(TopoDS_Shape shape) {
        Utilities.dumpTopology(shape, System.out);
    }

    public static void dumpTopology(TopoDS_Shape shape, PrintStream out) {
        Utilities.dumpTopology(shape, out, 0);
    }

    private static void dumpTopology(TopoDS_Shape shape, PrintStream out, int level) {
        TopoDS_Iterator it = new TopoDS_Iterator(shape);
        char[] dots = new char[level * 2];
        Arrays.fill(dots, '-');
        String dotss = new String(dots);
        String label = shape.toString().substring("org.jcae.opencascade.jni.TopoDS_".length());
        System.out.print("+" + dotss + label);
        switch (shape.shapeType()) {
            case FACE: {
                out.print(" " + BRep_Tool.tolerance((TopoDS_Face)shape));
                break;
            }
            case EDGE: {
                out.print(" " + BRep_Tool.tolerance((TopoDS_Edge)shape));
                break;
            }
            case VERTEX: {
                out.print(" " + BRep_Tool.tolerance((TopoDS_Vertex)shape));
            }
        }
        out.print(" " + String.valueOf((Object)shape.orientation()));
        out.println();
        while (it.more()) {
            Utilities.dumpTopology(it.value(), out, level + 1);
            it.next();
        }
    }

    public static int numberOfShape(TopoDS_Shape shape, TopAbs_ShapeEnum type) {
        int n = 0;
        TopExp_Explorer exp = new TopExp_Explorer(shape, type);
        while (exp.more()) {
            ++n;
            exp.next();
        }
        return n;
    }

    public static boolean isShapeInShape(TopoDS_Shape parent, TopoDS_Shape child) {
        TopExp_Explorer exp = new TopExp_Explorer(parent, child.shapeType());
        while (exp.more()) {
            if (exp.current().equals(child)) {
                return true;
            }
            exp.next();
        }
        return false;
    }

    public static TopoDS_Shape readFile(String fileName) {
        if (fileName.endsWith(".stp") || fileName.endsWith(".STP") || fileName.endsWith(".step") || fileName.endsWith(".STEP")) {
            STEPControl_Reader aReader = new STEPControl_Reader();
            aReader.readFile(fileName.getBytes());
            aReader.nbRootsForTransfer();
            aReader.transferRoots();
            return aReader.oneShape();
        }
        if (fileName.endsWith(".igs") || fileName.endsWith(".IGS") || fileName.endsWith(".iges") || fileName.endsWith(".IGES")) {
            IGESControl_Reader aReader = new IGESControl_Reader();
            aReader.readFile(fileName.getBytes());
            aReader.nbRootsForTransfer();
            aReader.transferRoots();
            return aReader.oneShape();
        }
        return BRepTools.read(fileName, new BRep_Builder());
    }

    public static TopoDS_Face getFace(TopoDS_Shape shape, int id) {
        TopExp_Explorer exp = new TopExp_Explorer(shape, TopAbs_ShapeEnum.FACE);
        int i = 0;
        while (exp.more()) {
            if (id == i) {
                return (TopoDS_Face)exp.current();
            }
            exp.next();
            ++i;
        }
        throw new IndexOutOfBoundsException("Face " + id + " not found");
    }

    public static TopoDS_Vertex getVertex(TopoDS_Shape shape, int id) {
        TopExp_Explorer exp = new TopExp_Explorer(shape, TopAbs_ShapeEnum.VERTEX);
        int i = 0;
        while (exp.more()) {
            if (id == i) {
                return (TopoDS_Vertex)exp.current();
            }
            exp.next();
            ++i;
        }
        throw new IndexOutOfBoundsException("Vertex " + id + " not found");
    }

    public static double tolerance(TopoDS_Shape shape) {
        double toReturn = 0.0;
        if (shape instanceof TopoDS_Face) {
            toReturn = BRep_Tool.tolerance((TopoDS_Face)shape);
        } else if (shape instanceof TopoDS_Edge) {
            toReturn = BRep_Tool.tolerance((TopoDS_Edge)shape);
        } else if (shape instanceof TopoDS_Vertex) {
            return BRep_Tool.tolerance((TopoDS_Vertex)shape);
        }
        TopoDS_Iterator it = new TopoDS_Iterator(shape);
        while (it.more()) {
            TopoDS_Shape s = it.value();
            double t = Utilities.tolerance(s);
            if (t > toReturn) {
                toReturn = t;
            }
            it.next();
        }
        return toReturn;
    }
}

