/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.ArrayListBinding;
import org.simantics.databoard.binding.util.IsReferableQuery;
import org.simantics.databoard.binding.util.Result;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.impl.DefaultValueIterator;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.util.Range;

public class ArraySerializer
extends Serializer.CompositeSerializer {
    Range length;
    Integer fixedLength;
    Integer fixedSize;
    Integer fixedSizeOfComponent;
    public Serializer componentSerializer;
    boolean componentImmutable;
    ArrayBinding binding;
    DefaultValueIterator componentValueItr;

    public ArraySerializer(ArrayBinding binding, Serializer componentSerializer) {
        super(IsReferableQuery.isReferable(binding.type()) != Result.No);
        ArrayType arrayType = binding.type();
        this.componentSerializer = componentSerializer;
        this.binding = binding;
        this.length = arrayType.getLength();
        this.componentImmutable = binding.getComponentBinding().isImmutable();
        this.componentValueItr = new DefaultValueIterator();
        this.componentValueItr.binding = binding.componentBinding;
    }

    @Override
    public void finalizeConstruction() {
        this.fixedSizeOfComponent = this.componentSerializer.getConstantSize();
        if (this.fixedSizeOfComponent != null && this.length != null && this.length.getLower().equals(this.length.getUpper()) && this.length.getLower().getValue() != null) {
            this.fixedLength = this.length.getLower().getValue().intValue();
            this.fixedSize = this.fixedLength * this.fixedSizeOfComponent;
        }
    }

    @Override
    public Object deserialize(DataInput in, List<Object> identities) throws IOException {
        try {
            int length;
            int n = length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
            if (length < 0) {
                throw new SerializationException("Cannot use negative array length");
            }
            this.assertRemainingBytes(in, (long)length * (long)this.componentSerializer.getMinSize());
            ArrayList<Object> temp = new ArrayList<Object>(length);
            int i = 0;
            while (i < length) {
                temp.add(this.componentSerializer.deserialize(in, identities));
                ++i;
            }
            return this.binding instanceof ArrayListBinding ? temp : this.binding.create(temp);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object deserializeToTry(DataInput in, List<Object> identities, Object obj) throws IOException {
        try {
            int length;
            int n = length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
            if (length < 0) {
                throw new SerializationException("Cannot use negative array length");
            }
            this.assertRemainingBytes(in, (long)length * (long)this.componentSerializer.getMinSize());
            int oldLen = this.binding.size(obj);
            if (oldLen != length) {
                if (this.binding.isResizable()) {
                    this.binding.setSize(obj, length);
                } else {
                    obj = this.binding.create(length, this.componentValueItr);
                    oldLen = length;
                }
            }
            if (this.componentImmutable) {
                int i = 0;
                while (i < length) {
                    Object component = this.componentSerializer.deserialize(in, identities);
                    this.binding.set(obj, i, component);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < length) {
                    Object component = this.binding.get(obj, i);
                    component = this.componentSerializer.deserializeToTry(in, identities, component);
                    this.binding.set(obj, i, component);
                    ++i;
                }
                if (oldLen > length) {
                    this.binding.setSize(obj, length);
                }
            }
            return obj;
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deserializeTo(DataInput in, List<Object> identities, Object obj) throws IOException {
        try {
            int length;
            int n = length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
            if (length < 0) {
                throw new SerializationException("Cannot use negative array length");
            }
            this.assertRemainingBytes(in, (long)length * (long)this.componentSerializer.getMinSize());
            int oldLen = this.binding.size(obj);
            if (oldLen != length) {
                if (this.binding.isResizable()) {
                    this.binding.setSize(obj, length);
                } else {
                    throw new IOException("Cannot resize array");
                }
            }
            if (this.componentImmutable) {
                int i = 0;
                while (i < length) {
                    Object component = this.componentSerializer.deserialize(in, identities);
                    this.binding.set(obj, i, component);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < length) {
                    Object component = this.binding.get(obj, i);
                    component = this.componentSerializer.deserializeToTry(in, identities, component);
                    this.binding.set(obj, i, component);
                    ++i;
                }
                if (oldLen > length) {
                    this.binding.setSize(obj, length);
                }
            }
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void skip(DataInput in, List<Object> identities) throws IOException {
        int length;
        if (this.fixedSize != null) {
            in.skipBytes(this.fixedSize);
            return;
        }
        int n = length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
        if (this.fixedSizeOfComponent != null) {
            in.skipBytes(length * this.fixedSizeOfComponent);
        } else {
            int i = 0;
            while (i < length) {
                this.componentSerializer.skip(in, identities);
                ++i;
            }
        }
    }

    @Override
    public void serialize(DataOutput out, TObjectIntHashMap<Object> identities, Object obj) throws IOException {
        try {
            int length = this.binding.size(obj);
            if (this.fixedLength == null) {
                out.writeInt(length);
            } else if (length != this.fixedLength) {
                throw new SerializationException("Unexpected array length " + length + ", size is restricted to " + String.valueOf(this.fixedLength));
            }
            int i = 0;
            while (i < length) {
                this.componentSerializer.serialize(out, identities, this.binding.get(obj, i));
                ++i;
            }
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Integer getConstantSize() {
        return this.fixedSize;
    }

    @Override
    public int getSize(Object obj, TObjectIntHashMap<Object> identities) throws IOException {
        try {
            if (this.fixedSize != null) {
                return this.fixedSize;
            }
            int length = this.binding.size(obj);
            if (this.fixedSizeOfComponent != null) {
                return 4 + this.fixedSizeOfComponent * length;
            }
            int result = 4;
            int i = 0;
            while (i < length) {
                result += this.componentSerializer.getSize(this.binding.get(obj, i), identities);
                ++i;
            }
            return result;
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int getMinSize() {
        return this.fixedSize != null ? this.fixedSize : 4;
    }
}

