/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.forms;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.forms.DataboardForm;

public class DataboardDialog
extends Dialog {
    RecordBinding formBinding;
    Object initialValues;
    String title;
    Object result;
    DataboardForm form;
    Composite composite;

    public DataboardDialog(Shell parentShell, String title, RecordBinding formBinding, Object initialValues) {
        super(parentShell);
        this.formBinding = formBinding;
        this.initialValues = initialValues;
        this.title = title;
        this.setBlockOnOpen(true);
        this.setShellStyle(2160);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        ScrolledComposite scroll = new ScrolledComposite(parent, 512);
        this.composite = new Composite((Composite)scroll, 0);
        scroll.setContent((Control)this.composite);
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(false);
        this.form = new DataboardForm();
        this.form.setFirstColumnWidth(0);
        this.form.addFields(this.composite, this.formBinding.type());
        this.composite.setLayout((Layout)new GridLayout(3, false));
        this.composite.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        if (this.initialValues != null) {
            try {
                this.form.writeFields(this.composite, this.formBinding, this.initialValues);
            }
            catch (AccessorException e) {
                e.printStackTrace();
            }
            catch (BindingException e) {
                e.printStackTrace();
            }
            catch (AccessorConstructionException e) {
                e.printStackTrace();
            }
        }
        this.composite.pack();
        return scroll;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected void okPressed() {
        try {
            this.result = this.formBinding.createDefault();
            this.form.readFields(this.composite, this.formBinding, this.result);
        }
        catch (BindingException e) {
            e.printStackTrace();
            this.result = null;
        }
        catch (AccessorConstructionException e) {
            e.printStackTrace();
            this.result = null;
        }
        catch (AccessorException e) {
            e.printStackTrace();
            this.result = null;
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.result = null;
        super.cancelPressed();
    }

    public Object getResult() {
        return this.result;
    }
}

