/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.factory;

import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.databoard.binding.factory.BindingScheme;
import org.simantics.databoard.type.Datatype;

public abstract class TypeBindingFactory
implements BindingScheme {
    protected Map<Datatype, BindingConstructionException> failures = new HashMap<Datatype, BindingConstructionException>();
    protected Map<Datatype, Binding> inprogress = new HashMap<Datatype, Binding>();
    protected Map<Datatype, Binding> repository;

    public TypeBindingFactory() {
        this.repository = new HashMap<Datatype, Binding>();
    }

    public TypeBindingFactory(Map<Datatype, Binding> repository) {
        this.repository = repository;
    }

    public Map<Datatype, Binding> getRepository() {
        return this.repository;
    }

    protected abstract Binding doConstruct(Datatype var1) throws BindingConstructionException;

    public Binding construct(Datatype request) throws BindingConstructionException {
        if (this.failures.containsKey(request)) {
            throw this.failures.get(request);
        }
        if (this.inprogress.containsKey(request)) {
            return this.inprogress.get(request);
        }
        if (this.repository.containsKey(request)) {
            return this.repository.get(request);
        }
        try {
            Binding binding = this.doConstruct(request);
            this.repository.put(request, binding);
            return binding;
        }
        catch (BindingConstructionException e) {
            this.inprogress.remove(request);
            this.failures.put(request, e);
            throw e;
        }
    }

    @Override
    public Binding getBinding(Datatype type) throws BindingConstructionException {
        return this.construct(type);
    }

    @Override
    public Binding getBindingUnchecked(Datatype type) throws RuntimeBindingConstructionException {
        try {
            return this.construct(type);
        }
        catch (BindingConstructionException e) {
            throw new RuntimeBindingConstructionException(e);
        }
    }
}

