/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.factory;

import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.factory.RecordObjectArrayBinding;
import org.simantics.databoard.binding.factory.TypeBindingFactory;
import org.simantics.databoard.binding.impl.ArrayListBinding;
import org.simantics.databoard.binding.impl.TreeMapBinding;
import org.simantics.databoard.binding.mutable.ContainerOptionalBinding;
import org.simantics.databoard.binding.mutable.MutableBooleanBinding;
import org.simantics.databoard.binding.mutable.MutableByteBinding;
import org.simantics.databoard.binding.mutable.MutableDoubleBinding;
import org.simantics.databoard.binding.mutable.MutableFloatBinding;
import org.simantics.databoard.binding.mutable.MutableIntegerBinding;
import org.simantics.databoard.binding.mutable.MutableLongBinding;
import org.simantics.databoard.binding.mutable.MutableStringBinding;
import org.simantics.databoard.binding.mutable.UnionTaggedObjectBinding;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;

public class MutableBindingFactory
extends TypeBindingFactory {
    public MutableBindingFactory() {
    }

    public MutableBindingFactory(Map<Datatype, Binding> repository) {
        super(repository);
    }

    @Override
    protected Binding doConstruct(Datatype type) throws BindingConstructionException {
        if (type.equals(Bindings.BOOLEAN.type())) {
            return Bindings.MUTABLE_BOOLEAN;
        }
        if (type.equals(Bindings.BYTE.type())) {
            return Bindings.MUTABLE_BYTE;
        }
        if (type.equals(Bindings.INTEGER.type())) {
            return Bindings.MUTABLE_INTEGER;
        }
        if (type.equals(Bindings.LONG.type())) {
            return Bindings.MUTABLE_LONG;
        }
        if (type.equals(Bindings.FLOAT.type())) {
            return Bindings.MUTABLE_FLOAT;
        }
        if (type.equals(Bindings.DOUBLE.type())) {
            return Bindings.MUTABLE_DOUBLE;
        }
        if (type.equals(Bindings.STRING.type())) {
            return Bindings.MUTABLE_STRING;
        }
        if (type.equals(Bindings.VARIANT.type())) {
            return Bindings.MUTABLE_VARIANT;
        }
        if (type instanceof BooleanType) {
            return new MutableBooleanBinding((BooleanType)type);
        }
        if (type instanceof DoubleType) {
            return new MutableDoubleBinding((DoubleType)type);
        }
        if (type instanceof FloatType) {
            return new MutableFloatBinding((FloatType)type);
        }
        if (type instanceof ByteType) {
            return new MutableByteBinding((ByteType)type);
        }
        if (type instanceof IntegerType) {
            return new MutableIntegerBinding((IntegerType)type);
        }
        if (type instanceof LongType) {
            return new MutableLongBinding((LongType)type);
        }
        if (type instanceof StringType) {
            return new MutableStringBinding((StringType)type);
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Datatype componentType = arrayType.componentType();
            ArrayListBinding binding = new ArrayListBinding(arrayType, null);
            this.inprogress.put(type, binding);
            binding.componentBinding = this.construct(componentType);
            this.inprogress.remove(type);
            return binding;
        }
        if (type instanceof OptionalType) {
            OptionalType optionalType = (OptionalType)type;
            Datatype componentType = optionalType.componentType;
            ContainerOptionalBinding binding = new ContainerOptionalBinding(optionalType, null);
            this.inprogress.put(type, binding);
            binding.componentBinding = this.construct(componentType);
            this.inprogress.remove(type);
            return binding;
        }
        if (type instanceof RecordType) {
            RecordType recordType = (RecordType)type;
            Binding[] componentBindings = new Binding[recordType.getComponentCount()];
            RecordObjectArrayBinding binding = new RecordObjectArrayBinding(recordType, componentBindings);
            this.inprogress.put(type, binding);
            int i = 0;
            while (i < componentBindings.length) {
                componentBindings[i] = this.construct(recordType.getComponentType(i));
                ++i;
            }
            this.inprogress.remove(type);
            return binding;
        }
        if (type instanceof UnionType) {
            UnionType unionType = (UnionType)type;
            Binding[] componentBindings = new Binding[unionType.components.length];
            UnionTaggedObjectBinding binding = new UnionTaggedObjectBinding(unionType, componentBindings);
            this.inprogress.put(type, binding);
            int i = 0;
            while (i < componentBindings.length) {
                componentBindings[i] = this.construct(unionType.getComponent((int)i).type);
                ++i;
            }
            this.inprogress.remove(type);
            return binding;
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            TreeMapBinding binding = new TreeMapBinding(mapType, null, null);
            this.inprogress.put(type, binding);
            binding.setKeyBinding(this.construct(mapType.keyType));
            binding.setValueBinding(this.construct(mapType.valueType));
            this.inprogress.remove(type);
            return binding;
        }
        throw new BindingConstructionException("Unexpected, I don't know how to create binding for " + String.valueOf(type));
    }

    @Override
    public boolean supportsType(Datatype type) {
        return !this.failures.containsKey(type);
    }
}

