/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.binary;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.CloseableAccessor;
import org.simantics.databoard.accessor.ParametrisedAccessor;
import org.simantics.databoard.accessor.binary.BinaryArray;
import org.simantics.databoard.accessor.binary.BinaryBoolean;
import org.simantics.databoard.accessor.binary.BinaryByte;
import org.simantics.databoard.accessor.binary.BinaryDouble;
import org.simantics.databoard.accessor.binary.BinaryFloat;
import org.simantics.databoard.accessor.binary.BinaryInteger;
import org.simantics.databoard.accessor.binary.BinaryLong;
import org.simantics.databoard.accessor.binary.BinaryMap;
import org.simantics.databoard.accessor.binary.BinaryOptional;
import org.simantics.databoard.accessor.binary.BinaryRecord;
import org.simantics.databoard.accessor.binary.BinaryString;
import org.simantics.databoard.accessor.binary.BinaryUnion;
import org.simantics.databoard.accessor.binary.BinaryVariant;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.InvalidatedEvent;
import org.simantics.databoard.accessor.file.FileAccessor;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;
import org.simantics.databoard.util.binary.BinaryFile;
import org.simantics.databoard.util.binary.Blob;
import org.simantics.databoard.util.binary.RandomAccessBinary;

public abstract class BinaryObject
implements Accessor,
FileAccessor,
CloseableAccessor,
ParametrisedAccessor {
    protected Accessor parent;
    protected ListenerEntry listeners = null;
    protected Blob b;
    protected Datatype type;
    protected File file;
    protected AccessorParams params;

    BinaryObject(Accessor parent, Blob blob, Datatype type, AccessorParams params) {
        this.parent = parent;
        this.b = blob;
        this.type = type;
        this.params = params;
        if (parent != null && parent instanceof BinaryObject) {
            this.file = ((BinaryObject)parent).file();
        } else {
            RandomAccessBinary sourceBinary = this.b.getSource();
            if (sourceBinary instanceof BinaryFile) {
                BinaryFile bf = (BinaryFile)sourceBinary;
                this.file = bf.file();
            }
        }
    }

    @Override
    public Datatype type() {
        return this.type;
    }

    @Override
    public void flush() throws AccessorException {
        try {
            this.b.flush();
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void reset() throws AccessorException {
        try {
            this.b.reset();
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
    }

    public RandomAccessBinary getSource() {
        RandomAccessBinary result = this.b;
        while (result instanceof Blob) {
            result = result.getParent();
        }
        return result;
    }

    @Override
    public void close() throws AccessorException {
        this.writeLock();
        try {
            if (this.parent != null) {
                ((FileAccessor)this.parent).close();
                return;
            }
            if (this.b == null) {
                return;
            }
            try {
                RandomAccessBinary rab = this.getSource();
                rab.flush();
                rab.close();
                this.b = null;
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public boolean isOpen() {
        return this.b.isOpen();
    }

    @Override
    public File file() {
        return this.file;
    }

    public RandomAccessBinary getBinary() {
        return this.b;
    }

    @Override
    public AccessorParams getParams() {
        return this.params;
    }

    @Override
    public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) throws AccessorException {
        this.listeners = ListenerEntry.link(this.listeners, listener, interestSet, path, executor);
    }

    protected ListenerEntry detachListener(Accessor.Listener listener) throws AccessorException {
        ListenerEntry e = this.listeners;
        ListenerEntry p = null;
        while (e != null) {
            if (e.listener == listener) {
                if (p == null) {
                    this.listeners = e.next;
                    return e;
                }
                p.next = e.next;
                return e;
            }
            p = e;
            e = e.next;
        }
        return null;
    }

    @Override
    public void removeListener(Accessor.Listener listener) throws AccessorException {
        this.detachListener(listener);
    }

    @Override
    public void setValue(Binding binding, Object newValue) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.setValueNoflush(binding, newValue);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public abstract void setValueNoflush(Binding var1, Object var2) throws AccessorException;

    @Override
    public boolean setValue(ChildReference path, Binding binding, Object obj) throws AccessorException {
        try {
            Object a = this.getComponent(path);
            a.setValue(binding, obj);
            return true;
        }
        catch (ReferenceException referenceException) {
            return false;
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public Object getValue(Binding binding) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            Serializer s = this.params.serializerScheme.getSerializer(binding);
            this.b.position(0L);
            Object object = s.deserialize(this.b, null);
            return object;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        catch (SerializerConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void getValue(Binding binding, Object obj) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            try {
                Serializer s = this.params.serializerScheme.getSerializer(binding);
                this.b.position(0L);
                s.deserializeTo(this.b, null, obj);
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (SerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public boolean getValue(ChildReference path, Binding binding, Object obj) throws AccessorException {
        try {
            Object a = this.getComponent(path);
            a.getValue(binding, obj);
            return true;
        }
        catch (ReferenceException referenceException) {
            return false;
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public Object getValue(ChildReference path, Binding binding) throws AccessorException {
        try {
            Object a = this.getComponent(path);
            return a.getValue(binding);
        }
        catch (ReferenceException referenceException) {
            return null;
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    Object adapt(Object value, Binding domain, Binding range) throws AdaptException, AdapterConstructionException {
        return this.params.adapterScheme.getAdapter(domain, range, true, false).adapt(value);
    }

    void invalidatedNotification() {
        ListenerEntry le = this.listeners;
        while (le != null) {
            Object is = le.getInterestSet();
            if (((InterestSet)is).inNotifications()) {
                InvalidatedEvent e = new InvalidatedEvent();
                this.emitEvent(le, e);
            }
            le = le.next;
        }
    }

    abstract Event applyLocal(Event var1, boolean var2) throws AccessorException;

    @Override
    public void apply(List<Event> cs, LinkedList<Event> rollback) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                boolean makeRollback = rollback != null;
                for (Event e : cs) {
                    BinaryObject a = e.reference == null ? this : (BinaryObject)this.getComponent(e.reference);
                    Event rbe = a.applyLocal(e, makeRollback);
                    if (!makeRollback) continue;
                    rbe.reference = e.reference;
                    rollback.addFirst(rbe);
                }
                try {
                    this.b.flush();
                }
                catch (IOException e1) {
                    throw new AccessorException(e1);
                }
            }
            catch (AccessorConstructionException ae) {
                try {
                    this.b.flush();
                }
                catch (IOException iOException) {}
                throw new AccessorException(ae);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public String toString() {
        Datatype type = this.type();
        return String.valueOf(this.getClass()) + "(" + String.valueOf(type) + ")";
    }

    public static BinaryObject createAccessor(RandomAccessBinary binary, Datatype type, AccessorParams params) throws AccessorConstructionException {
        try {
            Blob blob;
            Blob blob2 = blob = binary instanceof Blob ? (Blob)binary : new Blob(binary);
            if (type instanceof BooleanType) {
                return new BinaryBoolean(null, blob, (BooleanType)type, params);
            }
            if (type instanceof ByteType) {
                return new BinaryByte(null, blob, (ByteType)type, params);
            }
            if (type instanceof IntegerType) {
                return new BinaryInteger(null, blob, (IntegerType)type, params);
            }
            if (type instanceof LongType) {
                return new BinaryLong(null, blob, (LongType)type, params);
            }
            if (type instanceof FloatType) {
                return new BinaryFloat(null, blob, (FloatType)type, params);
            }
            if (type instanceof DoubleType) {
                return new BinaryDouble(null, blob, (DoubleType)type, params);
            }
            if (type instanceof StringType) {
                return new BinaryString(null, blob, (StringType)type, params);
            }
            if (type instanceof OptionalType) {
                return new BinaryOptional(null, blob, (OptionalType)type, params);
            }
            if (type instanceof UnionType) {
                return new BinaryUnion(null, blob, (Datatype)((UnionType)type), params);
            }
            if (type instanceof RecordType) {
                return new BinaryRecord(null, blob, (RecordType)type, params);
            }
            if (type instanceof VariantType) {
                return new BinaryVariant(null, blob, (Datatype)((VariantType)type), params);
            }
            if (type instanceof MapType) {
                return new BinaryMap(null, blob, (Datatype)((MapType)type), params);
            }
            if (type instanceof ArrayType) {
                return new BinaryArray(null, blob, (Datatype)((ArrayType)type), params);
            }
            throw new AccessorConstructionException("Can not create accessor to " + String.valueOf(type));
        }
        catch (IOException e) {
            throw new AccessorConstructionException(e);
        }
    }

    BinaryObject createSubAccessor(Datatype type, long position, long length, AccessorParams params) throws AccessorConstructionException {
        Blob sb = this.b.createSubBlob(position, length);
        if (type instanceof BooleanType) {
            return new BinaryBoolean(this, sb, (BooleanType)type, params);
        }
        if (type instanceof ByteType) {
            return new BinaryByte(this, sb, (ByteType)type, params);
        }
        if (type instanceof IntegerType) {
            return new BinaryInteger(this, sb, (IntegerType)type, params);
        }
        if (type instanceof LongType) {
            return new BinaryLong(this, sb, (LongType)type, params);
        }
        if (type instanceof FloatType) {
            return new BinaryFloat(this, sb, (FloatType)type, params);
        }
        if (type instanceof DoubleType) {
            return new BinaryDouble(this, sb, (DoubleType)type, params);
        }
        if (type instanceof StringType) {
            return new BinaryString(this, sb, (StringType)type, params);
        }
        if (type instanceof OptionalType) {
            return new BinaryOptional(this, sb, (OptionalType)type, params);
        }
        if (type instanceof UnionType) {
            return new BinaryUnion(this, sb, (Datatype)((UnionType)type), params);
        }
        if (type instanceof VariantType) {
            return new BinaryVariant(this, sb, (Datatype)((VariantType)type), params);
        }
        if (type instanceof ArrayType) {
            return new BinaryArray(this, sb, (Datatype)((ArrayType)type), params);
        }
        if (type instanceof MapType) {
            return new BinaryMap(this, sb, (Datatype)((MapType)type), params);
        }
        if (type instanceof RecordType) {
            return new BinaryRecord(this, sb, (RecordType)type, params);
        }
        throw new AccessorConstructionException("Can not create accessor to " + String.valueOf(type));
    }

    protected void emitEvent(ListenerEntry le, Event e) {
        e.reference = ChildReference.concatenate(le.path, e.reference);
        le.emitEvent(e);
    }

    protected void emitEvents(ListenerEntry le, Collection<Event> events) {
        for (Event e : events) {
            e.reference = ChildReference.concatenate(le.path, e.reference);
        }
        le.emitEvents(events);
    }

    public Lock getReadLock() {
        return this.params.readLock;
    }

    public Lock getWriteLock() {
        return this.params.writeLock;
    }

    protected void readLock() {
        if (this.params.readLock != null) {
            this.params.readLock.lock();
        }
    }

    protected void readUnlock() {
        if (this.params.readLock != null) {
            this.params.readLock.unlock();
        }
    }

    protected void writeLock() {
        if (this.params.writeLock != null) {
            this.params.writeLock.lock();
        }
    }

    protected void writeUnlock() {
        if (this.params.writeLock != null) {
            this.params.writeLock.unlock();
        }
    }
}

