/*
 * Decompiled with CFR 0.152.
 */
package hdf.hdf5lib;

import hdf.hdf5lib.ArrayDescriptor;
import hdf.hdf5lib.HDFNativeData;
import hdf.hdf5lib.exceptions.HDF5Exception;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.io.Serializable;
import java.lang.reflect.Array;

public class HDFArray {
    private Object _theArray = null;
    private ArrayDescriptor _desc = null;
    private byte[] _barray = null;

    public HDFArray(Object object) throws HDF5Exception {
        Serializable serializable;
        if (object == null) {
            serializable = new HDF5JavaException("HDFArray: array is null?: ");
        }
        if (!(serializable = object.getClass()).isArray()) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: not an array?: ");
            throw hDF5JavaException;
        }
        this._theArray = object;
        this._desc = new ArrayDescriptor(this._theArray);
        if (this._desc == null) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: internal error: array description failed?: ");
            throw hDF5JavaException;
        }
    }

    public byte[] emptyBytes() throws HDF5JavaException {
        byte[] byArray = null;
        byArray = ArrayDescriptor.dims == 1 && ArrayDescriptor.NT == 'B' ? (byte[])this._theArray : new byte[ArrayDescriptor.totalSize];
        if (byArray == null) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: emptyBytes: allocation failed");
            throw hDF5JavaException;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] byteify() throws HDF5JavaException {
        int n;
        if (this._barray != null) {
            return this._barray;
        }
        if (this._theArray == null) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify not an array?: ");
            throw hDF5JavaException;
        }
        if (ArrayDescriptor.dims == 1) {
            if (ArrayDescriptor.NT == 'B') {
                this._barray = (byte[])this._theArray;
                return this._barray;
            }
            try {
                byte[] byArray;
                this._barray = new byte[ArrayDescriptor.totalSize];
                if (ArrayDescriptor.NT == 'I') {
                    byArray = HDFNativeData.intToByte(0, ArrayDescriptor.dimlen[1], (int[])this._theArray);
                } else if (ArrayDescriptor.NT == 'S') {
                    byArray = HDFNativeData.shortToByte(0, ArrayDescriptor.dimlen[1], (short[])this._theArray);
                } else if (ArrayDescriptor.NT == 'F') {
                    byArray = HDFNativeData.floatToByte(0, ArrayDescriptor.dimlen[1], (float[])this._theArray);
                } else if (ArrayDescriptor.NT == 'J') {
                    byArray = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[1], (long[])this._theArray);
                } else if (ArrayDescriptor.NT == 'D') {
                    byArray = HDFNativeData.doubleToByte(0, ArrayDescriptor.dimlen[1], (double[])this._theArray);
                } else {
                    if (ArrayDescriptor.NT != 'L') {
                        HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: unknown type of data?");
                        throw hDF5JavaException;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        byArray = this.ByteObjToByte((Byte[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        byArray = this.IntegerToByte((Integer[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        byArray = this.ShortToByte((Short[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        byArray = this.FloatObjToByte((Float[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        byArray = this.DoubleObjToByte((Double[])this._theArray);
                    } else {
                        if (!ArrayDescriptor.className.equals("java.lang.Long")) {
                            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: unknown type of Object?");
                            throw hDF5JavaException;
                        }
                        byArray = this.LongObjToByte((Long[])this._theArray);
                    }
                }
                System.arraycopy(byArray, 0, this._barray, 0, ArrayDescriptor.dimlen[1] * ArrayDescriptor.NTsize);
                return this._barray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify array too big?");
                throw hDF5JavaException;
            }
        }
        try {
            this._barray = new byte[ArrayDescriptor.totalSize];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify array too big?");
            throw hDF5JavaException;
        }
        Object object = this._theArray;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n2 >= ArrayDescriptor.totalSize) {
                if (n2 < ArrayDescriptor.totalSize) {
                    throw new InternalError(new String("HDFArray::byteify: Panic didn't complete all input data: n=  " + n2 + " size = " + ArrayDescriptor.totalSize));
                }
                break;
            }
            object = ArrayDescriptor.objs[0];
            n3 = n2 / ArrayDescriptor.bytetoindex[0];
            n3 %= ArrayDescriptor.dimlen[0];
            for (n = 0; n < ArrayDescriptor.dims; ++n) {
                n3 = n2 / ArrayDescriptor.bytetoindex[n];
                if ((n3 %= ArrayDescriptor.dimlen[n]) == ArrayDescriptor.currentindex[n]) {
                    object = ArrayDescriptor.objs[n];
                    continue;
                }
                if (n3 > ArrayDescriptor.dimlen[n] - 1) {
                    throw new IndexOutOfBoundsException("HDFArray: byteify index OOB?");
                }
                object = Array.get(object, n3);
                ArrayDescriptor.currentindex[n] = n3;
                ArrayDescriptor.objs[n] = object;
            }
            try {
                byte[] byArray;
                if (ArrayDescriptor.NT == 'J') {
                    byArray = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    byArray = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'I') {
                    byArray = HDFNativeData.intToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (int[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'S') {
                    byArray = HDFNativeData.shortToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (short[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'B') {
                    byArray = (byte[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1];
                } else if (ArrayDescriptor.NT == 'F') {
                    byArray = HDFNativeData.floatToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (float[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'D') {
                    byArray = HDFNativeData.doubleToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (double[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else {
                    if (ArrayDescriptor.NT != 'L') {
                        HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify unknown type not implemented?");
                        throw hDF5JavaException;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        byArray = this.ByteObjToByte((Byte[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        byArray = this.IntegerToByte((Integer[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        byArray = this.ShortToByte((Short[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        byArray = this.FloatObjToByte((Float[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        byArray = this.DoubleObjToByte((Double[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else {
                        if (!ArrayDescriptor.className.equals("java.lang.Long")) {
                            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify Object type not implemented?");
                            throw hDF5JavaException;
                        }
                        byArray = this.LongObjToByte((Long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    }
                }
                System.arraycopy(byArray, 0, this._barray, n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims] * ArrayDescriptor.NTsize);
                n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: byteify array too big?");
                throw hDF5JavaException;
            }
        }
        n = 0;
        while (n < ArrayDescriptor.dims) {
            if (ArrayDescriptor.currentindex[n] != ArrayDescriptor.dimlen[n] - 1) {
                throw new InternalError(new String("Panic didn't complete all data: currentindex[" + n + "] = " + ArrayDescriptor.currentindex[n] + " (should be " + (ArrayDescriptor.dimlen[n] - 1) + " ?)"));
            }
            ++n;
        }
        return this._barray;
    }

    public Object arrayify(byte[] byArray) throws HDF5JavaException {
        int n;
        if (this._theArray == null) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("arrayify: not an array?: ");
            throw hDF5JavaException;
        }
        if (Array.getLength(byArray) != ArrayDescriptor.totalSize) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("arrayify: array is wrong size?: ");
            throw hDF5JavaException;
        }
        this._barray = byArray;
        if (ArrayDescriptor.dims == 1) {
            try {
                if (ArrayDescriptor.NT == 'I') {
                    int[] nArray = HDFNativeData.byteToInt(this._barray);
                    System.arraycopy(nArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'S') {
                    short[] sArray = HDFNativeData.byteToShort(this._barray);
                    System.arraycopy(sArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'F') {
                    float[] fArray = HDFNativeData.byteToFloat(this._barray);
                    System.arraycopy(fArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'J') {
                    long[] lArray = HDFNativeData.byteToLong(this._barray);
                    System.arraycopy(lArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'D') {
                    double[] dArray = HDFNativeData.byteToDouble(this._barray);
                    System.arraycopy(dArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'B') {
                    System.arraycopy(this._barray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'L') {
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        Byte[] byteArray = this.ByteToByteObj(this._barray);
                        System.arraycopy(byteArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        Integer[] integerArray = this.ByteToInteger(this._barray);
                        System.arraycopy(integerArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        Short[] shortArray = this.ByteToShort(this._barray);
                        System.arraycopy(shortArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        Float[] floatArray = this.ByteToFloatObj(this._barray);
                        System.arraycopy(floatArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        Double[] doubleArray = this.ByteToDoubleObj(this._barray);
                        System.arraycopy(doubleArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Long")) {
                        Long[] longArray = this.ByteToLongObj(this._barray);
                        System.arraycopy(longArray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    HDF5JavaException hDF5JavaException = new HDF5JavaException("arrayify:  Object type not implemented yet...");
                    throw hDF5JavaException;
                }
                HDF5JavaException hDF5JavaException = new HDF5JavaException("arrayify:  unknown type not implemented yet...");
                throw hDF5JavaException;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: arrayify array too big?");
                throw hDF5JavaException;
            }
        }
        Object object = this._theArray;
        int n2 = 0;
        int n3 = 0;
        while (n2 < ArrayDescriptor.totalSize) {
            object = ArrayDescriptor.objs[0];
            n3 = n2 / ArrayDescriptor.bytetoindex[0];
            n3 %= ArrayDescriptor.dimlen[0];
            for (n = 0; n < ArrayDescriptor.dims; ++n) {
                n3 = n2 / ArrayDescriptor.bytetoindex[n];
                if ((n3 %= ArrayDescriptor.dimlen[n]) == ArrayDescriptor.currentindex[n]) {
                    object = ArrayDescriptor.objs[n];
                    continue;
                }
                if (n3 > ArrayDescriptor.dimlen[n] - 1) {
                    System.out.println("out of bounds?");
                    return null;
                }
                object = Array.get(object, n3);
                ArrayDescriptor.currentindex[n] = n3;
                ArrayDescriptor.objs[n] = object;
            }
            try {
                Object object2;
                if (ArrayDescriptor.NT == 'J') {
                    object2 = HDFNativeData.byteToLong(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                    n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n4 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n4] = ArrayDescriptor.currentindex[n4] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'I') {
                    object2 = HDFNativeData.byteToInt(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                    n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n5 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n5] = ArrayDescriptor.currentindex[n5] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'S') {
                    object2 = HDFNativeData.byteToShort(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                    n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n6 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n6] = ArrayDescriptor.currentindex[n6] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'B') {
                    System.arraycopy(this._barray, n2, ArrayDescriptor.objs[ArrayDescriptor.dims - 1], 0, ArrayDescriptor.dimlen[ArrayDescriptor.dims]);
                    n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    continue;
                }
                if (ArrayDescriptor.NT == 'F') {
                    object2 = HDFNativeData.byteToFloat(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                    n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n7 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n7] = ArrayDescriptor.currentindex[n7] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'D') {
                    object2 = HDFNativeData.byteToDouble(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                    Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                    n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                    int n8 = ArrayDescriptor.dims - 1;
                    ArrayDescriptor.currentindex[n8] = ArrayDescriptor.currentindex[n8] + 1;
                    continue;
                }
                if (ArrayDescriptor.NT == 'L') {
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        object2 = this.ByteToByteObj(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n9 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n9] = ArrayDescriptor.currentindex[n9] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        object2 = this.ByteToInteger(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n10 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n10] = ArrayDescriptor.currentindex[n10] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        object2 = this.ByteToShort(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n11 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n11] = ArrayDescriptor.currentindex[n11] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        object2 = this.ByteToFloatObj(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n12 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n12] = ArrayDescriptor.currentindex[n12] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        object2 = this.ByteToDoubleObj(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n13 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n13] = ArrayDescriptor.currentindex[n13] + 1;
                        continue;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Long")) {
                        object2 = this.ByteToLongObj(n2, ArrayDescriptor.dimlen[ArrayDescriptor.dims], this._barray);
                        Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], object2);
                        n2 += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                        int n14 = ArrayDescriptor.dims - 1;
                        ArrayDescriptor.currentindex[n14] = ArrayDescriptor.currentindex[n14] + 1;
                        continue;
                    }
                    object2 = new HDF5JavaException("HDFArray: unsupported Object type: " + ArrayDescriptor.NT);
                    throw object2;
                }
                object2 = new HDF5JavaException("HDFArray: unknown or unsupported type: " + ArrayDescriptor.NT);
                throw object2;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: arrayify array too big?");
                throw hDF5JavaException;
            }
        }
        if (n2 < ArrayDescriptor.totalSize) {
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all input data: n=  " + n2 + " size = " + ArrayDescriptor.totalSize));
        }
        for (n = 0; n <= ArrayDescriptor.dims - 2; ++n) {
            if (ArrayDescriptor.currentindex[n] == ArrayDescriptor.dimlen[n] - 1) continue;
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + n + "] = " + ArrayDescriptor.currentindex[n] + " (should be " + (ArrayDescriptor.dimlen[n] - 1) + "?"));
        }
        if (ArrayDescriptor.NT != 'B') {
            if (ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1] != ArrayDescriptor.dimlen[ArrayDescriptor.dims - 1]) {
                throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + n + "] = " + ArrayDescriptor.currentindex[n] + " (should be " + ArrayDescriptor.dimlen[n] + "?"));
            }
        } else if (ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1] != ArrayDescriptor.dimlen[ArrayDescriptor.dims - 1] - 1) {
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + n + "] = " + ArrayDescriptor.currentindex[n] + " (should be " + (ArrayDescriptor.dimlen[n] - 1) + "?"));
        }
        return this._theArray;
    }

    private byte[] IntegerToByte(Integer[] integerArray) {
        int n = Array.getLength(integerArray);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = integerArray[i];
        }
        return HDFNativeData.intToByte(0, n, nArray);
    }

    private Integer[] ByteToInteger(byte[] byArray) {
        int[] nArray = HDFNativeData.byteToInt(byArray);
        int n = Array.getLength(nArray);
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = new Integer(nArray[i]);
        }
        return integerArray;
    }

    private Integer[] ByteToInteger(int n, int n2, byte[] byArray) {
        int[] nArray = HDFNativeData.byteToInt(n, n2, byArray);
        int n3 = Array.getLength(nArray);
        Integer[] integerArray = new Integer[n3];
        for (int i = 0; i < n3; ++i) {
            integerArray[i] = new Integer(nArray[i]);
        }
        return integerArray;
    }

    private byte[] ShortToByte(Short[] shortArray) {
        int n = Array.getLength(shortArray);
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = shortArray[i];
        }
        return HDFNativeData.shortToByte(0, n, sArray);
    }

    private Short[] ByteToShort(byte[] byArray) {
        short[] sArray = HDFNativeData.byteToShort(byArray);
        int n = Array.getLength(sArray);
        Short[] shortArray = new Short[n];
        for (int i = 0; i < n; ++i) {
            shortArray[i] = new Short(sArray[i]);
        }
        return shortArray;
    }

    private Short[] ByteToShort(int n, int n2, byte[] byArray) {
        short[] sArray = HDFNativeData.byteToShort(n, n2, byArray);
        int n3 = Array.getLength(sArray);
        Short[] shortArray = new Short[n3];
        for (int i = 0; i < n3; ++i) {
            shortArray[i] = new Short(sArray[i]);
        }
        return shortArray;
    }

    private byte[] ByteObjToByte(Byte[] byteArray) {
        int n = Array.getLength(byteArray);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = byteArray[i];
        }
        return byArray;
    }

    private Byte[] ByteToByteObj(byte[] byArray) {
        int n = Array.getLength(byArray);
        Byte[] byteArray = new Byte[n];
        for (int i = 0; i < n; ++i) {
            byteArray[i] = new Byte(byArray[i]);
        }
        return byteArray;
    }

    private Byte[] ByteToByteObj(int n, int n2, byte[] byArray) {
        Byte[] byteArray = new Byte[n2];
        for (int i = 0; i < n2; ++i) {
            byteArray[i] = new Byte(byArray[i]);
        }
        return byteArray;
    }

    private byte[] FloatObjToByte(Float[] floatArray) {
        int n = Array.getLength(floatArray);
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = floatArray[i].floatValue();
        }
        return HDFNativeData.floatToByte(0, n, fArray);
    }

    private Float[] ByteToFloatObj(byte[] byArray) {
        float[] fArray = HDFNativeData.byteToFloat(byArray);
        int n = Array.getLength(fArray);
        Float[] floatArray = new Float[n];
        for (int i = 0; i < n; ++i) {
            floatArray[i] = new Float(fArray[i]);
        }
        return floatArray;
    }

    private Float[] ByteToFloatObj(int n, int n2, byte[] byArray) {
        float[] fArray = HDFNativeData.byteToFloat(n, n2, byArray);
        int n3 = Array.getLength(fArray);
        Float[] floatArray = new Float[n3];
        for (int i = 0; i < n3; ++i) {
            floatArray[i] = new Float(fArray[i]);
        }
        return floatArray;
    }

    private byte[] DoubleObjToByte(Double[] doubleArray) {
        int n = Array.getLength(doubleArray);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = doubleArray[i];
        }
        return HDFNativeData.doubleToByte(0, n, dArray);
    }

    private Double[] ByteToDoubleObj(byte[] byArray) {
        double[] dArray = HDFNativeData.byteToDouble(byArray);
        int n = Array.getLength(dArray);
        Double[] doubleArray = new Double[n];
        for (int i = 0; i < n; ++i) {
            doubleArray[i] = new Double(dArray[i]);
        }
        return doubleArray;
    }

    private Double[] ByteToDoubleObj(int n, int n2, byte[] byArray) {
        double[] dArray = HDFNativeData.byteToDouble(n, n2, byArray);
        int n3 = Array.getLength(dArray);
        Double[] doubleArray = new Double[n3];
        for (int i = 0; i < n3; ++i) {
            doubleArray[i] = new Double(dArray[i]);
        }
        return doubleArray;
    }

    private byte[] LongObjToByte(Long[] longArray) {
        int n = Array.getLength(longArray);
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = longArray[i];
        }
        return HDFNativeData.longToByte(0, n, lArray);
    }

    private Long[] ByteToLongObj(byte[] byArray) {
        long[] lArray = HDFNativeData.byteToLong(byArray);
        int n = Array.getLength(lArray);
        Long[] longArray = new Long[n];
        for (int i = 0; i < n; ++i) {
            longArray[i] = new Long(lArray[i]);
        }
        return longArray;
    }

    private Long[] ByteToLongObj(int n, int n2, byte[] byArray) {
        long[] lArray = HDFNativeData.byteToLong(n, n2, byArray);
        int n3 = Array.getLength(lArray);
        Long[] longArray = new Long[n3];
        for (int i = 0; i < n3; ++i) {
            longArray[i] = new Long(lArray[i]);
        }
        return longArray;
    }
}

