/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.hints;

import java.util.Map;
import org.simantics.utils.datastructures.hints.IHintObservable;

public interface IHintContext
extends IHintObservable {
    public void setHint(Key var1, Object var2);

    public void setHints(Map<Key, Object> var1);

    public <E> E removeHint(Key var1);

    public void clearWithoutNotification();

    public static abstract class Key {
        public abstract boolean isValueAccepted(Object var1);
    }

    public static class KeyOf
    extends Key {
        final Class<?> clazz;
        final String keyName;

        public KeyOf(Class<?> clazz) {
            this.clazz = clazz;
            this.keyName = null;
        }

        public KeyOf(Class<?> clazz, String keyName) {
            this.clazz = clazz;
            this.keyName = keyName;
        }

        @Override
        public boolean isValueAccepted(Object value) {
            return this.clazz.isInstance(value);
        }

        public String toString() {
            if (this.keyName == null) {
                return "Key Of " + this.clazz.getName();
            }
            return this.keyName + "(" + this.clazz.getSimpleName() + ")";
        }
    }

    public static abstract class MouseSpecificKey
    extends Key {
        private final int mouseId;

        public MouseSpecificKey(int mouseId) {
            this.mouseId = mouseId;
        }

        public int getMouseId() {
            return this.mouseId;
        }

        public int hashCode() {
            return super.hashCode() ^ this.mouseId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MouseSpecificKey)) {
                return false;
            }
            if (((MouseSpecificKey)obj).mouseId != this.mouseId) {
                return false;
            }
            return obj.getClass().equals(this.getClass());
        }
    }

    public static class MouseSpecificKeyOf
    extends MouseSpecificKey {
        public final Class<?> clazz;
        public final int mouseId;
        final int hash;

        public MouseSpecificKeyOf(int mouseId, Class<?> clazz) {
            super(mouseId);
            this.clazz = clazz;
            this.mouseId = mouseId;
            this.hash = this.getClass().hashCode() ^ mouseId ^ 0x17432F7;
        }

        @Override
        public boolean isValueAccepted(Object value) {
            return this.clazz.isInstance(value);
        }

        @Override
        public int hashCode() {
            return this.hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            MouseSpecificKeyOf other = (MouseSpecificKeyOf)obj;
            return other.mouseId == this.mouseId;
        }
    }

    public static abstract class StringKey
    extends Key {
        protected final String str;
        protected int hash;

        public StringKey(String str) {
            this.str = str;
            this.hash = this.getClass().hashCode() ^ str.hashCode();
        }

        public String getString() {
            return this.str;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StringKey)) {
                return false;
            }
            if (!((StringKey)obj).str.equals(this.str)) {
                return false;
            }
            return obj.getClass() == this.getClass();
        }
    }

    public static class StringKeyOf
    extends StringKey {
        final Class<?> clazz;

        public StringKeyOf(String str, Class<?> clazz) {
            super(str);
            this.clazz = clazz;
        }

        @Override
        public boolean isValueAccepted(Object value) {
            return this.clazz.isInstance(value);
        }

        public String toString() {
            return "Key Of (" + this.clazz.getName() + ", " + this.str + ")";
        }
    }
}

