/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.utils;

import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.constants.SCLConstant;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAClosure;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAModule;

public class SSALambdaLiftingContext {
    SSAModule module;
    Name parentName;
    int count;
    ErrorLog errorLog;

    public SSALambdaLiftingContext(SSAModule module, ErrorLog errorLog) {
        this.module = module;
        this.errorLog = errorLog;
    }

    public void setParentName(Name parentName) {
        this.parentName = parentName;
        this.count = 0;
    }

    public Name createName() {
        return Name.create(this.parentName.module, this.parentName.name + "$" + ++this.count);
    }

    public void addConstant(SCLConstant constant) {
        this.module.put(constant.getName(), constant);
    }

    public void validate() {
        this.module.validate();
    }

    public ErrorLog getErrorLog() {
        return this.errorLog;
    }

    public void addClosure(SSAClosure closure) {
        this.module.closuresToGenerate.add(closure);
    }
}

