/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.utils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.slf4j.Logger;

public class LoggingOutputStream
extends OutputStream {
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
    private final Logger logger;
    private final LogLevel level;

    public LoggingOutputStream(Logger logger, LogLevel level) {
        this.logger = logger;
        this.level = level;
    }

    @Override
    public void write(int b) {
        if (b == 10) {
            String line = this.baos.toString();
            this.baos.reset();
            switch (this.level) {
                case TRACE: {
                    this.logger.trace(line);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(line);
                    break;
                }
                case ERROR: {
                    this.logger.error(line);
                    break;
                }
                case INFO: {
                    this.logger.info(line);
                    break;
                }
                case WARN: {
                    this.logger.warn(line);
                }
            }
        } else {
            this.baos.write(b);
        }
    }

    public static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

