/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.rpcexperiment;

import com.google.protobuf.ProtocolStringList;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.fmi.experiment.FMIChildNode;
import org.simantics.fmi.experiment.FMIExperimentDataFrame;
import org.simantics.fmi.experiment.FMIFolderNode;
import org.simantics.fmi.experiment.FMINodeBase;
import org.simantics.fmi.experiment.FMIValueNode;
import org.simantics.fmi.experiment.FMIVariableNode;
import org.simantics.fmi.experiment.HDF5Subscriptions;
import org.simantics.fmi.experiment.HDF5Support;
import org.simantics.fmi.experiment.IFMIExperiment;
import org.simantics.fmi.rpcexperiment.ExtProcess;
import org.simantics.fmi.rpcexperiment.FMIProtos;
import org.simantics.fmi.rpcexperiment.FMIServiceGrpc;
import org.simantics.fmi.rpcexperiment.FMIUtil;
import org.simantics.fmi.rpcexperiment.JavaProcess;
import org.simantics.fmil.core.FMILException;
import org.simantics.simulator.ExperimentState;
import org.simantics.simulator.toolkit.DynamicExperimentThreadListener;
import org.simantics.simulator.toolkit.StandardExperimentStates;
import org.simantics.simulator.variable.exceptions.NoValueException;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMIRPCExperiment
implements IFMIExperiment {
    private static final Logger LOGGER = LoggerFactory.getLogger(FMIRPCExperiment.class);
    private static boolean DEBUG = false;
    private static boolean FORCE_DOUBLE = false;
    private final FMIFolderNode ROOT = new FMIFolderNode(null, "");
    private ManagedChannel channel;
    private FMIServiceGrpc.FMIServiceBlockingStub blockingStub;
    private FMIServiceGrpc.FMIServiceStub stub;
    private JavaProcess process;
    private String id;
    private Set<String> variableNames;
    private TObjectIntMap<String> variableTypes;
    private FMIExperimentDataFrame frame;
    private Object frameMutex = new Object();
    private boolean initialized = false;
    private boolean shutdown = false;
    private Set<String> stored = new HashSet<String>();
    private Set<String> subscribed = new HashSet<String>();
    private StreamObserver<FMIProtos.ValueResponse> valueListener;
    private StreamObserver<FMIProtos.StateResponse> stateListener;
    private ExperimentState state = StandardExperimentStates.CREATED;
    private int deadline = 5;
    private int initDeadline = 10;
    private Semaphore stopSemaphore = new Semaphore(0);
    private boolean launchProcess = true;
    private List<String> verifiedHdf5Subscriptions = new ArrayList<String>();
    private HDF5Subscriptions subscriptions;
    private final HDF5Support hdf;
    private DynamicExperimentThreadListener stopListener = new DynamicExperimentThreadListener(){

        public void stateChanged(ExperimentState newState) {
            if (newState == StandardExperimentStates.STOPPED) {
                FMIRPCExperiment.this.stopSemaphore.release();
            }
        }
    };
    private CopyOnWriteArrayList<DynamicExperimentThreadListener> listeners = new CopyOnWriteArrayList();

    public FMIRPCExperiment(File workingDirectory, File fmuFile, String id) throws Exception {
        this(workingDirectory, fmuFile, id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FMIRPCExperiment(File workingDirectory, File fmuFile, String id, List<String> hdf5Subs) throws Exception {
        this.id = id;
        if (hdf5Subs != null && hdf5Subs.size() != 0) {
            this.subscriptions = new HDF5Subscriptions(hdf5Subs);
            this.hdf = new HDF5Support(new File(workingDirectory, "data.h5"));
        } else {
            this.subscriptions = null;
            this.hdf = null;
        }
        if (Boolean.parseBoolean(System.getProperty("org.simantics.fmi.rpc.debug"))) {
            DEBUG = true;
        }
        if (Boolean.parseBoolean(System.getProperty("org.simantics.fmi.forcedouble"))) {
            FORCE_DOUBLE = true;
        }
        if (DEBUG) {
            System.out.println("Starting FMU experiment with " + workingDirectory.getAbsolutePath() + " " + fmuFile.getAbsolutePath() + " " + id);
        }
        LOGGER.info("Starting FMU experiment with " + workingDirectory.getAbsolutePath() + " " + fmuFile.getAbsolutePath() + " " + id);
        try {
            int port = 50001;
            if (this.launchProcess) {
                String serverExe = this.resolveServerExe();
                if (serverExe == null) {
                    if (DEBUG) {
                        System.out.println("Cannot locate FMU Server executable. Use org.simantics.fmi.rpc.exe property to define it.");
                    }
                    LOGGER.error("Cannot locate FMU Server executable. Use org.simantics.fmi.rpc.exe property to define it.");
                    throw new FileNotFoundException("Cannot locate FMU Server executable. Use org.simantics.fmi.rpc.exe property to define it.");
                }
                this.loadParameters();
                try {
                    port = this.locateFreePort();
                    if (DEBUG) {
                        System.out.println("Starting FMU Server at port " + port);
                    }
                    LOGGER.info("Starting FMU Server at port " + port);
                    this.process = new ExtProcess(serverExe, "-vmargs", "-Dorg.simantics.fmi.rpc.port=" + port);
                    this.process.execAsync();
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.process.getProcess().isAlive()) {
                    throw new FMILException("Remote FMU process failed to start.");
                }
            }
            this.init("localhost", port);
            FMIProtos.BasicResponse Response = this.getDeadlineStub(this.initDeadline).load(FMIProtos.LoadRequest.newBuilder().setFmuFile(fmuFile.getAbsolutePath()).setWorkingDirectory(workingDirectory.getAbsolutePath()).build());
            if (!Response.getSuccess()) {
                throw new FMILException("Remote FMU failed to load.");
            }
            Response = this.getDeadlineStub(this.initDeadline).instantiateSimulation(FMIProtos.BasicRequest.getDefaultInstance());
            if (!Response.getSuccess()) {
                throw new FMILException("Remote FMU failed to instantiate.");
            }
            FMIProtos.VariablesResponse variablesResponse = this.blockingStub.getAllVariables(FMIProtos.BasicRequest.getDefaultInstance());
            ProtocolStringList names = variablesResponse.getNameList();
            List types = variablesResponse.getTypeList();
            this.variableTypes = new TObjectIntHashMap(names.size(), 0.5f, -1);
            int i = 0;
            while (i < names.size()) {
                this.variableTypes.put((Object)((String)names.get(i)), ((Integer)types.get(i)).intValue());
                ++i;
            }
            this.variableNames = this.variableTypes.keySet();
            if (this.variableNames.size() == 0) {
                throw new FMILException("Remote FMU failed to report variable names.");
            }
            this.createNodes(this.variableNames);
            Object object = this.frameMutex;
            synchronized (object) {
                this.frame = new FMIExperimentDataFrame(0.0, this.variableNames.size());
                for (String s : this.variableNames) {
                    this.frame.setValue(s, (Object)0.0);
                }
            }
            this.stateListener = new StreamObserver<FMIProtos.StateResponse>(){

                public void onNext(FMIProtos.StateResponse arg0) {
                    if (arg0.getStateId() == -10) {
                        FMIRPCExperiment.this.fireBeforeStep();
                    } else if (arg0.getStateId() == -20) {
                        FMIRPCExperiment.this.fireAfterStep();
                    } else {
                        ExperimentState state = FMIUtil.getState(arg0.getStateId());
                        if (state != null) {
                            FMIRPCExperiment.this.state = state;
                            FMIRPCExperiment.this.fireStateChanged(state);
                        }
                    }
                }

                public void onCompleted() {
                    FMIRPCExperiment.this.stateListener = null;
                }

                public void onError(Throwable arg0) {
                }
            };
            this.state = FMIUtil.getState(this.blockingStub.getState(FMIProtos.BasicRequest.getDefaultInstance()).getStateId());
            this.stub.getStateChanges(FMIProtos.BasicRequest.getDefaultInstance(), this.stateListener);
            if (DEBUG) {
                System.out.println("Remote FMU process started.");
            }
            LOGGER.info("Remote FMU process started.");
        }
        catch (Exception e) {
            this.shutdown = true;
            try {
                if (this.blockingStub != null) {
                    this.blockingStub.shutdown(FMIProtos.BasicRequest.getDefaultInstance());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.channel != null) {
                    this.channel.shutdownNow();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.process != null) {
                try {
                    this.process.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (DEBUG) {
                e.printStackTrace();
            }
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private String resolveServerExe() {
        String userDir;
        Object serverExe = System.getProperty("org.simantics.fmi.rpc.exe");
        if (!this.checkExists((String)serverExe) && (userDir = System.getProperty("user.dir")) != null && userDir.indexOf(File.separator) != -1) {
            serverExe = userDir.substring(0, userDir.lastIndexOf(File.separator)) + "\\fmiserver\\fmiServer.exe";
        }
        if (!this.checkExists((String)serverExe)) {
            serverExe = null;
        }
        return serverExe;
    }

    private void loadParameters() {
        String portString2;
        try {
            portString2 = System.getProperty("org.simantics.fmi.rpc.deadline");
            if (portString2 != null) {
                this.deadline = Math.max(1, Integer.parseInt(portString2));
            }
        }
        catch (Exception portString2) {
            // empty catch block
        }
        try {
            portString2 = System.getProperty("org.simantics.fmi.rpc.initdeadline");
            if (portString2 != null) {
                this.initDeadline = Math.max(1, Integer.parseInt(portString2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean checkExists(String serverExe) {
        if (serverExe == null) {
            return false;
        }
        File file = new File(serverExe);
        return file.exists() && file.canExecute();
    }

    private int locateFreePort() throws IOException {
        Socket socket = new Socket();
        socket.bind(null);
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    private void init(String host, int port) {
        this.channel = NettyChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
        this.blockingStub = FMIServiceGrpc.newBlockingStub((Channel)this.channel);
        this.stub = FMIServiceGrpc.newStub((Channel)this.channel);
    }

    private FMIServiceGrpc.FMIServiceBlockingStub getDeadlineStub() {
        return this.getDeadlineStub(this.deadline);
    }

    private FMIServiceGrpc.FMIServiceBlockingStub getDeadlineStub(int seconds) {
        return (FMIServiceGrpc.FMIServiceBlockingStub)this.blockingStub.withDeadlineAfter((long)seconds, TimeUnit.SECONDS);
    }

    public int getDeadline() {
        return this.deadline;
    }

    public void setDeadline(int deadline) {
        this.deadline = deadline;
    }

    public <T> T getService(Class<T> clazz) {
        return null;
    }

    public String getIdentifier() {
        return this.id;
    }

    private void checkInitialization() {
        if (!this.initialized) {
            this.initializeSimulation();
        }
    }

    public boolean initializeSimulation() {
        if (this.initialized) {
            return true;
        }
        if (this.shutdown) {
            return false;
        }
        try {
            this.prepareHDF5DataWrite();
        }
        catch (FMILException e) {
            LOGGER.error("Failure during HDF5 preparation step in initializeSimulation for " + this.id, (Throwable)e);
        }
        FMIProtos.BasicResponse response = this.getDeadlineStub().initializeSimulation(FMIProtos.BasicRequest.getDefaultInstance());
        if (!response.getSuccess()) {
            return false;
        }
        this.valueListener = new StreamObserver<FMIProtos.ValueResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(FMIProtos.ValueResponse arg0) {
                Object object = FMIRPCExperiment.this.frameMutex;
                synchronized (object) {
                    FMIRPCExperiment.this.frame = FMIRPCExperiment.this.frame != null ? new FMIExperimentDataFrame(arg0.getTime(), FMIRPCExperiment.this.frame) : new FMIExperimentDataFrame(arg0.getTime(), arg0.getNameCount());
                    int i = 0;
                    while (i < arg0.getNameCount()) {
                        String name = arg0.getName(i);
                        FMIProtos.ValueOption valueOption = arg0.getValue(i);
                        switch (valueOption.getValueCase()) {
                            case REALVALUE: {
                                FMIRPCExperiment.this.frame.setValue(name, (Object)valueOption.getRealValue());
                                break;
                            }
                            case INTVALUE: {
                                FMIRPCExperiment.this.frame.setValue(name, (Object)valueOption.getIntValue());
                                break;
                            }
                            case BOOLVALUE: {
                                FMIRPCExperiment.this.frame.setValue(name, (Object)valueOption.getBoolValue());
                                break;
                            }
                            case STRINGVALUE: {
                                FMIRPCExperiment.this.frame.setValue(name, (Object)valueOption.getStringValue());
                                break;
                            }
                            default: {
                                LOGGER.debug("Unknown value response type " + String.valueOf(valueOption.getValueCase()));
                            }
                        }
                        ++i;
                    }
                }
            }

            public void onCompleted() {
                FMIRPCExperiment.this.valueListener = null;
            }

            public void onError(Throwable arg0) {
            }
        };
        this.stub.getSubscribedValues(FMIProtos.BasicRequest.getDefaultInstance(), this.valueListener);
        this.initialized = true;
        return true;
    }

    public void shutdown(IProgressMonitor monitor) {
        try {
            this.shutdown = true;
            this.getDeadlineStub(this.initDeadline).shutdown(FMIProtos.BasicRequest.getDefaultInstance());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            if (this.channel != null) {
                this.channel.shutdownNow();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (this.process != null) {
            try {
                this.process.dispose();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        this.endHDF5();
    }

    public ExperimentState getStateL() {
        return this.state;
    }

    public void changeStateL(ExperimentState state) {
        if (this.shutdown) {
            return;
        }
        this.getDeadlineStub().setState(FMIProtos.StateRequest.newBuilder().setStateId(FMIUtil.getStateIndex(state)).build());
    }

    public void simulate(boolean enabled) {
        if (this.shutdown) {
            return;
        }
        this.checkInitialization();
        this.getDeadlineStub().simulate(FMIProtos.SimulateRequest.newBuilder().setEnabled(enabled).build());
        this.updateHDF5SubscriptionsAndTime();
    }

    public void simulateDuration(double duration) {
        if (this.shutdown) {
            return;
        }
        this.checkInitialization();
        this.getDeadlineStub().simulateDuration(FMIProtos.SimulateDurationRequest.newBuilder().setDuration(duration).build());
        this.updateHDF5SubscriptionsAndTime();
    }

    public void simulateDurationSync(double duration) {
        if (this.shutdown) {
            return;
        }
        this.checkInitialization();
        this.addListener(this.stopListener);
        try {
            try {
                this.getDeadlineStub().simulateDuration(FMIProtos.SimulateDurationRequest.newBuilder().setDuration(duration).build());
                this.stopSemaphore.acquire();
            }
            catch (InterruptedException e) {
                LOGGER.warn("simulateDurationSync interrupted", (Throwable)e);
                this.removeListener(this.stopListener);
                this.updateHDF5SubscriptionsAndTime();
            }
        }
        finally {
            this.removeListener(this.stopListener);
            this.updateHDF5SubscriptionsAndTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVariableValueById(String id, Object value, Binding binding) {
        if (this.shutdown) {
            return;
        }
        if (this.variableNames.contains(id)) {
            FMIProtos.ValueOption.Builder valueBuilder = FMIProtos.ValueOption.newBuilder();
            try {
                switch (this.variableTypes.get((Object)id)) {
                    case 0: {
                        if (!(binding instanceof NumberBinding)) {
                            throw new IllegalArgumentException("Invalid binding (" + binding.getClass().getName() + ") for real variable");
                        }
                        valueBuilder.setRealValue(((NumberBinding)binding).getValue(value).doubleValue());
                        break;
                    }
                    case 1: 
                    case 4: {
                        if (!(binding instanceof NumberBinding)) {
                            throw new IllegalArgumentException("Invalid binding (" + binding.getClass().getName() + ") for integer variable");
                        }
                        valueBuilder.setIntValue(((NumberBinding)binding).getValue(value).intValue());
                        break;
                    }
                    case 2: {
                        if (!(binding instanceof BooleanBinding)) {
                            throw new IllegalArgumentException("Invalid binding (" + binding.getClass().getName() + ") for boolean variable");
                        }
                        valueBuilder.setBoolValue(((BooleanBinding)binding).getValue_(value));
                        break;
                    }
                    case 3: {
                        if (!(binding instanceof StringBinding)) {
                            throw new IllegalArgumentException("Invalid binding (" + binding.getClass().getName() + ") for string variable");
                        }
                        valueBuilder.setStringValue(((StringBinding)binding).getValue(value));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown variable type for variablel '" + id + "'");
                    }
                }
            }
            catch (BindingException e) {
                throw new RuntimeBindingException(e);
            }
            this.getDeadlineStub().setValue(FMIProtos.SetValueRequest.newBuilder().addName(id).addValue(valueBuilder.build()).build());
        } else {
            Object object = this.frameMutex;
            synchronized (object) {
                this.frame.setValue(id, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getVariableValueById(String id) {
        if (this.shutdown) {
            return null;
        }
        if (this.variableNames.contains(id)) {
            FMIProtos.ValueResponse response = this.getDeadlineStub().getValue(FMIProtos.GetValueRequest.newBuilder().addName(id).build());
            FMIProtos.ValueOption valueMsg = response.getValue(0);
            switch (valueMsg.getValueCase()) {
                case REALVALUE: {
                    return valueMsg.getRealValue();
                }
                case INTVALUE: {
                    return valueMsg.getIntValue();
                }
                case BOOLVALUE: {
                    return valueMsg.getBoolValue();
                }
                case STRINGVALUE: {
                    return valueMsg.getStringValue();
                }
            }
            return null;
        }
        Object object = this.frameMutex;
        synchronized (object) {
            return this.frame.getValue(id);
        }
    }

    public Collection<String> getVariables() {
        return this.variableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSimulationTime() {
        Object object = this.frameMutex;
        synchronized (object) {
            if (this.frame != null) {
                return this.frame.getTime();
            }
            return 0.0;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean store(String id) throws FMILException {
        if (this.shutdown) {
            return false;
        }
        if (this.stored.contains(id)) {
            return true;
        }
        FMIProtos.BasicResponse response = this.getDeadlineStub().store(FMIProtos.SubscribeRequest.newBuilder().addName(id).build());
        if (response.getSuccess()) {
            this.stored.add(id);
            this.subscribed.add(id);
        }
        return response.getSuccess();
    }

    public boolean subscribe(String id) throws FMILException {
        if (this.shutdown) {
            return false;
        }
        if (this.subscribed.contains(id)) {
            return true;
        }
        FMIProtos.BasicResponse response = this.getDeadlineStub().subscribe(FMIProtos.SubscribeRequest.newBuilder().addName(id).build());
        if (response.getSuccess()) {
            this.subscribed.add(id);
        }
        return response.getSuccess();
    }

    private void createNodeImpl(FMIFolderNode folder, String variableName) {
        String[] parts = variableName.split("\\.");
        int i = 0;
        while (i < parts.length) {
            if (i == parts.length - 1) {
                FMIVariableNode variable = new FMIVariableNode((FMINodeBase)folder, parts[i]);
                folder.addChild((FMIChildNode)variable);
            } else {
                FMIChildNode node = folder.getChild(parts[i]);
                if (node == null) {
                    FMIFolderNode child = new FMIFolderNode((FMINodeBase)folder, parts[i]);
                    folder.addChild((FMIChildNode)child);
                    folder = child;
                } else {
                    folder = (FMIFolderNode)node;
                }
            }
            ++i;
        }
    }

    public FMINodeBase getRootNode() {
        return this.ROOT;
    }

    private void createNodes(Collection<String> names) {
        for (String name : names) {
            this.createNodeImpl(this.ROOT, name);
        }
    }

    public Object getEngineValue(FMINodeBase node) throws NodeManagerException {
        if (node instanceof FMIValueNode) {
            String id = ((FMIChildNode)node.parent).getPath();
            return this.getEngineValueById(id);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getEngineValueById(String id) throws NodeManagerException {
        try {
            this.subscribe(id);
        }
        catch (FMILException e) {
            throw new NodeManagerException((Throwable)e);
        }
        Object object = this.frameMutex;
        synchronized (object) {
            Object value = this.frame.getValue(id);
            if (value != null) {
                return value;
            }
            Object val = this.getVariableValueById(id);
            this.frame.setValue(id, val);
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FMIExperimentDataFrame getCurrentDataFrame() {
        Object object = this.frameMutex;
        synchronized (object) {
            return this.frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binding getEngineBinding(FMINodeBase node) throws NodeManagerException {
        if (!FORCE_DOUBLE) {
            String id = node.getVariableName();
            if (this.variableNames.contains(id)) {
                switch (this.variableTypes.get((Object)id)) {
                    case 0: {
                        return Bindings.DOUBLE;
                    }
                    case 1: 
                    case 4: {
                        return Bindings.INTEGER;
                    }
                    case 2: {
                        return Bindings.BOOLEAN;
                    }
                    case 3: {
                        return Bindings.STRING;
                    }
                }
                throw new IllegalStateException("Unknown FMU type code (" + this.variableTypes.get((Object)id) + ") for variable '" + id + "'");
            }
            Object value = null;
            Object object = this.frameMutex;
            synchronized (object) {
                value = this.frame.getValue(id);
            }
            if (value != null) {
                try {
                    return Bindings.getBinding(value.getClass());
                }
                catch (BindingConstructionException e) {
                    throw new NodeManagerException("Value of unknown type (" + String.valueOf(value.getClass()) + ") for variable '" + id + "'", (Throwable)e);
                }
            }
            throw new NoValueException();
        }
        return Bindings.DOUBLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEngineValue(FMINodeBase node, Object value) throws NodeManagerException {
        block17: {
            if (this.shutdown) {
                return;
            }
            try {
                String name = node.getVariableName();
                FMIProtos.ValueOption.Builder valueBuilder = FMIProtos.ValueOption.newBuilder();
                switch (this.variableTypes.get((Object)name)) {
                    case 0: {
                        if (!(value instanceof Number)) {
                            throw new IllegalArgumentException("Illegal value type (" + String.valueOf(value.getClass()) + ") for real variable '" + name + "'");
                        }
                        valueBuilder.setRealValue(((Number)value).doubleValue());
                        break;
                    }
                    case 1: 
                    case 4: {
                        if (!(value instanceof Number)) {
                            throw new IllegalArgumentException("Illegal value type (" + String.valueOf(value.getClass()) + ") for integer variable '" + name + "'");
                        }
                        valueBuilder.setIntValue(((Number)value).intValue());
                        break;
                    }
                    case 2: {
                        if (!(value instanceof Boolean)) {
                            throw new IllegalArgumentException("Illegal value type (" + String.valueOf(value.getClass()) + ") for boolean variable '" + name + "'");
                        }
                        valueBuilder.setBoolValue(((Boolean)value).booleanValue());
                        break;
                    }
                    case 3: {
                        if (!(value instanceof String)) {
                            throw new IllegalArgumentException("Illegal value type (" + String.valueOf(value.getClass()) + ") for string variable '" + name + "'");
                        }
                        valueBuilder.setStringValue((String)value);
                    }
                    default: {
                        throw new IllegalStateException("Unknown FMU type code (" + this.variableTypes.get((Object)name) + ") for variable '" + name + "'");
                    }
                }
                FMIProtos.BasicResponse response = this.blockingStub.setValue(FMIProtos.SetValueRequest.newBuilder().addName(name).addValue(valueBuilder.build()).build());
                if (!response.getSuccess()) {
                    throw new FMILException("Could not set FMU value");
                }
                if (this.getStateL() != StandardExperimentStates.STOPPED) break block17;
                Object object = this.frameMutex;
                synchronized (object) {
                    this.frame.setValue(name, value);
                }
            }
            catch (FMILException e) {
                throw new NodeManagerException((Throwable)e);
            }
        }
    }

    public String getName(FMINodeBase node) {
        return node.name;
    }

    public Map<String, FMINodeBase> getChildren(FMINodeBase node) {
        if (node instanceof FMIChildNode) {
            List childList = ((FMIChildNode)node).getChildren();
            HashMap<String, FMINodeBase> result = new HashMap<String, FMINodeBase>(childList.size());
            for (FMINodeBase child : childList) {
                result.put(child.name, child);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public Map<String, FMINodeBase> getProperties(FMINodeBase node) {
        if (node instanceof FMIVariableNode) {
            List childList = ((FMIVariableNode)node).getProperties();
            HashMap<String, FMINodeBase> result = new HashMap<String, FMINodeBase>(childList.size());
            for (FMINodeBase child : childList) {
                result.put(child.name, child);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public void addListener(DynamicExperimentThreadListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DynamicExperimentThreadListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireStateChanged(ExperimentState newState) {
        this.listeners.forEach(l -> l.stateChanged(newState));
    }

    protected void fireAfterStep() {
        this.listeners.forEach(DynamicExperimentThreadListener::afterStep);
    }

    protected void fireBeforeStep() {
        this.listeners.forEach(DynamicExperimentThreadListener::beforeStep);
    }

    public Object getVariableValueById(String id, Binding binding) {
        if (this.shutdown) {
            return null;
        }
        if (this.variableNames.contains(id)) {
            FMIProtos.ValueResponse response = this.getDeadlineStub().getValue(FMIProtos.GetValueRequest.newBuilder().addName(id).build());
            FMIProtos.ValueOption valueMsg = response.getValue(0);
            try {
                switch (this.variableTypes.get((Object)id)) {
                    case 0: {
                        if (binding instanceof NumberBinding) {
                            return ((NumberBinding)binding).create((Number)valueMsg.getRealValue());
                        }
                        throw new IllegalArgumentException("Non-suitable binding for real variable '" + id + "': " + String.valueOf(binding));
                    }
                    case 1: 
                    case 4: {
                        if (binding instanceof NumberBinding) {
                            return ((NumberBinding)binding).create((Number)valueMsg.getIntValue());
                        }
                        throw new IllegalArgumentException("Non-suitable binding for integer variable '" + id + "': " + String.valueOf(binding));
                    }
                    case 2: {
                        if (binding instanceof BooleanBinding) {
                            return ((BooleanBinding)binding).create(valueMsg.getBoolValue());
                        }
                        throw new IllegalArgumentException("Non-suitable binding for boolean variable '" + id + "': " + String.valueOf(binding));
                    }
                    case 3: {
                        if (binding instanceof StringBinding) {
                            return ((StringBinding)binding).create(valueMsg.getStringValue());
                        }
                        throw new IllegalArgumentException("Non-suitable binding for string variable '" + id + "': " + String.valueOf(binding));
                    }
                }
                throw new IllegalStateException("Unknown FMI variable type code (" + this.variableTypes.get((Object)id) + ") for variable '" + id + "'");
            }
            catch (BindingException e) {
                throw new RuntimeBindingException(e);
            }
        }
        Object value = this.frame.getValue(id);
        if (value == null) {
            return value;
        }
        if (!binding.isInstance(value)) {
            throw new IllegalArgumentException("Non-suitable binding for variable '" + id + "' (" + value.getClass().getName() + "): " + String.valueOf(binding));
        }
        return value;
    }

    public static FMIRPCExperiment createFmiRpcExperiment(File workingDir, File fmuFile, List<String> subscriptions) throws Exception {
        FMIRPCExperiment exp = new FMIRPCExperiment(workingDir, fmuFile, UUID.randomUUID().toString(), subscriptions);
        return exp;
    }

    private void prepareHDF5DataWrite() throws FMILException {
        if (this.hdf == null) {
            return;
        }
        ArrayList<String> notSuccessful = new ArrayList<String>();
        for (String sub : this.subscriptions.getAll()) {
            if (this.store(sub, false)) continue;
            notSuccessful.add(sub);
        }
        for (String sub : notSuccessful) {
            this.store(sub, true);
        }
        this.hdf.start();
    }

    private List<String> getSubscribedNames() {
        return this.verifiedHdf5Subscriptions;
    }

    private double[] getSubscribedResults() {
        double[] results = new double[this.verifiedHdf5Subscriptions.size()];
        int i = 0;
        while (i < this.verifiedHdf5Subscriptions.size()) {
            double d;
            String var_id = this.verifiedHdf5Subscriptions.get(i);
            Object v = this.getVariableValueById(var_id);
            if (DEBUG) {
                System.out.println(this.id + " | " + var_id + " was " + (v == null ? "null" : v.toString()));
            }
            results[i] = v == null ? Double.NEGATIVE_INFINITY : (v instanceof Number ? (d = ((Number)v).doubleValue()) : (v instanceof Boolean ? (d = (Boolean)v != false ? 1.0 : 0.0) : Double.NEGATIVE_INFINITY));
            ++i;
        }
        return results;
    }

    private void endHDF5() {
        if (this.hdf != null) {
            this.hdf.end();
        }
    }

    private void updateHDF5SubscriptionsAndTime() {
        if (this.hdf != null) {
            double time = this.getSimulationTime();
            List<String> subs = this.getSubscribedNames();
            double[] results = this.getSubscribedResults();
            try {
                this.hdf.update(subs, results, time);
            }
            catch (Throwable e) {
                LOGGER.error("fetchSubscriptionsAndTime in FMIRPCExperiment encountered error writing to hdf file for experiment id " + this.id, e);
            }
        }
    }

    public boolean store(String id, boolean force) throws FMILException {
        block8: {
            block7: {
                if (this.initialized) {
                    throw new IllegalStateException("Stored variables cannot be set after initialization.");
                }
                try {
                    if (!force) break block7;
                    this.subscribe(id);
                    if (this.store(id)) {
                        this.verifiedHdf5Subscriptions.add(id);
                        this.hdf.store(id);
                    }
                    return true;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to subscribe/store variable <" + id + ">. Ignoring", (Throwable)e);
                    System.err.println("Failed to subscribe/store variable <" + id + ">. Ignoring due to: " + e.getMessage());
                    return false;
                }
            }
            Object value = this.getVariableValueById(id);
            if (value == null) break block8;
            this.subscribe(id);
            if (this.store(id)) {
                this.verifiedHdf5Subscriptions.add(id);
                this.hdf.store(id);
            }
            return true;
        }
        LOGGER.error("Tried to subscribe to a variable that might be Internal datatype: <" + id + ">. Ignoring.");
        System.err.println("Tried to subscribe to a variable that might be Internal datatype: <" + id + ">. Ignoring.");
        return false;
    }

    public void setSimulationStepNs(long ns) {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }
}

