/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.experiment;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class HDF5Subscriptions {
    private List<String> subscriptions = new ArrayList<String>();
    private static Logger logger = Logger.getLogger("org.simantics.fmi.experiment.HDF5Subscriptions");

    public HDF5Subscriptions(String fmuModelAbsPath) {
        this.updateSubsFromFile(fmuModelAbsPath);
    }

    public HDF5Subscriptions(List<String> subs) {
        this.subscriptions = subs;
    }

    private void updateSubsFromFile(String fmuModelAbsPath) {
        try {
            int lastDot = fmuModelAbsPath.lastIndexOf(".");
            String subscriptionFilePath = fmuModelAbsPath.substring(0, lastDot + 1) + "hdf5subs";
            if (!Files.exists(Paths.get(subscriptionFilePath, new String[0]), new LinkOption[0])) {
                logger.info("No file with subscriptions found at: " + subscriptionFilePath);
                Object modelname = fmuModelAbsPath.substring(0, lastDot + 1);
                if (modelname == null || ((String)modelname).equals("")) {
                    modelname = fmuModelAbsPath + ".";
                }
                subscriptionFilePath = (String)modelname + "hdf5subs";
            }
            if (!Files.exists(Paths.get(subscriptionFilePath, new String[0]), new LinkOption[0])) {
                logger.severe("No file with subscriptions found at: " + subscriptionFilePath);
            } else {
                logger.info("Potential subscriptions found at: " + subscriptionFilePath);
                try {
                    this.addAllFromFile(subscriptionFilePath);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Failed to add HDF5 subs from file", e);
                }
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            logger.log(Level.SEVERE, "Failed to add HDF5 subs from file", iobe);
        }
    }

    private void addAllFromFile(String subscriptionFilePath) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Stream<String> stream = Files.lines(Paths.get(subscriptionFilePath, new String[0]));){
            stream.map(String::trim).filter(s -> !s.isEmpty()).forEach(line -> {
                logger.info("Adding HDF5 subscription <" + line + ">");
                this.subscriptions.add((String)line);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<String> getAll() {
        return this.subscriptions;
    }
}

