/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.set.hash;

import com.koloboke.collect.hash.HashContainer;
import com.koloboke.collect.set.LongSet;
import com.koloboke.compile.KolobokeSet;


/**
 * An interface for {@code LongSet}s, based on hash tables.
 *
 * <p>This interface doesn't carry own specific behaviour, just combines it's superinterfaces.
 *
 * <p>Looking for a way to instantiate a {@code HashLongSet}? See static factory methods
 * in {@link HashLongSets} class.
 *
 * @see HashLongSets
 * @see HashLongSetFactory
 * @see KolobokeSet @KolobokeSet
 */
public interface HashLongSet extends LongSet, HashContainer {
}
