/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashFloatCharMap}s.
 *
 * @see HashFloatCharMap
 * @see HashFloatCharMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashFloatCharMapFactory
        extends FloatCharMapFactory<HashFloatCharMapFactory>
        , HashContainerFactory<HashFloatCharMapFactory>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashFloatCharMap newMutableMap();

    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3,
            @Nonnull Map<Float, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3,
            @Nonnull Map<Float, Character> map4,
            @Nonnull Map<Float, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(
            @Nonnull float[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(
            @Nonnull Float[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(
            @Nonnull Map<Float, Character> map);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3,
            @Nonnull Map<Float, Character> map4);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3,
            @Nonnull Map<Float, Character> map4,
            @Nonnull Map<Float, Character> map5);



    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(
            @Nonnull float[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(
            @Nonnull Float[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashFloatCharMap newMutableMapOf(float k1, char v1);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMapOf(float k1, char v1,
            float k2, char v2);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4);

    @Override
    @Nonnull
     HashFloatCharMap newMutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4, float k5, char v5);
    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap();

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3,
            @Nonnull Map<Float, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3,
            @Nonnull Map<Float, Character> map4,
            @Nonnull Map<Float, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.FloatCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(
            @Nonnull float[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(
            @Nonnull Map<Float, Character> map);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3,
            @Nonnull Map<Float, Character> map4);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3,
            @Nonnull Map<Float, Character> map4,
            @Nonnull Map<Float, Character> map5);



    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.FloatCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(
            @Nonnull float[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMapOf(float k1, char v1);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMapOf(float k1, char v1,
            float k2, char v2);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4);

    @Override
    @Nonnull
     HashFloatCharMap newUpdatableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4, float k5, char v5);

    


    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3,
            @Nonnull Map<Float, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3,
            @Nonnull Map<Float, Character> map4,
            @Nonnull Map<Float, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(
            @Nonnull float[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(
            @Nonnull Float[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(
            @Nonnull Map<Float, Character> map);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3,
            @Nonnull Map<Float, Character> map4);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(@Nonnull Map<Float, Character> map1,
            @Nonnull Map<Float, Character> map2,
            @Nonnull Map<Float, Character> map3,
            @Nonnull Map<Float, Character> map4,
            @Nonnull Map<Float, Character> map5);



    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(
            @Nonnull float[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(
            @Nonnull Float[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashFloatCharMap newImmutableMapOf(float k1, char v1);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMapOf(float k1, char v1,
            float k2, char v2);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4);

    @Override
    @Nonnull
     HashFloatCharMap newImmutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4, float k5, char v5);
}
