/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.ServerInfo;
import com.impossibl.postgres.system.procs.ProcProvider;
import com.impossibl.postgres.system.procs.Unknowns;
import com.impossibl.postgres.types.Modifiers;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.guava.Strings;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public class Procs {
    private static final int MIN_PROC_PROVIDER_SERVICES = 47;
    public static final Type.Codec.Decoder<CharSequence> DEFAULT_TEXT_DECODER = new Unknowns.TxtDecoder();
    public static final Type.Codec.Decoder<ByteBuf> DEFAULT_BINARY_DECODER = new Unknowns.BinDecoder();
    public static final Type.Codec.Encoder<StringBuilder> DEFAULT_TEXT_ENCODER = new Unknowns.TxtEncoder();
    public static final Type.Codec.Encoder<ByteBuf> DEFAULT_BINARY_ENCODER = new Unknowns.BinEncoder();
    public static final Modifiers.Parser DEFAULT_MOD_PARSER = new Unknowns.ModParser();
    private ServerInfo serverInfo;
    private List<ProcProvider> providers;

    public Procs(ServerInfo serverInfo, ClassLoader classLoader) {
        this.serverInfo = serverInfo;
        try {
            this.providers = Procs.load(ServiceLoader.load(ProcProvider.class, classLoader));
        }
        catch (Exception e) {
            this.providers = Procs.load(ServiceLoader.load(ProcProvider.class, Procs.class.getClassLoader()));
        }
    }

    private static List<ProcProvider> load(ServiceLoader<ProcProvider> services) {
        ArrayList<ProcProvider> all = new ArrayList<ProcProvider>();
        for (ProcProvider procProvider : services) {
            all.add(procProvider);
        }
        if (all.size() < 47) {
            throw new IllegalStateException("Loaded ProcProvider services is below the required threshold, a class loading issue may exist. Found:\n" + all);
        }
        return all;
    }

    public static boolean isDefaultDecoder(Type.Codec.Decoder<?> decoder) {
        return decoder == DEFAULT_TEXT_DECODER || decoder == DEFAULT_BINARY_DECODER;
    }

    public static boolean isDefaultEncoder(Type.Codec.Encoder<?> encoder) {
        return encoder == DEFAULT_TEXT_ENCODER || encoder == DEFAULT_BINARY_ENCODER;
    }

    public Type.TextCodec loadNamedTextCodec(String baseName) {
        return new Type.TextCodec(this.loadDecoderProc(baseName + "out", DEFAULT_TEXT_DECODER, CharSequence.class), this.loadEncoderProc(baseName + "in", DEFAULT_TEXT_ENCODER, StringBuilder.class));
    }

    public Type.BinaryCodec loadNamedBinaryCodec(String baseName) {
        return new Type.BinaryCodec(this.loadDecoderProc(baseName + "send", DEFAULT_BINARY_DECODER, ByteBuf.class), this.loadEncoderProc(baseName + "recv", DEFAULT_BINARY_ENCODER, ByteBuf.class));
    }

    public <Buffer> Type.Codec.Encoder<Buffer> loadEncoderProc(String name, Type.Codec.Encoder<Buffer> defaultEncoder, Class<? extends Buffer> bufferType) {
        if (!name.isEmpty() && !name.equals("-")) {
            for (ProcProvider pp : this.providers) {
                Type.Codec.Encoder<? extends Buffer> h = pp.findEncoder(name, this.serverInfo, bufferType);
                if (h == null) continue;
                return h;
            }
        }
        return defaultEncoder;
    }

    public <Buffer> Type.Codec.Decoder<Buffer> loadDecoderProc(String name, Type.Codec.Decoder<Buffer> defaultDecoder, Class<? extends Buffer> bufferType) {
        if (!name.isEmpty() && !name.equals("-")) {
            for (ProcProvider pp : this.providers) {
                Type.Codec.Decoder<? extends Buffer> h = pp.findDecoder(name, this.serverInfo, bufferType);
                if (h == null) continue;
                return h;
            }
        }
        return defaultDecoder;
    }

    public Modifiers.Parser loadModifierParserProc(String name) {
        if (!Strings.isNullOrEmpty(name) && !name.equals("-")) {
            for (ProcProvider pp : this.providers) {
                Modifiers.Parser p = pp.findModifierParser(name, this.serverInfo);
                if (p == null) continue;
                return p;
            }
        }
        return DEFAULT_MOD_PARSER;
    }
}

