/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.FieldBuffersRowData;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.RowData;
import com.impossibl.postgres.protocol.UpdatableRowData;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.ByteBufs;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class BufferRowData
extends DefaultByteBufHolder
implements RowData,
ReferenceCounted {
    private int[] fieldOffsets;

    BufferRowData(ByteBuf buffer) {
        super(buffer);
        this.fieldOffsets = null;
    }

    private BufferRowData(ByteBuf buffer, int[] fieldOffsets) {
        super(buffer);
        this.fieldOffsets = fieldOffsets;
    }

    public static BufferRowData encode(Context context, ResultField[] fields, Object[] values) throws IOException {
        ByteBuf fieldsBuffer = context.getAllocator().buffer();
        int[] fieldOffsets = new int[fields.length];
        for (int fieldIdx = 0; fieldIdx < fields.length; ++fieldIdx) {
            ResultField field = fields[fieldIdx];
            Type fieldType = context.getRegistry().resolve(field.getTypeRef());
            Object value = values[fieldIdx];
            fieldOffsets[fieldIdx] = ByteBufs.lengthEncode(fieldsBuffer, value, () -> {
                switch (field.getFormat()) {
                    case Text: {
                        StringBuilder fieldBuffer = new StringBuilder();
                        fieldType.getTextCodec().getEncoder().encode(context, fieldType, value, null, fieldBuffer);
                        ByteBufUtil.writeUtf8((ByteBuf)fieldsBuffer, (CharSequence)fieldBuffer);
                        break;
                    }
                    case Binary: {
                        fieldType.getBinaryCodec().getEncoder().encode(context, fieldType, value, null, fieldsBuffer);
                    }
                }
            });
        }
        return new BufferRowData(fieldsBuffer, fieldOffsets);
    }

    private static int[] decodeFieldOffsets(ByteBuf buffer) {
        int columnsCount = buffer.readUnsignedShort();
        int[] offsets = new int[columnsCount];
        for (int c = 0; c < columnsCount; ++c) {
            offsets[c] = buffer.readerIndex();
            buffer.skipBytes(Math.max(buffer.readInt(), 0));
        }
        return offsets;
    }

    private void decodeFieldOffsetsIfNeeded() {
        if (this.fieldOffsets != null) {
            return;
        }
        this.fieldOffsets = BufferRowData.decodeFieldOffsets(this.content());
    }

    @Override
    public int getFieldCount() {
        this.decodeFieldOffsetsIfNeeded();
        return this.fieldOffsets.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getField(int fieldIdx, ResultField field, Context context, Class<?> targetClass, Object targetContext) throws IOException {
        this.decodeFieldOffsetsIfNeeded();
        ByteBuf buffer = this.content();
        Type type = context.getRegistry().resolve(field.getTypeRef());
        int offset = this.fieldOffsets[fieldIdx];
        int length = buffer.getInt(offset);
        if (length == -1) {
            return null;
        }
        switch (field.getFormat()) {
            case Text: {
                Type.Codec.Decoder<String> decoder = type.getTextCodec().getDecoder();
                ByteBuf fieldBuffer = buffer.retainedSlice(offset + 4, length);
                try {
                    String fieldString = fieldBuffer.toString(StandardCharsets.UTF_8);
                    Object object = decoder.decode(context, type, field.getTypeLength(), field.getTypeModifier(), fieldString, targetClass, targetContext);
                    return object;
                }
                finally {
                    fieldBuffer.release();
                }
            }
            case Binary: {
                Type.Codec.Decoder<ByteBuf> decoder = type.getBinaryCodec().getDecoder();
                ByteBuf fieldBuffer = buffer.retainedSlice(offset + 4, length);
                try {
                    Object object = decoder.decode(context, type, field.getTypeLength(), field.getTypeModifier(), fieldBuffer, targetClass, targetContext);
                    return object;
                }
                finally {
                    fieldBuffer.release();
                }
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public UpdatableRowData duplicateForUpdate() {
        this.decodeFieldOffsetsIfNeeded();
        ByteBuf buffer = this.content();
        ByteBuf[] fieldBuffers = new ByteBuf[this.fieldOffsets.length];
        for (int fieldIndex = 0; fieldIndex < this.fieldOffsets.length; ++fieldIndex) {
            int fieldOffset = this.fieldOffsets[fieldIndex];
            int fieldLength = buffer.getInt(fieldOffset);
            if (fieldLength == -1) continue;
            ByteBuf fieldBuffer = buffer.alloc().buffer(fieldLength);
            buffer.getBytes(fieldOffset + 4, fieldBuffer, fieldLength);
            fieldBuffers[fieldIndex] = fieldBuffer;
        }
        return new FieldBuffersRowData(fieldBuffers, buffer.alloc());
    }
}

