/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.sasl.scram.client.ScramSession;
import com.impossibl.postgres.protocol.sasl.scram.client.ScramSessionFactory;
import com.impossibl.postgres.protocol.sasl.scram.exception.ScramException;
import com.impossibl.postgres.protocol.sasl.scram.stringprep.StringPreparations;
import com.impossibl.postgres.protocol.v30.StartupRequest;
import com.impossibl.postgres.system.Configuration;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.utils.ByteBufs;
import com.impossibl.postgres.utils.MD5Authentication;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.List;

abstract class AuthenticationHandler
implements StartupRequest.CompletionHandler {
    private static final String SCRAM_CHANNEL_BIND_METHOD = "tls-server-end-point";
    private final Configuration config;
    private final Channel channel;
    private ScramSession scramSession;

    AuthenticationHandler(Configuration config, Channel channel) {
        this.config = config;
        this.channel = channel;
    }

    @Override
    public String authenticateClear() {
        return this.config.getSetting(SystemSettings.CREDENTIALS_PASSWORD);
    }

    @Override
    public String authenticateMD5(byte[] salt) {
        String username = this.config.getSetting(SystemSettings.CREDENTIALS_USERNAME);
        String password = this.config.getSetting(SystemSettings.CREDENTIALS_PASSWORD);
        return MD5Authentication.encode(password, username, salt);
    }

    @Override
    public void authenticateKerberos() {
        throw new IllegalStateException("Unsupported Authentication Method");
    }

    @Override
    public byte authenticateSCM() {
        throw new IllegalStateException("Unsupported Authentication Method");
    }

    @Override
    public ByteBuf authenticateGSS(ByteBuf data) {
        throw new IllegalStateException("Unsupported Authentication Method");
    }

    @Override
    public ByteBuf authenticateGSSContinue(ByteBuf data) {
        throw new IllegalStateException("Unsupported Authentication Method");
    }

    @Override
    public ByteBuf authenticateSSPI(ByteBuf data) {
        throw new IllegalStateException("Unsupported Authentication Method");
    }

    @Override
    public ByteBuf authenticateSASL(List<String> mechanisms) throws IOException {
        ScramSessionFactory scramSessionFactory;
        SslHandler sslHandler = (SslHandler)this.channel.pipeline().get("ssl");
        boolean clientSupportsChannelBinding = sslHandler != null && sslHandler.engine().getSession().getPeerCertificates() != null && sslHandler.engine().getSession().getPeerCertificates().length > 0;
        try {
            scramSessionFactory = ScramSessionFactory.builder().serverAdvertisedMechanisms(mechanisms).channelBindMethod(clientSupportsChannelBinding ? SCRAM_CHANNEL_BIND_METHOD : null).stringPreparation(StringPreparations.SASL_PREPARATION).preferChannelBindingMechanism(this.config.getSetting(SystemSettings.SSL_MODE).isRequired()).build();
        }
        catch (IllegalArgumentException e) {
            throw new IOException("No supported SASL mechanisms available");
        }
        this.scramSession = scramSessionFactory.start("");
        ByteBuf response = this.channel.alloc().buffer();
        ByteBufs.writeCString(response, this.scramSession.getScramMechanismName(), StandardCharsets.UTF_8);
        byte[] clientFirstMessageData = this.scramSession.clientFirstMessage(null);
        response.writeInt(clientFirstMessageData.length);
        response.writeBytes(clientFirstMessageData);
        return response;
    }

    @Override
    public ByteBuf authenticateSASLContinue(String serverFirstMessage) throws IOException {
        byte[] channelBindData;
        if (this.scramSession.requiresChannelBindData()) {
            if (!SCRAM_CHANNEL_BIND_METHOD.equals(this.scramSession.getChannelBindMethod())) {
                throw new ScramException("Unsupported channel-bind method");
            }
            try {
                SslHandler sslHandler = (SslHandler)this.channel.pipeline().get("ssl");
                X509Certificate[] peerCerts = (X509Certificate[])sslHandler.engine().getSession().getPeerCertificates();
                X509Certificate peerCert = peerCerts[0];
                channelBindData = MessageDigest.getInstance("SHA-256").digest(peerCert.getEncoded());
            }
            catch (Exception e) {
                throw new ScramException("Failed to generate channel-bind data", e);
            }
        } else {
            channelBindData = null;
        }
        String password = this.config.getSetting(SystemSettings.CREDENTIALS_PASSWORD);
        byte[] clientFinalMessage = this.scramSession.receiveServerFirstMessage(serverFirstMessage, channelBindData, password);
        ByteBuf response = this.channel.alloc().buffer(clientFinalMessage.length);
        response.writeBytes(clientFinalMessage);
        return response;
    }

    @Override
    public void authenticateSASLFinal(String serverFinalMessage) throws IOException {
        this.scramSession.receiveServerFinalMessage(serverFinalMessage);
    }
}

