/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.sasl.scram;

import com.impossibl.postgres.protocol.sasl.scram.exception.ScramParseException;
import com.impossibl.postgres.protocol.sasl.scram.util.CharAttribute;
import java.util.HashMap;
import java.util.Map;

public enum ScramAttributes implements CharAttribute
{
    USERNAME('n'),
    AUTHZID('a'),
    NONCE('r'),
    CHANNEL_BINDING('c'),
    SALT('s'),
    ITERATION('i'),
    CLIENT_PROOF('p'),
    SERVER_SIGNATURE('v'),
    ERROR('e');

    private final char attributeChar;
    private static final Map<Character, ScramAttributes> REVERSE_MAPPING;

    private ScramAttributes(char attributeChar) {
        this.attributeChar = attributeChar;
    }

    @Override
    public char getChar() {
        return this.attributeChar;
    }

    public static ScramAttributes byChar(char c) throws ScramParseException {
        if (!REVERSE_MAPPING.containsKey(Character.valueOf(c))) {
            throw new ScramParseException("Attribute with char '" + c + "' does not exist");
        }
        return REVERSE_MAPPING.get(Character.valueOf(c));
    }

    static {
        REVERSE_MAPPING = new HashMap<Character, ScramAttributes>();
        for (ScramAttributes scramAttribute : ScramAttributes.values()) {
            REVERSE_MAPPING.put(Character.valueOf(scramAttribute.getChar()), scramAttribute);
        }
    }
}

