/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.file.RuntimeIOException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.util.Base64;

public class StringUtil {
    public static String variantToString(Variant v) {
        try {
            return (String)Bindings.STR_VARIANT.create(v.getBinding(), v.getValue());
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public static Variant stringToVariant(String str) throws BindingException {
        return (Variant)Bindings.VARIANT.create(Bindings.STR_VARIANT, str);
    }

    public static String variantToUserReadableString(Variant v) {
        try {
            Binding binding = v.getBinding();
            Object value = v.getValue();
            if (binding == Bindings.STRING) {
                return (String)value;
            }
            if (binding.type().equals(Datatypes.STRING)) {
                StringBinding sb = (StringBinding)binding;
                return sb.getValue(value);
            }
            if (binding instanceof NumberBinding) {
                return binding.toString(value);
            }
            Serializer s = Bindings.getSerializer(Bindings.VARIANT);
            byte[] bytes = s.serialize(v);
            return Base64.encodeBytes(bytes, 16);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
        catch (SerializerConstructionException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static String escapeToFileName(String name) {
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String unescapeFileName(String filename) {
        try {
            return URLDecoder.decode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

