/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.type;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.annotations.Union;
import org.simantics.databoard.parser.unparsing.DataTypePrinter;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;
import org.simantics.databoard.util.IdentityPair;

@Union(value={BooleanType.class, ByteType.class, IntegerType.class, LongType.class, FloatType.class, DoubleType.class, StringType.class, RecordType.class, ArrayType.class, MapType.class, OptionalType.class, UnionType.class, VariantType.class})
public abstract class Datatype
implements Cloneable {
    public TreeMap<String, String> metadata = new TreeMap();

    protected void collectSubtypes(Set<Datatype> subtypes, Set<Datatype> recursiveSubtypes) {
    }

    public abstract int getComponentCount();

    public abstract Datatype getComponentType(int var1);

    public abstract Datatype getComponentType(ChildReference var1);

    public String toString() {
        return DataTypePrinter.toString(this, true);
    }

    public String toSingleLineString() {
        return DataTypePrinter.toString(this, false);
    }

    public abstract void accept(Visitor1 var1, Object var2);

    public abstract <T> T accept(Visitor<T> var1);

    protected boolean hasEqualMetadata(Object obj) {
        int s2;
        Datatype other = (Datatype)obj;
        int s1 = this.metadata.size();
        if (s1 != (s2 = other.metadata.size())) {
            return false;
        }
        if (s1 > 0) {
            Iterator<Map.Entry<String, String>> i1 = this.metadata.entrySet().iterator();
            Iterator<Map.Entry<String, String>> i2 = other.metadata.entrySet().iterator();
            while (i1.hasNext() && i2.hasNext()) {
                if (i1.next().equals(i2.next())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return this.deepEquals(obj, null);
    }

    public int hashCode() {
        return this.metadataHashCode();
    }

    public int metadataHashCode() {
        int hash = 13;
        for (Map.Entry<String, String> e : this.metadata.entrySet()) {
            hash *= 13;
            hash += e.hashCode();
        }
        return hash;
    }

    protected abstract boolean deepEquals(Object var1, Set<IdentityPair<Datatype, Datatype>> var2);

    public static interface Visitor<T> {
        public T visit(ArrayType var1);

        public T visit(BooleanType var1);

        public T visit(DoubleType var1);

        public T visit(FloatType var1);

        public T visit(IntegerType var1);

        public T visit(ByteType var1);

        public T visit(LongType var1);

        public T visit(OptionalType var1);

        public T visit(RecordType var1);

        public T visit(StringType var1);

        public T visit(UnionType var1);

        public T visit(VariantType var1);

        public T visit(MapType var1);
    }

    public static interface Visitor1 {
        public void visit(ArrayType var1, Object var2);

        public void visit(BooleanType var1, Object var2);

        public void visit(DoubleType var1, Object var2);

        public void visit(FloatType var1, Object var2);

        public void visit(IntegerType var1, Object var2);

        public void visit(ByteType var1, Object var2);

        public void visit(LongType var1, Object var2);

        public void visit(OptionalType var1, Object var2);

        public void visit(RecordType var1, Object var2);

        public void visit(StringType var1, Object var2);

        public void visit(UnionType var1, Object var2);

        public void visit(VariantType var1, Object var2);

        public void visit(MapType var1, Object var2);
    }
}

