/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import junit.framework.TestCase;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Length;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.annotations.Pattern;
import org.simantics.databoard.annotations.Range;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;

public class TestValidator
extends TestCase {
    public static Binding b = Bindings.getBindingUnchecked(Luokka.class);
    public Luokka l;

    @Override
    public void setUp() throws Exception {
        this.l = new Luokka();
    }

    public void testNumberType() throws Exception {
        this.l.percent = 100;
        b.assertInstaceIsValid(this.l);
        this.l.percent = 0;
        b.assertInstaceIsValid(this.l);
        try {
            this.l.percent = -1;
            b.assertInstaceIsValid(-1);
            TestValidator.fail();
        }
        catch (BindingException bindingException) {
            // empty catch block
        }
        try {
            this.l.percent = 101;
            b.assertInstaceIsValid(101);
            TestValidator.fail();
        }
        catch (BindingException bindingException) {
            // empty catch block
        }
        try {
            b.assertInstaceIsValid(new Integer(5));
            TestValidator.fail();
        }
        catch (BindingException bindingException) {
            // empty catch block
        }
    }

    public void testOptionalType() throws BindingException {
        this.l.optionalValue = 5;
        b.assertInstaceIsValid(this.l);
        try {
            this.l.percent = null;
            b.assertInstaceIsValid(this.l);
            TestValidator.fail();
        }
        catch (BindingException bindingException) {
            // empty catch block
        }
    }

    public void testBooleanType() throws BindingException {
        b.assertInstaceIsValid(this.l);
        try {
            b.assertInstaceIsValid(new Integer(5));
            TestValidator.fail();
        }
        catch (BindingException bindingException) {
            // empty catch block
        }
    }

    public void testStringType() throws BindingException {
        b.assertInstaceIsValid(this.l);
        try {
            this.l.hexNumber = "Hello World";
            b.assertInstaceIsValid(this.l);
            TestValidator.fail();
        }
        catch (BindingException bindingException) {
            // empty catch block
        }
        try {
            this.l.hexNumber = "0x100";
            b.assertInstaceIsValid(this.l);
            TestValidator.fail();
        }
        catch (BindingException bindingException) {
            // empty catch block
        }
    }

    public void testRecordType() throws BindingException {
        b.assertInstaceIsValid(this.l);
    }

    public void testUnionType() throws BindingException, BindingConstructionException {
        Object eb = Bindings.getBinding(Test.class);
        ((Binding)eb).assertInstaceIsValid((Object)Test.Key1);
        ((Binding)eb).assertInstaceIsValid((Object)Test.Key2);
        try {
            b.assertInstaceIsValid(new Integer(5));
            TestValidator.fail();
        }
        catch (BindingException bindingException) {
            // empty catch block
        }
    }

    public void testArrayType() throws BindingException {
        b.assertInstaceIsValid(this.l);
        try {
            this.l.lottoNumbers = new int[]{1, 2, 3, 4, 5, 6, 7, 10, 10, 10, 10};
            b.assertInstaceIsValid(this.l);
            TestValidator.fail();
        }
        catch (BindingException bindingException) {
            // empty catch block
        }
        try {
            this.l.lottoNumbers = new int[]{1, 2, 3};
            b.assertInstaceIsValid(this.l);
            TestValidator.fail();
        }
        catch (BindingException bindingException) {
            // empty catch block
        }
        try {
            this.l.lottoNumbers = new int[]{100, -2, 3, 4, 5, 6, 7};
            b.assertInstaceIsValid(this.l);
            TestValidator.fail();
        }
        catch (BindingException bindingException) {
            // empty catch block
        }
    }

    public static class Luokka {
        @Range(value="[0..100]")
        public Integer percent = 0;
        @Optional
        public Integer optionalValue;
        public Boolean booleanValue = true;
        @Length(value={"7"})
        @Range(value="[1..39]")
        public int[] lottoNumbers = new int[]{1, 2, 3, 4, 5, 6, 7};
        @Length(value={"10"})
        @Pattern(value="0x\\d{8}")
        public String hexNumber = "0x11223344";
    }

    public static enum Test {
        Key1,
        Key2;

    }
}

