/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.util.RandomValue;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.tests.TestData;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.StringType;

public class TestBinding
extends TestData {
    public static boolean OMIT_PARSER_TEST = true;

    @Test
    public void test_boolean() throws Exception {
        TestBinding.assert_same(boolean_binding_ref, boolean_value_ref_0, boolean_binding_gen, boolean_value_gen_0);
        TestBinding.assert_same(boolean_binding_ref, boolean_value_ref_1, boolean_binding_gen, boolean_value_gen_1);
        TestBinding.assert_same(boolean_binding_ref, boolean_value_ref_0, boolean_binding_ref, boolean_value_ref_0);
        TestBinding.assert_same(boolean_binding_gen, boolean_value_gen_0, boolean_binding_gen, boolean_value_gen_0);
        TestBinding.assert_not_same(boolean_binding_ref, boolean_value_ref_0, boolean_binding_gen, boolean_value_gen_1);
        TestBinding.assert_not_same(boolean_binding_ref, boolean_value_ref_1, boolean_binding_gen, boolean_value_gen_0);
        TestBinding.assert_not_same(boolean_binding_ref, boolean_value_ref_0, boolean_binding_ref, boolean_value_ref_1);
        TestBinding.assert_not_same(boolean_binding_gen, boolean_value_gen_0, boolean_binding_gen, boolean_value_gen_1);
        TestBinding.assert_valid(boolean_binding_ref, boolean_value_ref_0);
        TestBinding.assert_valid(boolean_binding_ref, boolean_value_ref_1);
        TestBinding.assert_valid(boolean_binding_gen, boolean_value_gen_0);
        TestBinding.assert_valid(boolean_binding_gen, boolean_value_gen_1);
    }

    @Test
    public void test_byte() throws Exception {
        TestBinding.assert_same(byte_binding_ref, byte_value_ref_0, byte_binding_gen, byte_value_gen_0);
        TestBinding.assert_same(byte_binding_ref, byte_value_ref_1, byte_binding_gen, byte_value_gen_1);
        TestBinding.assert_same(byte_binding_ref, byte_value_ref_0, byte_binding_ref, byte_value_ref_0);
        TestBinding.assert_same(byte_binding_gen, byte_value_gen_0, byte_binding_gen, byte_value_gen_0);
        TestBinding.assert_not_same(byte_binding_ref, byte_value_ref_0, byte_binding_gen, byte_value_gen_1);
        TestBinding.assert_not_same(byte_binding_ref, byte_value_ref_1, byte_binding_gen, byte_value_gen_0);
        TestBinding.assert_not_same(byte_binding_ref, byte_value_ref_0, byte_binding_ref, byte_value_ref_1);
        TestBinding.assert_not_same(byte_binding_gen, byte_value_gen_0, byte_binding_gen, byte_value_gen_1);
        TestBinding.assert_valid(byte_binding_ref, byte_value_ref_0);
        TestBinding.assert_valid(byte_binding_ref, byte_value_ref_1);
        TestBinding.assert_valid(byte_binding_gen, byte_value_gen_0);
        TestBinding.assert_valid(byte_binding_gen, byte_value_gen_1);
    }

    @Test
    public void test_integer() throws Exception {
        TestBinding.assert_same(integer_binding_ref, integer_value_ref_0, integer_binding_gen, integer_value_gen_0);
        TestBinding.assert_same(integer_binding_ref, integer_value_ref_1, integer_binding_gen, integer_value_gen_1);
        TestBinding.assert_same(integer_binding_ref, integer_value_ref_0, integer_binding_ref, integer_value_ref_0);
        TestBinding.assert_same(integer_binding_gen, integer_value_gen_0, integer_binding_gen, integer_value_gen_0);
        TestBinding.assert_not_same(integer_binding_ref, integer_value_ref_0, integer_binding_gen, integer_value_gen_1);
        TestBinding.assert_not_same(integer_binding_ref, integer_value_ref_1, integer_binding_gen, integer_value_gen_0);
        TestBinding.assert_not_same(integer_binding_ref, integer_value_ref_0, integer_binding_ref, integer_value_ref_1);
        TestBinding.assert_not_same(integer_binding_gen, integer_value_gen_0, integer_binding_gen, integer_value_gen_1);
        TestBinding.assert_valid(integer_binding_ref, integer_value_ref_0);
        TestBinding.assert_valid(integer_binding_ref, integer_value_ref_1);
        TestBinding.assert_valid(integer_binding_gen, integer_value_gen_0);
        TestBinding.assert_valid(integer_binding_gen, integer_value_gen_1);
    }

    @Test
    public void test_long() throws Exception {
        TestBinding.assert_same(long_binding_ref, long_value_ref_0, long_binding_gen, long_value_gen_0);
        TestBinding.assert_same(long_binding_ref, long_value_ref_1, long_binding_gen, long_value_gen_1);
        TestBinding.assert_same(long_binding_ref, long_value_ref_0, long_binding_ref, long_value_ref_0);
        TestBinding.assert_same(long_binding_gen, long_value_gen_0, long_binding_gen, long_value_gen_0);
        TestBinding.assert_not_same(long_binding_ref, long_value_ref_0, long_binding_gen, long_value_gen_1);
        TestBinding.assert_not_same(long_binding_ref, long_value_ref_1, long_binding_gen, long_value_gen_0);
        TestBinding.assert_not_same(long_binding_ref, long_value_ref_0, long_binding_ref, long_value_ref_1);
        TestBinding.assert_not_same(long_binding_gen, long_value_gen_0, long_binding_gen, long_value_gen_1);
        TestBinding.assert_valid(long_binding_ref, long_value_ref_0);
        TestBinding.assert_valid(long_binding_ref, long_value_ref_1);
        TestBinding.assert_valid(long_binding_gen, long_value_gen_0);
        TestBinding.assert_valid(long_binding_gen, long_value_gen_1);
    }

    @Test
    public void test_float() throws Exception {
        TestBinding.assert_same(float_binding_ref, float_value_ref_0, float_binding_gen, float_value_gen_0);
        TestBinding.assert_same(float_binding_ref, float_value_ref_1, float_binding_gen, float_value_gen_1);
        TestBinding.assert_same(float_binding_ref, float_value_ref_0, float_binding_ref, float_value_ref_0);
        TestBinding.assert_same(float_binding_gen, float_value_gen_0, float_binding_gen, float_value_gen_0);
        TestBinding.assert_not_same(float_binding_ref, float_value_ref_0, float_binding_gen, float_value_gen_1);
        TestBinding.assert_not_same(float_binding_ref, float_value_ref_1, float_binding_gen, float_value_gen_0);
        TestBinding.assert_not_same(float_binding_ref, float_value_ref_0, float_binding_ref, float_value_ref_1);
        TestBinding.assert_not_same(float_binding_gen, float_value_gen_0, float_binding_gen, float_value_gen_1);
        TestBinding.assert_valid(float_binding_ref, float_value_ref_0);
        TestBinding.assert_valid(float_binding_ref, float_value_ref_1);
        TestBinding.assert_valid(float_binding_gen, float_value_gen_0);
        TestBinding.assert_valid(float_binding_gen, float_value_gen_1);
    }

    @Test
    public void test_double() throws Exception {
        TestBinding.assert_same(double_binding_ref, double_value_ref_0, double_binding_gen, double_value_gen_0);
        TestBinding.assert_same(double_binding_ref, double_value_ref_1, double_binding_gen, double_value_gen_1);
        TestBinding.assert_same(double_binding_ref, double_value_ref_0, double_binding_ref, double_value_ref_0);
        TestBinding.assert_same(double_binding_gen, double_value_gen_0, double_binding_gen, double_value_gen_0);
        TestBinding.assert_not_same(double_binding_ref, double_value_ref_0, double_binding_gen, double_value_gen_1);
        TestBinding.assert_not_same(double_binding_ref, double_value_ref_1, double_binding_gen, double_value_gen_0);
        TestBinding.assert_not_same(double_binding_ref, double_value_ref_0, double_binding_ref, double_value_ref_1);
        TestBinding.assert_not_same(double_binding_gen, double_value_gen_0, double_binding_gen, double_value_gen_1);
        TestBinding.assert_valid(double_binding_ref, double_value_ref_0);
        TestBinding.assert_valid(double_binding_ref, double_value_ref_1);
        TestBinding.assert_valid(double_binding_gen, double_value_gen_0);
        TestBinding.assert_valid(double_binding_gen, double_value_gen_1);
    }

    @Test
    public void test_string() throws Exception {
        TestBinding.assert_same(string_binding_ref, string_value_ref_0, string_binding_gen, string_value_gen_0);
        TestBinding.assert_same(string_binding_ref, string_value_ref_1, string_binding_gen, string_value_gen_1);
        TestBinding.assert_same(string_binding_ref, string_value_ref_0, string_binding_ref, string_value_ref_0);
        TestBinding.assert_same(string_binding_gen, string_value_gen_0, string_binding_gen, string_value_gen_0);
        TestBinding.assert_not_same(string_binding_ref, string_value_ref_0, string_binding_gen, string_value_gen_1);
        TestBinding.assert_not_same(string_binding_ref, string_value_ref_1, string_binding_gen, string_value_gen_0);
        TestBinding.assert_not_same(string_binding_ref, string_value_ref_0, string_binding_ref, string_value_ref_1);
        TestBinding.assert_not_same(string_binding_gen, string_value_gen_0, string_binding_gen, string_value_gen_1);
        TestBinding.assert_valid(string_binding_ref, string_value_ref_0);
        TestBinding.assert_valid(string_binding_ref, string_value_ref_1);
        TestBinding.assert_valid(string_binding_gen, string_value_gen_0);
        TestBinding.assert_valid(string_binding_gen, string_value_gen_1);
    }

    @Test
    public void test_array() throws Exception {
        TestBinding.assert_same(array_binding_ref, array_value_ref_0, array_binding_gen, array_value_gen_0);
        TestBinding.assert_same(array_binding_ref, array_value_ref_1, array_binding_gen, array_value_gen_1);
        TestBinding.assert_same(array_binding_ref, array_value_ref_0, array_binding_ref, array_value_ref_0);
        TestBinding.assert_same(array_binding_gen, array_value_gen_0, array_binding_gen, array_value_gen_0);
        TestBinding.assert_not_same(array_binding_ref, array_value_ref_0, array_binding_gen, array_value_gen_1);
        TestBinding.assert_not_same(array_binding_ref, array_value_ref_1, array_binding_gen, array_value_gen_0);
        TestBinding.assert_not_same(array_binding_ref, array_value_ref_0, array_binding_ref, array_value_ref_1);
        TestBinding.assert_not_same(array_binding_gen, array_value_gen_0, array_binding_gen, array_value_gen_1);
        TestBinding.assert_valid(array_binding_ref, array_value_ref_0);
        TestBinding.assert_valid(array_binding_ref, array_value_ref_1);
        TestBinding.assert_valid(array_binding_gen, array_value_gen_0);
        TestBinding.assert_valid(array_binding_gen, array_value_gen_1);
    }

    @Test
    public void test_boolean_array() throws Exception {
        TestBinding.assert_same(boolean_array_binding_ref, boolean_array_value_ref_0, boolean_array_binding_gen, boolean_array_value_gen_0);
        TestBinding.assert_same(boolean_array_binding_ref, boolean_array_value_ref_1, boolean_array_binding_gen, boolean_array_value_gen_1);
        TestBinding.assert_same(boolean_array_binding_ref, boolean_array_value_ref_0, boolean_array_binding_ref, boolean_array_value_ref_0);
        TestBinding.assert_same(boolean_array_binding_gen, boolean_array_value_gen_0, boolean_array_binding_gen, boolean_array_value_gen_0);
        TestBinding.assert_not_same(boolean_array_binding_ref, boolean_array_value_ref_0, boolean_array_binding_gen, boolean_array_value_gen_1);
        TestBinding.assert_not_same(boolean_array_binding_ref, boolean_array_value_ref_1, boolean_array_binding_gen, boolean_array_value_gen_0);
        TestBinding.assert_not_same(boolean_array_binding_ref, boolean_array_value_ref_0, boolean_array_binding_ref, boolean_array_value_ref_1);
        TestBinding.assert_not_same(boolean_array_binding_gen, boolean_array_value_gen_0, boolean_array_binding_gen, boolean_array_value_gen_1);
        TestBinding.assert_valid(boolean_array_binding_ref, boolean_array_value_ref_0);
        TestBinding.assert_valid(boolean_array_binding_ref, boolean_array_value_ref_1);
        TestBinding.assert_valid(boolean_array_binding_gen, boolean_array_value_gen_0);
        TestBinding.assert_valid(boolean_array_binding_gen, boolean_array_value_gen_1);
    }

    @Test
    public void test_byte_array() throws Exception {
        TestBinding.assert_same(byte_array_binding_ref, byte_array_value_ref_0, byte_array_binding_gen, byte_array_value_gen_0);
        TestBinding.assert_same(byte_array_binding_ref, byte_array_value_ref_1, byte_array_binding_gen, byte_array_value_gen_1);
        TestBinding.assert_same(byte_array_binding_ref, byte_array_value_ref_0, byte_array_binding_ref, byte_array_value_ref_0);
        TestBinding.assert_same(byte_array_binding_gen, byte_array_value_gen_0, byte_array_binding_gen, byte_array_value_gen_0);
        TestBinding.assert_not_same(byte_array_binding_ref, byte_array_value_ref_0, byte_array_binding_gen, byte_array_value_gen_1);
        TestBinding.assert_not_same(byte_array_binding_ref, byte_array_value_ref_1, byte_array_binding_gen, byte_array_value_gen_0);
        TestBinding.assert_not_same(byte_array_binding_ref, byte_array_value_ref_0, byte_array_binding_ref, byte_array_value_ref_1);
        TestBinding.assert_not_same(byte_array_binding_gen, byte_array_value_gen_0, byte_array_binding_gen, byte_array_value_gen_1);
        TestBinding.assert_valid(byte_array_binding_ref, byte_array_value_ref_0);
        TestBinding.assert_valid(byte_array_binding_ref, byte_array_value_ref_1);
        TestBinding.assert_valid(byte_array_binding_gen, byte_array_value_gen_0);
        TestBinding.assert_valid(byte_array_binding_gen, byte_array_value_gen_1);
    }

    @Test
    public void test_int_array() throws Exception {
        TestBinding.assert_same(int_array_binding_ref, int_array_value_ref_0, int_array_binding_gen, int_array_value_gen_0);
        TestBinding.assert_same(int_array_binding_ref, int_array_value_ref_1, int_array_binding_gen, int_array_value_gen_1);
        TestBinding.assert_same(int_array_binding_ref, int_array_value_ref_0, int_array_binding_ref, int_array_value_ref_0);
        TestBinding.assert_same(int_array_binding_gen, int_array_value_gen_0, int_array_binding_gen, int_array_value_gen_0);
        TestBinding.assert_not_same(int_array_binding_ref, int_array_value_ref_0, int_array_binding_gen, int_array_value_gen_1);
        TestBinding.assert_not_same(int_array_binding_ref, int_array_value_ref_1, int_array_binding_gen, int_array_value_gen_0);
        TestBinding.assert_not_same(int_array_binding_ref, int_array_value_ref_0, int_array_binding_ref, int_array_value_ref_1);
        TestBinding.assert_not_same(int_array_binding_gen, int_array_value_gen_0, int_array_binding_gen, int_array_value_gen_1);
        TestBinding.assert_valid(int_array_binding_ref, int_array_value_ref_0);
        TestBinding.assert_valid(int_array_binding_ref, int_array_value_ref_1);
        TestBinding.assert_valid(int_array_binding_gen, int_array_value_gen_0);
        TestBinding.assert_valid(int_array_binding_gen, int_array_value_gen_1);
    }

    @Test
    public void test_int_array_2d() throws Exception {
        TestBinding.assert_same(int_array_2d_binding_ref, int_array_2d_value_ref_0, int_array_2d_binding_gen, int_array_2d_value_gen_0);
        TestBinding.assert_same(int_array_2d_binding_ref, int_array_2d_value_ref_1, int_array_2d_binding_gen, int_array_2d_value_gen_1);
        TestBinding.assert_same(int_array_2d_binding_ref, int_array_2d_value_ref_0, int_array_2d_binding_ref, int_array_2d_value_ref_0);
        TestBinding.assert_same(int_array_2d_binding_gen, int_array_2d_value_gen_0, int_array_2d_binding_gen, int_array_2d_value_gen_0);
        TestBinding.assert_not_same(int_array_2d_binding_ref, int_array_2d_value_ref_0, int_array_2d_binding_gen, int_array_2d_value_gen_1);
        TestBinding.assert_not_same(int_array_2d_binding_ref, int_array_2d_value_ref_1, int_array_2d_binding_gen, int_array_2d_value_gen_0);
        TestBinding.assert_not_same(int_array_2d_binding_ref, int_array_2d_value_ref_0, int_array_2d_binding_ref, int_array_2d_value_ref_1);
        TestBinding.assert_not_same(int_array_2d_binding_gen, int_array_2d_value_gen_0, int_array_2d_binding_gen, int_array_2d_value_gen_1);
        TestBinding.assert_valid(int_array_2d_binding_ref, int_array_2d_value_ref_0);
        TestBinding.assert_valid(int_array_2d_binding_ref, int_array_2d_value_ref_1);
        TestBinding.assert_valid(int_array_2d_binding_gen, int_array_2d_value_gen_0);
        TestBinding.assert_valid(int_array_2d_binding_gen, int_array_2d_value_gen_1);
    }

    @Test
    public void test_long_array() throws Exception {
        TestBinding.assert_same(long_array_binding_ref, long_array_value_ref_0, long_array_binding_gen, long_array_value_gen_0);
        TestBinding.assert_same(long_array_binding_ref, long_array_value_ref_1, long_array_binding_gen, long_array_value_gen_1);
        TestBinding.assert_same(long_array_binding_ref, long_array_value_ref_0, long_array_binding_ref, long_array_value_ref_0);
        TestBinding.assert_same(long_array_binding_gen, long_array_value_gen_0, long_array_binding_gen, long_array_value_gen_0);
        TestBinding.assert_not_same(long_array_binding_ref, long_array_value_ref_0, long_array_binding_gen, long_array_value_gen_1);
        TestBinding.assert_not_same(long_array_binding_ref, long_array_value_ref_1, long_array_binding_gen, long_array_value_gen_0);
        TestBinding.assert_not_same(long_array_binding_ref, long_array_value_ref_0, long_array_binding_ref, long_array_value_ref_1);
        TestBinding.assert_not_same(long_array_binding_gen, long_array_value_gen_0, long_array_binding_gen, long_array_value_gen_1);
        TestBinding.assert_valid(long_array_binding_ref, long_array_value_ref_0);
        TestBinding.assert_valid(long_array_binding_ref, long_array_value_ref_1);
        TestBinding.assert_valid(long_array_binding_gen, long_array_value_gen_0);
        TestBinding.assert_valid(long_array_binding_gen, long_array_value_gen_1);
    }

    @Test
    public void test_float_array() throws Exception {
        TestBinding.assert_same(float_array_binding_ref, float_array_value_ref_0, float_array_binding_gen, float_array_value_gen_0);
        TestBinding.assert_same(float_array_binding_ref, float_array_value_ref_1, float_array_binding_gen, float_array_value_gen_1);
        TestBinding.assert_same(float_array_binding_ref, float_array_value_ref_0, float_array_binding_ref, float_array_value_ref_0);
        TestBinding.assert_same(float_array_binding_gen, float_array_value_gen_0, float_array_binding_gen, float_array_value_gen_0);
        TestBinding.assert_not_same(float_array_binding_ref, float_array_value_ref_0, float_array_binding_gen, float_array_value_gen_1);
        TestBinding.assert_not_same(float_array_binding_ref, float_array_value_ref_1, float_array_binding_gen, float_array_value_gen_0);
        TestBinding.assert_not_same(float_array_binding_ref, float_array_value_ref_0, float_array_binding_ref, float_array_value_ref_1);
        TestBinding.assert_not_same(float_array_binding_gen, float_array_value_gen_0, float_array_binding_gen, float_array_value_gen_1);
        TestBinding.assert_valid(float_array_binding_ref, float_array_value_ref_0);
        TestBinding.assert_valid(float_array_binding_ref, float_array_value_ref_1);
        TestBinding.assert_valid(float_array_binding_gen, float_array_value_gen_0);
        TestBinding.assert_valid(float_array_binding_gen, float_array_value_gen_1);
    }

    @Test
    public void test_double_array() throws Exception {
        TestBinding.assert_same(double_array_binding_ref, double_array_value_ref_0, double_array_binding_gen, double_array_value_gen_0);
        TestBinding.assert_same(double_array_binding_ref, double_array_value_ref_1, double_array_binding_gen, double_array_value_gen_1);
        TestBinding.assert_same(double_array_binding_ref, double_array_value_ref_0, double_array_binding_ref, double_array_value_ref_0);
        TestBinding.assert_same(double_array_binding_gen, double_array_value_gen_0, double_array_binding_gen, double_array_value_gen_0);
        TestBinding.assert_not_same(double_array_binding_ref, double_array_value_ref_0, double_array_binding_gen, double_array_value_gen_1);
        TestBinding.assert_not_same(double_array_binding_ref, double_array_value_ref_1, double_array_binding_gen, double_array_value_gen_0);
        TestBinding.assert_not_same(double_array_binding_ref, double_array_value_ref_0, double_array_binding_ref, double_array_value_ref_1);
        TestBinding.assert_not_same(double_array_binding_gen, double_array_value_gen_0, double_array_binding_gen, double_array_value_gen_1);
        TestBinding.assert_valid(double_array_binding_ref, double_array_value_ref_0);
        TestBinding.assert_valid(double_array_binding_ref, double_array_value_ref_1);
        TestBinding.assert_valid(double_array_binding_gen, double_array_value_gen_0);
        TestBinding.assert_valid(double_array_binding_gen, double_array_value_gen_1);
    }

    @Test
    public void test_string_array() throws Exception {
        TestBinding.assert_same(string_array_binding_ref, string_array_value_ref_0, string_array_binding_gen, string_array_value_gen_0);
        TestBinding.assert_same(string_array_binding_ref, string_array_value_ref_1, string_array_binding_gen, string_array_value_gen_1);
        TestBinding.assert_same(string_array_binding_ref, string_array_value_ref_0, string_array_binding_ref, string_array_value_ref_0);
        TestBinding.assert_same(string_array_binding_gen, string_array_value_gen_0, string_array_binding_gen, string_array_value_gen_0);
        TestBinding.assert_not_same(string_array_binding_ref, string_array_value_ref_0, string_array_binding_gen, string_array_value_gen_1);
        TestBinding.assert_not_same(string_array_binding_ref, string_array_value_ref_1, string_array_binding_gen, string_array_value_gen_0);
        TestBinding.assert_not_same(string_array_binding_ref, string_array_value_ref_0, string_array_binding_ref, string_array_value_ref_1);
        TestBinding.assert_not_same(string_array_binding_gen, string_array_value_gen_0, string_array_binding_gen, string_array_value_gen_1);
        TestBinding.assert_valid(string_array_binding_ref, string_array_value_ref_0);
        TestBinding.assert_valid(string_array_binding_ref, string_array_value_ref_1);
        TestBinding.assert_valid(string_array_binding_gen, string_array_value_gen_0);
        TestBinding.assert_valid(string_array_binding_gen, string_array_value_gen_1);
    }

    @Test
    public void test_record() throws Exception {
        TestBinding.assert_same(record_binding_ref, record_value_ref_0, record_binding_gen, record_value_gen_0);
        TestBinding.assert_same(record_binding_ref, record_value_ref_1, record_binding_gen, record_value_gen_1);
        TestBinding.assert_same(record_binding_ref, record_value_ref_0, record_binding_ref, record_value_ref_0);
        TestBinding.assert_same(record_binding_gen, record_value_gen_0, record_binding_gen, record_value_gen_0);
        TestBinding.assert_not_same(record_binding_ref, record_value_ref_0, record_binding_gen, record_value_gen_1);
        TestBinding.assert_not_same(record_binding_ref, record_value_ref_1, record_binding_gen, record_value_gen_0);
        TestBinding.assert_not_same(record_binding_ref, record_value_ref_0, record_binding_ref, record_value_ref_1);
        TestBinding.assert_not_same(record_binding_gen, record_value_gen_0, record_binding_gen, record_value_gen_1);
        TestBinding.assert_valid(record_binding_ref, record_value_ref_0);
        TestBinding.assert_valid(record_binding_ref, record_value_ref_1);
        TestBinding.assert_valid(record_binding_gen, record_value_gen_0);
        TestBinding.assert_valid(record_binding_gen, record_value_gen_1);
    }

    @Test
    public void test_map() throws Exception {
        TestBinding.assert_same(map_binding_ref, map_value_ref_0, map_binding_gen, map_value_gen_0);
        TestBinding.assert_same(map_binding_ref, map_value_ref_1, map_binding_gen, map_value_gen_1);
        TestBinding.assert_same(map_binding_ref, map_value_ref_0, map_binding_ref, map_value_ref_0);
        TestBinding.assert_same(map_binding_gen, map_value_gen_0, map_binding_gen, map_value_gen_0);
        TestBinding.assert_not_same(map_binding_ref, map_value_ref_0, map_binding_gen, map_value_gen_1);
        TestBinding.assert_not_same(map_binding_ref, map_value_ref_1, map_binding_gen, map_value_gen_0);
        TestBinding.assert_not_same(map_binding_ref, map_value_ref_0, map_binding_ref, map_value_ref_1);
        TestBinding.assert_not_same(map_binding_gen, map_value_gen_0, map_binding_gen, map_value_gen_1);
        TestBinding.assert_valid(map_binding_ref, map_value_ref_0);
        TestBinding.assert_valid(map_binding_ref, map_value_ref_1);
        TestBinding.assert_valid(map_binding_gen, map_value_gen_0);
        TestBinding.assert_valid(map_binding_gen, map_value_gen_1);
        this.test_ordered_map_binding(map_binding_ref);
        this.test_ordered_map_binding(map_binding_gen);
    }

    @Test
    public void test_optional() throws Exception {
        TestBinding.assert_same(optional_binding_ref, optional_value_ref_0, optional_binding_gen, optional_value_gen_0);
        TestBinding.assert_same(optional_binding_ref, optional_value_ref_1, optional_binding_gen, optional_value_gen_1);
        TestBinding.assert_same(optional_binding_ref, optional_value_ref_0, optional_binding_ref, optional_value_ref_0);
        TestBinding.assert_same(optional_binding_gen, optional_value_gen_0, optional_binding_gen, optional_value_gen_0);
        TestBinding.assert_not_same(optional_binding_ref, optional_value_ref_0, optional_binding_gen, optional_value_gen_1);
        TestBinding.assert_not_same(optional_binding_ref, optional_value_ref_1, optional_binding_gen, optional_value_gen_0);
        TestBinding.assert_not_same(optional_binding_ref, optional_value_ref_0, optional_binding_ref, optional_value_ref_1);
        TestBinding.assert_not_same(optional_binding_gen, optional_value_gen_0, optional_binding_gen, optional_value_gen_1);
        TestBinding.assert_valid(optional_binding_ref, optional_value_ref_0);
        TestBinding.assert_valid(optional_binding_ref, optional_value_ref_1);
        TestBinding.assert_valid(optional_binding_gen, optional_value_gen_0);
        TestBinding.assert_valid(optional_binding_gen, optional_value_gen_1);
    }

    @Test
    public void test_union() throws Exception {
        TestBinding.assert_same(union_binding_ref, union_value_ref_0, union_binding_gen, union_value_gen_0);
        TestBinding.assert_same(union_binding_ref, union_value_ref_1, union_binding_gen, union_value_gen_1);
        TestBinding.assert_same(union_binding_ref, union_value_ref_0, union_binding_ref, union_value_ref_0);
        TestBinding.assert_same(union_binding_gen, union_value_gen_0, union_binding_gen, union_value_gen_0);
        TestBinding.assert_not_same(union_binding_ref, union_value_ref_0, union_binding_gen, union_value_gen_1);
        TestBinding.assert_not_same(union_binding_ref, union_value_ref_1, union_binding_gen, union_value_gen_0);
        TestBinding.assert_not_same(union_binding_ref, union_value_ref_0, union_binding_ref, union_value_ref_1);
        TestBinding.assert_not_same(union_binding_gen, union_value_gen_0, union_binding_gen, union_value_gen_1);
        TestBinding.assert_valid(union_binding_ref, union_value_ref_0);
        TestBinding.assert_valid(union_binding_ref, union_value_ref_1);
        TestBinding.assert_valid(union_binding_gen, union_value_gen_0);
        TestBinding.assert_valid(union_binding_gen, union_value_gen_1);
    }

    @Test
    public void test_variant() throws Exception {
        TestBinding.assert_same(variant_binding_ref, variant_value_ref_0, variant_binding_gen, variant_value_gen_0);
        TestBinding.assert_same(variant_binding_ref, variant_value_ref_1, variant_binding_gen, variant_value_gen_1);
        TestBinding.assert_same(variant_binding_ref, variant_value_ref_0, variant_binding_ref, variant_value_ref_0);
        TestBinding.assert_same(variant_binding_gen, variant_value_gen_0, variant_binding_gen, variant_value_gen_0);
        TestBinding.assert_not_same(variant_binding_ref, variant_value_ref_0, variant_binding_gen, variant_value_gen_1);
        TestBinding.assert_not_same(variant_binding_ref, variant_value_ref_1, variant_binding_gen, variant_value_gen_0);
        TestBinding.assert_not_same(variant_binding_ref, variant_value_ref_0, variant_binding_ref, variant_value_ref_1);
        TestBinding.assert_not_same(variant_binding_gen, variant_value_gen_0, variant_binding_gen, variant_value_gen_1);
        TestBinding.assert_valid(variant_binding_ref, variant_value_ref_0);
        TestBinding.assert_valid(variant_binding_ref, variant_value_ref_1);
        TestBinding.assert_valid(variant_binding_gen, variant_value_gen_0);
        TestBinding.assert_valid(variant_binding_gen, variant_value_gen_1);
    }

    @Test
    public void test_datatype() throws Exception {
        TestBinding.assert_same(datatype_binding_ref, datatype_value_ref_0, datatype_binding_ref, datatype_value_ref_0);
        TestBinding.assert_not_same(datatype_binding_ref, datatype_value_ref_0, datatype_binding_ref, datatype_value_ref_1);
        TestBinding.assert_valid(datatype_binding_ref, datatype_value_ref_1);
        RandomValue rv = new RandomValue();
        rv.refereableRecords = true;
        int iteration_count = 100;
        int iteration = 0;
        while (iteration < iteration_count) {
            int seed = iteration++;
            rv.getRandom().setSeed(seed);
            rv.getRandom().nextLong();
            Binding b = datatype_binding_ref;
            Datatype rt = rv.randomType(0, 3);
            Serializer s = b.serializer();
            byte[] bytes = s.serialize(rt);
            Object rt2 = s.deserialize(bytes);
            b.assertInstaceIsValid(rt2);
        }
    }

    @Test
    public void test_random_values() throws Exception {
        int iteration_count = 10000;
        RandomValue rv = new RandomValue();
        rv.refereableRecords = true;
        int iteration = 0;
        while (iteration < iteration_count) {
            int seed = iteration++;
            rv.getRandom().setSeed(seed);
            rv.getRandom().nextLong();
            Object variant_value_gen_random_0 = variant_binding_gen.accept(rv);
            rv.getRandom().setSeed(seed);
            rv.getRandom().nextLong();
            Object variant_value_gen_random_1 = variant_binding_gen.accept(rv);
            TestBinding.assert_same(variant_binding_gen, variant_value_gen_random_0, variant_binding_gen, variant_value_gen_random_0);
            TestBinding.assert_same(variant_binding_gen, variant_value_gen_random_1, variant_binding_gen, variant_value_gen_random_1);
            TestBinding.assert_valid(variant_binding_gen, variant_value_gen_random_0);
            TestBinding.assert_valid(variant_binding_gen, variant_value_gen_random_1);
        }
    }

    static void assert_same(Binding b1, Object o1, Binding b2, Object o2) throws BindingException, SerializationException, IOException, DataTypeSyntaxError, SerializerConstructionException {
        Assert.assertEquals(b1.type(), b2.type());
        Datatype t = b1.type();
        Assert.assertEquals(0L, Bindings.compare(b1, o1, b2, o2));
        Assert.assertTrue(Bindings.equals(b1, o1, b2, o2));
        int hash1 = b1.hashValue(o1);
        int hash2 = b2.hashValue(o2);
        Assert.assertEquals(hash1, hash2);
        b1.assertInstaceIsValid(o1);
        b2.assertInstaceIsValid(o2);
        Object x1 = b1.createDefault();
        Object x2 = b2.createDefault();
        b1.assertInstaceIsValid(x1);
        b2.assertInstaceIsValid(x2);
        Assert.assertEquals(0L, Bindings.compare(b1, o1, b2, o2));
        Assert.assertTrue(Bindings.equals(b1, o1, b2, o2));
        Object o1_ = Bindings.cloneUnchecked(o2, b2, b1);
        Object o2_ = Bindings.cloneUnchecked(o1, b1, b2);
        if (!b1.isImmutable() && !b2.isImmutable()) {
            Assert.assertTrue(o1 != o1_);
            Assert.assertTrue(o2 != o2_);
        }
        Assert.assertEquals(0L, b1.compare(o1, o1_));
        Assert.assertEquals(0L, b2.compare(o2, o2_));
        Assert.assertTrue(b1.equals(o1, o1_));
        Assert.assertTrue(b2.equals(o2, o2_));
        b1.assertInstaceIsValid(o1_);
        b2.assertInstaceIsValid(o2_);
        o1_ = b1.cloneUnchecked(o1);
        o2_ = b2.cloneUnchecked(o2);
        if (!b1.isImmutable()) {
            Assert.assertTrue(o1 != o1_);
        }
        if (!b2.isImmutable()) {
            Assert.assertTrue(o2 != o2_);
        }
        Assert.assertEquals(0L, b1.compare(o1, o1_));
        Assert.assertEquals(0L, b2.compare(o2, o2_));
        Assert.assertTrue(b1.equals(o1, o1_));
        Assert.assertTrue(b2.equals(o2, o2_));
        b1.assertInstaceIsValid(o1_);
        b2.assertInstaceIsValid(o2_);
        o1_ = Bindings.adaptUnchecked(o2, b2, b1);
        o2_ = Bindings.adaptUnchecked(o1, b1, b2);
        Assert.assertEquals(0L, b1.compare(o1, o1_));
        Assert.assertEquals(0L, b2.compare(o2, o2_));
        Assert.assertTrue(b1.equals(o1, o1_));
        Assert.assertTrue(b2.equals(o2, o2_));
        b1.assertInstaceIsValid(o1_);
        b2.assertInstaceIsValid(o2_);
        Serializer s1 = Bindings.getSerializer(b1);
        Serializer s2 = Bindings.getSerializer(b2);
        byte[] byte1 = s1.serialize(o1);
        byte[] byte2 = s2.serialize(o2);
        Assert.assertNotNull(byte1);
        Assert.assertNotNull(byte2);
        Assert.assertTrue(Arrays.equals(byte1, byte2));
        o1_ = s1.deserialize(byte2);
        o2_ = s2.deserialize(byte1);
        Assert.assertEquals(0L, b1.compare(o1, o1_));
        Assert.assertTrue(b1.equals(o1, o1_));
        Assert.assertEquals(0L, b2.compare(o2, o2_));
        Assert.assertTrue(b2.equals(o2, o2_));
        b1.assertInstaceIsValid(o1_);
        b2.assertInstaceIsValid(o2_);
        if (!OMIT_PARSER_TEST) {
            String str1 = b1.printValueDefinition(o1, true);
            String str2 = b2.printValueDefinition(o2, true);
            Assert.assertEquals(str1, str2);
            o1_ = b1.parseValueDefinition(str1);
            o2_ = b2.parseValueDefinition(str2);
            Assert.assertEquals(0L, b1.compare(o1, o1_));
            Assert.assertEquals(0L, b2.compare(o2, o2_));
            Assert.assertTrue(b1.equals(o1, o1_));
            Assert.assertTrue(b2.equals(o2, o2_));
            b1.assertInstaceIsValid(o1_);
            b2.assertInstaceIsValid(o2_);
            str1 = b1.printValueDefinition(o1, false);
            str2 = b2.printValueDefinition(o2, false);
            o1_ = b1.parseValueDefinition(str1);
            o2_ = b2.parseValueDefinition(str2);
            Assert.assertEquals(0L, b1.compare(o1, o1_));
            Assert.assertTrue(b1.equals(o1, o1_));
            Assert.assertEquals(0L, b2.compare(o2, o2_));
            Assert.assertTrue(b2.equals(o2, o2_));
            b1.assertInstaceIsValid(o1_);
            b2.assertInstaceIsValid(o2_);
        }
    }

    static void assert_not_same(Binding b1, Object o1, Binding b2, Object o2) throws BindingException, SerializationException, IOException, DataTypeSyntaxError, SerializerConstructionException {
        Assert.assertEquals(b1.type(), b2.type());
        Datatype t = b1.type();
        int dif = Integer.signum(Bindings.compare(b1, o1, b2, o2));
        int dif2 = Integer.signum(Bindings.compare(b2, o2, b1, o1));
        Assert.assertEquals(-dif2, dif);
        Assert.assertFalse(Bindings.equals(b1, o1, b2, o2));
        int hash1 = b1.hashValue(o1);
        int hash2 = b2.hashValue(o2);
        Assert.assertNotSame(hash1, hash2);
        b1.assertInstaceIsValid(o1);
        b2.assertInstaceIsValid(o2);
        Object o1_ = Bindings.adaptUnchecked(o2, b2, b1);
        Object o2_ = Bindings.adaptUnchecked(o1, b1, b2);
        dif = Integer.signum(Bindings.compare(b1, o1_, b2, o2_));
        dif2 = Integer.signum(Bindings.compare(b2, o2_, b1, o1_));
        Assert.assertEquals(-dif2, dif);
        Assert.assertFalse(b1.equals(o1, o1_));
        Assert.assertFalse(b2.equals(o2, o2_));
        b1.assertInstaceIsValid(o1_);
        b2.assertInstaceIsValid(o2_);
        Serializer s1 = Bindings.getSerializer(b1);
        Serializer s2 = Bindings.getSerializer(b2);
        byte[] byte1 = s1.serialize(o1);
        byte[] byte2 = s2.serialize(o2);
        Assert.assertFalse(Arrays.equals(byte1, byte2));
        o1_ = s1.deserialize(byte2);
        o2_ = s2.deserialize(byte1);
        dif = Integer.signum(Bindings.compare(b1, o1_, b2, o2_));
        dif2 = Integer.signum(Bindings.compare(b2, o2_, b1, o1_));
        Assert.assertEquals(-dif2, dif);
        dif = Integer.signum(Bindings.compare(b1, o1, b1, o1_));
        dif2 = Integer.signum(Bindings.compare(b2, o2, b2, o2_));
        Assert.assertEquals(-dif2, dif);
        Assert.assertFalse(b1.equals(o1, o1_));
        Assert.assertFalse(b2.equals(o2, o2_));
        b1.assertInstaceIsValid(o1_);
        b2.assertInstaceIsValid(o2_);
        if (!OMIT_PARSER_TEST) {
            String str1 = b1.printValueDefinition(o1, true);
            String str2 = b2.printValueDefinition(o2, true);
            Assert.assertNotSame(str1, str2);
            o1_ = b1.parseValueDefinition(str2);
            o2_ = b2.parseValueDefinition(str1);
            dif = Integer.signum(Bindings.compare(b1, o1_, b2, o2_));
            dif2 = Integer.signum(Bindings.compare(b2, o2_, b1, o1_));
            Assert.assertEquals(-dif2, dif);
            dif = Integer.signum(Bindings.compare(b1, o1, b1, o1_));
            dif2 = Integer.signum(Bindings.compare(b2, o2, b2, o2_));
            Assert.assertEquals(-dif2, dif);
            Assert.assertFalse(b1.equals(o1, o1_));
            Assert.assertFalse(b2.equals(o2, o2_));
            b1.assertInstaceIsValid(o1_);
            b2.assertInstaceIsValid(o2_);
            str1 = b1.printValueDefinition(o1, false);
            str2 = b2.printValueDefinition(o2, false);
            Assert.assertNotSame(str1, str2);
            o1_ = b1.parseValueDefinition(str2);
            o2_ = b2.parseValueDefinition(str1);
            dif = Integer.signum(Bindings.compare(b1, o1_, b2, o2_));
            dif2 = Integer.signum(Bindings.compare(b2, o2_, b1, o1_));
            Assert.assertEquals(-dif2, dif);
            dif = Integer.signum(Bindings.compare(b1, o1, b1, o1_));
            dif2 = Integer.signum(Bindings.compare(b2, o2, b2, o2_));
            Assert.assertEquals(-dif2, dif);
            Assert.assertFalse(b1.equals(o1, o1_));
            Assert.assertFalse(b2.equals(o2, o2_));
            b1.assertInstaceIsValid(o1_);
            b2.assertInstaceIsValid(o2_);
        }
    }

    static void assert_valid(Binding b, Object o) throws BindingException, IOException, SerializationException, DataTypeSyntaxError, SerializerConstructionException {
        b.assertInstaceIsValid(o);
        Assert.assertTrue(b.isInstance(o));
        Serializer s = Bindings.getSerializer(b);
        byte[] bytes = s.serialize(o);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        s.skip(is);
        Assert.assertEquals(0L, ((InputStream)is).available());
        is = new ByteArrayInputStream(bytes);
        s.deserialize(is);
        Assert.assertEquals(0L, ((InputStream)is).available());
        Object o_ = s.deserialize(bytes);
        Assert.assertEquals(0L, b.compare(o, o_));
        Assert.assertTrue(b.equals(o, o_));
        Object gb = Bindings.getMutableBinding(b.type());
        o_ = ((Binding)gb).createDefault();
        s = ((Binding)gb).serializer();
        s.deserialize(bytes, o_);
        Assert.assertTrue(Bindings.equals(b, o, gb, o_));
        o_ = ((Binding)gb).createDefault();
        ((Binding)gb).readFrom(b, o, o_);
        Assert.assertTrue(Bindings.equals(b, o, gb, o_));
        if (!OMIT_PARSER_TEST) {
            String str = b.printValueDefinition(o, true);
            o_ = b.parseValueDefinition(str);
            Assert.assertEquals(0L, b.compare(o, o_));
            Assert.assertTrue(b.equals(o, o_));
            b.assertInstaceIsValid(o_);
            Assert.assertTrue(b.isInstance(o_));
        }
    }

    void test_ordered_map_binding(MapBinding b) throws Exception {
        Datatype keyType = b.type().keyType;
        Datatype valueType = b.type().valueType;
        Assert.assertTrue(keyType instanceof IntegerType);
        Assert.assertTrue(valueType instanceof StringType);
        IntegerBinding kb = (IntegerBinding)b.getKeyBinding();
        Object map = b.createDefault();
        String value = "";
        b.put(map, kb.create(0), value);
        b.put(map, kb.create(50), value);
        b.put(map, kb.create(10), value);
        b.put(map, kb.create(30), value);
        b.put(map, kb.create(40), value);
        b.put(map, kb.create(60), value);
        b.put(map, kb.create(20), value);
        Assert.assertEquals(b.getFirstKey(map), kb.create(0));
        Assert.assertEquals(b.getLastKey(map), kb.create(60));
        Assert.assertEquals(b.getFloorKey(map, kb.create(30)), kb.create(30));
        Assert.assertEquals(b.getFloorKey(map, kb.create(29)), kb.create(20));
        Assert.assertEquals(b.getFloorKey(map, kb.create(31)), kb.create(30));
        Assert.assertEquals(b.getFloorKey(map, kb.create(70)), kb.create(60));
        Assert.assertEquals(b.getFloorKey(map, kb.create(60)), kb.create(60));
        Assert.assertEquals(b.getFloorKey(map, kb.create(61)), kb.create(60));
        Assert.assertEquals(b.getFloorKey(map, kb.create(1)), kb.create(0));
        Assert.assertEquals(b.getFloorKey(map, kb.create(0)), kb.create(0));
        Assert.assertEquals(b.getFloorKey(map, kb.create(-1)), null);
        Assert.assertEquals(b.getLowerKey(map, kb.create(30)), kb.create(20));
        Assert.assertEquals(b.getLowerKey(map, kb.create(29)), kb.create(20));
        Assert.assertEquals(b.getLowerKey(map, kb.create(31)), kb.create(30));
        Assert.assertEquals(b.getLowerKey(map, kb.create(70)), kb.create(60));
        Assert.assertEquals(b.getLowerKey(map, kb.create(60)), kb.create(50));
        Assert.assertEquals(b.getLowerKey(map, kb.create(61)), kb.create(60));
        Assert.assertEquals(b.getLowerKey(map, kb.create(1)), kb.create(0));
        Assert.assertEquals(b.getLowerKey(map, kb.create(0)), null);
        Assert.assertEquals(b.getLowerKey(map, kb.create(-1)), null);
        Assert.assertEquals(b.getCeilingKey(map, kb.create(30)), kb.create(30));
        Assert.assertEquals(b.getCeilingKey(map, kb.create(29)), kb.create(30));
        Assert.assertEquals(b.getCeilingKey(map, kb.create(31)), kb.create(40));
        Assert.assertEquals(b.getCeilingKey(map, kb.create(-10)), kb.create(0));
        Assert.assertEquals(b.getCeilingKey(map, kb.create(60)), kb.create(60));
        Assert.assertEquals(b.getCeilingKey(map, kb.create(61)), null);
        Assert.assertEquals(b.getHigherKey(map, kb.create(30)), kb.create(40));
        Assert.assertEquals(b.getHigherKey(map, kb.create(29)), kb.create(30));
        Assert.assertEquals(b.getHigherKey(map, kb.create(31)), kb.create(40));
        Assert.assertEquals(b.getHigherKey(map, kb.create(-10)), kb.create(0));
        Assert.assertEquals(b.getHigherKey(map, kb.create(60)), null);
        Assert.assertEquals(b.getHigherKey(map, kb.create(61)), null);
    }
}

