/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.charset.Charset;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.StringBinding;

public class StringUTFTest {
    public static void main(String[] args) throws Exception {
        StringBinding b = Bindings.STRING;
        int c = 10000;
        String[] strs = new String[c];
        int i = 0;
        while (i < c) {
            strs[i] = (String)b.createRandom(i);
            ++i;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(0xA00000);
        DataOutputStream dos = new DataOutputStream(baos);
        System.gc();
        long x = System.nanoTime();
        int i2 = 0;
        while (i2 < c) {
            dos.writeUTF(strs[i2]);
            ++i2;
        }
        long y = System.nanoTime() - x;
        System.out.println("DataOutputStream.writeUTF: " + y);
        byte[] data = baos.toByteArray();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        x = System.nanoTime();
        int i3 = 0;
        while (i3 < c) {
            dis.readUTF();
            ++i3;
        }
        y = System.nanoTime() - x;
        System.out.println("DataOutputStream.readUTF : " + y);
        Charset cs = Charset.forName("UTF8");
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream(0xA00000);
        DataOutputStream dos2 = new DataOutputStream(baos2);
        System.gc();
        long x2 = System.nanoTime();
        int i4 = 0;
        while (i4 < c) {
            data = strs[i4].getBytes(cs);
            dos2.writeInt(data.length);
            dos2.write(data);
            ++i4;
        }
        long y2 = System.nanoTime() - x2;
        System.out.println("String#getBytes(cs)      : " + y2);
        byte[] strData = new byte[1024];
        byte[] data2 = baos2.toByteArray();
        DataInputStream dis2 = new DataInputStream(new ByteArrayInputStream(data2));
        x2 = System.nanoTime();
        int i5 = 0;
        while (i5 < c) {
            int len = dis2.readInt();
            dis2.read(strData, 0, len);
            new String(strData, cs);
            ++i5;
        }
        y2 = System.nanoTime() - x2;
        System.out.println("new String(byte[], cs)   : " + y2);
    }
}

