/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.parser.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.parser.DataParser;
import org.simantics.databoard.parser.ParseException;
import org.simantics.databoard.parser.ast.type.AstArrayType;
import org.simantics.databoard.parser.ast.type.AstAttribute;
import org.simantics.databoard.parser.ast.type.AstComponent;
import org.simantics.databoard.parser.ast.type.AstRecordType;
import org.simantics.databoard.parser.ast.type.AstTupleType;
import org.simantics.databoard.parser.ast.type.AstType;
import org.simantics.databoard.parser.ast.type.AstTypeDefinition;
import org.simantics.databoard.parser.ast.type.AstTypeReference;
import org.simantics.databoard.parser.ast.type.AstUnionType;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.unparsing.DataTypePrinter;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.DataTypeDefinition;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;

public class DataTypeRepository {
    Map<String, Datatype> dataTypes = new TreeMap<String, Datatype>();
    Map<String, Datatype> dataTypesConstruction = new HashMap<String, Datatype>();
    Map<String, AstType> untranslatedTypes = new TreeMap<String, AstType>();
    Map<Datatype, String> typeNames = new HashMap<Datatype, String>();

    public void add(String name, Datatype type) {
        this.dataTypes.put(name, type);
        this.typeNames.put(type, name);
    }

    void addTemp(String name, Datatype type) {
        Datatype oldType = this.dataTypesConstruction.get(name);
        if (oldType != null && oldType != type) {
            throw new RuntimeException("name = " + type + " is already mapped in the repository to " + oldType);
        }
        this.dataTypesConstruction.put(name, type);
    }

    void finishType(String name) {
        Datatype type = this.dataTypesConstruction.remove(name);
        if (type == null) {
            throw new RuntimeException("X");
        }
        this.dataTypes.put(name, type);
        this.typeNames.put(type, name);
    }

    public Datatype get(String name) {
        Datatype res1 = this.dataTypesConstruction.get(name);
        if (res1 != null) {
            return res1;
        }
        Datatype res2 = this.dataTypes.get(name);
        return res2;
    }

    public String get(Datatype type) {
        return this.typeNames.get(type);
    }

    public boolean contains(String name) {
        return this.dataTypes.containsKey(name);
    }

    public boolean contains(Datatype type) {
        return this.typeNames.containsKey(type);
    }

    public Set<String> getTypeNames() {
        return this.dataTypes.keySet();
    }

    public void addDefinitions(DataTypeDefinition ... defs) {
        DataTypeDefinition[] dataTypeDefinitionArray = defs;
        int n = defs.length;
        int n2 = 0;
        while (n2 < n) {
            DataTypeDefinition def = dataTypeDefinitionArray[n2];
            this.add(def.getName(), def.getDataType());
            ++n2;
        }
    }

    public void addDefinition(DataTypeDefinition def) {
        this.add(def.getName(), def.getDataType());
    }

    public Datatype add(String name, AstType ast) throws DataTypeSyntaxError {
        Datatype type;
        Datatype t;
        if (name != null && (t = this.get(name)) != null) {
            return t;
        }
        if (ast instanceof AstTypeReference) {
            AstTypeReference named = (AstTypeReference)ast;
            Datatype type2 = null;
            if (this.dataTypesConstruction.containsKey(named.name)) {
                return this.dataTypesConstruction.get(named.name);
            }
            if (this.dataTypes.containsKey(named.name)) {
                return this.dataTypes.get(named.name);
            }
            type2 = this.untranslatedTypes.containsKey(named.name) ? this.add(named.name, this.untranslatedTypes.remove(named.name)) : this.translateBuiltin(named);
            if (name != null) {
                this.add(name, type2);
            }
            return type2;
        }
        if (ast instanceof AstArrayType) {
            type = new ArrayType();
            if (name != null) {
                this.addTemp(name, type);
            }
            this.translate((AstArrayType)ast, (ArrayType)type);
            if (name != null) {
                this.finishType(name);
            }
            return type;
        }
        if (ast instanceof AstRecordType) {
            type = new RecordType();
            if (name != null) {
                this.addTemp(name, type);
            }
            this.translate((AstRecordType)ast, (RecordType)type);
            if (name != null) {
                this.finishType(name);
            }
            return type;
        }
        if (ast instanceof AstTupleType) {
            type = new RecordType();
            if (name != null) {
                this.addTemp(name, type);
            }
            this.translate((AstTupleType)ast, (RecordType)type);
            if (name != null) {
                this.finishType(name);
            }
            return type;
        }
        if (ast instanceof AstUnionType) {
            type = new UnionType();
            if (name != null) {
                this.addTemp(name, type);
            }
            this.translate((AstUnionType)ast, (UnionType)type);
            if (name != null) {
                this.finishType(name);
            }
            return type;
        }
        throw new AssertionError((Object)"Not all syntax tree nodes covered");
    }

    private Datatype translateBuiltin(AstTypeReference named) throws DataTypeSyntaxError {
        try {
            if (named.name.equals("Boolean")) {
                if (!named.parameters.isEmpty()) {
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not take type parameters.");
                }
                if (!named.attributes.isEmpty()) {
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not have attributes.");
                }
                return Datatypes.BOOLEAN;
            }
            if (named.name.equals("Byte")) {
                if (!named.parameters.isEmpty()) {
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not take type parameters.");
                }
                if (!named.attributes.isEmpty()) {
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not have attributes.");
                }
                return Datatypes.BYTE;
            }
            if (named.name.equals("Integer")) {
                if (!named.parameters.isEmpty()) {
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not take type parameters.");
                }
                if (named.attributes.isEmpty()) {
                    return Datatypes.INTEGER;
                }
                IntegerType type = new IntegerType();
                for (AstAttribute attribute : named.attributes) {
                    String key = attribute.key;
                    if (key.equals("range")) {
                        type.setRange(attribute.value);
                        continue;
                    }
                    if (key.equals("unit")) {
                        type.setUnit(attribute.value);
                        continue;
                    }
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not have attribute " + attribute.key + ".");
                }
                return type;
            }
            if (named.name.equals("Long")) {
                if (!named.parameters.isEmpty()) {
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not take type parameters.");
                }
                if (named.attributes.isEmpty()) {
                    return Datatypes.LONG;
                }
                LongType type = new LongType();
                for (AstAttribute attribute : named.attributes) {
                    String key = attribute.key;
                    if (key.equals("range")) {
                        type.setRange(attribute.value);
                        continue;
                    }
                    if (key.equals("unit")) {
                        type.setUnit(attribute.value);
                        continue;
                    }
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not have attribute " + attribute.key + ".");
                }
                return type;
            }
            if (named.name.equals("Float")) {
                if (!named.parameters.isEmpty()) {
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not take type parameters.");
                }
                if (named.attributes.isEmpty()) {
                    return Datatypes.FLOAT;
                }
                FloatType type = new FloatType();
                for (AstAttribute attribute : named.attributes) {
                    String key = attribute.key;
                    if (key.equals("range")) {
                        type.setRange(attribute.value);
                        continue;
                    }
                    if (key.equals("unit")) {
                        type.setUnit(attribute.value);
                        continue;
                    }
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not have attribute " + attribute.key + ".");
                }
                return type;
            }
            if (named.name.equals("Double")) {
                if (!named.parameters.isEmpty()) {
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not take type parameters.");
                }
                if (named.attributes.isEmpty()) {
                    return Datatypes.DOUBLE;
                }
                DoubleType type = new DoubleType();
                for (AstAttribute attribute : named.attributes) {
                    String key = attribute.key;
                    if (key.equals("range")) {
                        type.setRange(attribute.value);
                        continue;
                    }
                    if (key.equals("unit")) {
                        type.setUnit(attribute.value);
                        continue;
                    }
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not have attribute " + attribute.key + ".");
                }
                return type;
            }
            if (named.name.equals("String")) {
                if (!named.parameters.isEmpty()) {
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not take type parameters.");
                }
                if (named.attributes.isEmpty()) {
                    return Datatypes.STRING;
                }
                StringType type = new StringType();
                for (AstAttribute attribute : named.attributes) {
                    String key = attribute.key;
                    if (key.equals("mimeType")) {
                        type.setMimeType(attribute.value);
                        continue;
                    }
                    if (key.equals("pattern")) {
                        type.setPattern(attribute.value);
                        continue;
                    }
                    if (key.equals("length")) {
                        type.setLength(attribute.value);
                        continue;
                    }
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not have attribute " + attribute.key + ".");
                }
                return type;
            }
            if (named.name.equals("Optional")) {
                if (named.parameters.size() != 1) {
                    throw new DataTypeSyntaxError("Optional takes one type parameter not " + named.parameters.size() + ".");
                }
                if (!named.attributes.isEmpty()) {
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not have attributes.");
                }
                OptionalType type = new OptionalType();
                type.componentType = this.translate(named.parameters.get(0));
                return type;
            }
            if (named.name.equals("Variant")) {
                if (!named.parameters.isEmpty()) {
                    throw new DataTypeSyntaxError(String.valueOf(named.name) + " does not take type parameters.");
                }
                return Datatypes.VARIANT;
            }
            if (named.name.equals("Map")) {
                if (named.parameters.size() != 2) {
                    throw new DataTypeSyntaxError("Map takes two type parameters not " + named.parameters.size() + ".");
                }
                return new MapType(this.translate(named.parameters.get(0)), this.translate(named.parameters.get(1)));
            }
            throw new DataTypeSyntaxError("Undefined type " + named.name);
        }
        catch (IllegalArgumentException e) {
            throw new DataTypeSyntaxError(e);
        }
    }

    private void translate(AstArrayType ast, ArrayType type) throws DataTypeSyntaxError {
        type.componentType = this.translate(ast.componentType);
        if (ast.minLength == null) {
            if (ast.maxLength == null) {
                type.setLength((String)null);
            } else {
                type.setLength(new Range(Limit.nolimit(), Limit.inclusive(ast.maxLength)));
            }
        } else if (ast.maxLength == null) {
            type.setLength(new Range(Limit.inclusive(ast.minLength), Limit.nolimit()));
        } else {
            type.setLength(new Range(Limit.inclusive(ast.minLength), Limit.inclusive(ast.maxLength)));
        }
    }

    private void translate(AstRecordType ast, RecordType type) throws DataTypeSyntaxError {
        Component[] components = new Component[ast.components.size()];
        int i = 0;
        while (i < ast.components.size()) {
            AstComponent astComponent = ast.components.get(i);
            components[i] = new Component(astComponent.name, this.translate(astComponent.type));
            ++i;
        }
        type.setReferable(ast.referable);
        type.setComponents(components);
    }

    private void translate(AstTupleType ast, RecordType type) throws DataTypeSyntaxError {
        Component[] components = new Component[ast.components.size()];
        components = new Component[ast.components.size()];
        int i = 0;
        while (i < ast.components.size()) {
            components[i] = new Component(Integer.toString(i), this.translate(ast.components.get(i)));
            ++i;
        }
        type.setComponents(components);
    }

    private void translate(AstUnionType ast, UnionType type) throws DataTypeSyntaxError {
        type.components = new Component[ast.components.size()];
        int i = 0;
        while (i < ast.components.size()) {
            AstComponent astComponent = ast.components.get(i);
            type.components[i] = new Component(astComponent.name, this.add(astComponent.name, astComponent.type));
            ++i;
        }
    }

    public void add(List<AstTypeDefinition> definitions) throws DataTypeSyntaxError {
        for (AstTypeDefinition def : definitions) {
            this.untranslatedTypes.put(def.name, def.type);
        }
        for (AstTypeDefinition def : definitions) {
            if (!this.untranslatedTypes.containsKey(def.name)) continue;
            this.add(def.name, this.untranslatedTypes.remove(def.name));
        }
    }

    public void addDefinitions(String definitions) throws DataTypeSyntaxError {
        try {
            List<AstTypeDefinition> typeDefinitions = new DataParser(new StringReader(definitions)).typeDefinitions();
            this.add(typeDefinitions);
        }
        catch (ParseException e) {
            throw new DataTypeSyntaxError(e);
        }
    }

    public void addDefinitions(InputStream definitions) throws IOException, DataTypeSyntaxError {
        try {
            List<AstTypeDefinition> typeDefinitions = new DataParser(definitions).typeDefinitions();
            this.add(typeDefinitions);
        }
        catch (ParseException e) {
            throw new DataTypeSyntaxError(e);
        }
    }

    public Datatype translate(AstType ast) throws DataTypeSyntaxError {
        return this.add(null, ast);
    }

    public Datatype translate(String typeString) throws DataTypeSyntaxError {
        try {
            AstType type = new DataParser(new StringReader(typeString)).type();
            return this.add(null, type);
        }
        catch (ParseException e) {
            throw new DataTypeSyntaxError(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        DataTypePrinter printer = new DataTypePrinter(sb);
        printer.setLinedeed(true);
        for (Map.Entry<String, Datatype> e : this.dataTypes.entrySet()) {
            String name = e.getKey();
            Datatype type = e.getValue();
            sb.append("type ");
            sb.append(name);
            sb.append(" = ");
            printer.print(type);
            sb.append("\n");
        }
        return sb.toString();
    }
}

