/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.example.old;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Socket;
import java.util.Arrays;
import org.simantics.databoard.Methods;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.method.Client;
import org.simantics.databoard.method.MethodInterface;
import org.simantics.databoard.method.Server;
import org.simantics.databoard.method.TcpConnection;
import org.simantics.databoard.serialization.SerializationException;

public class RPCExample1 {
    public static void main(String[] args) throws IOException, BindingConstructionException, SerializationException, BindingException {
        CommandProcessor myProcessor = new CommandProcessor(){

            @Override
            public int helloWorld() {
                TcpConnection connection;
                TcpConnection interfaceToClient = connection = TcpConnection.getCurrentConnection();
                Socket socket = connection.getSocket();
                System.out.println("Hello " + socket.getRemoteSocketAddress());
                connection.addConnectionListener(new TcpConnection.ConnectionListener(){

                    @Override
                    public void onError(Exception error) {
                        System.out.println("Error: " + error.getMessage());
                    }

                    @Override
                    public void onClosed() {
                        TcpConnection connection = TcpConnection.getCurrentConnection();
                        Socket socket = connection.getSocket();
                        System.out.println("Bye bye " + socket.getRemoteSocketAddress());
                    }
                });
                return 0;
            }

            @Override
            public String execute(String command, String ... args) throws Error1 {
                if (!command.equals("start")) {
                    throw new Error1("Unknown command " + command);
                }
                return "Program started " + command + " with args " + Arrays.toString(args);
            }
        };
        MethodInterface myProcessorBinding = Methods.bindInterface(CommandProcessor.class, myProcessor);
        Server myServerSocket = new Server(8192, myProcessorBinding);
        Client myClientSocket = new Client(Inet4Address.getByName("localhost"), 8192);
        try {
            String result;
            CommandProcessor myClient = Methods.createProxy(CommandProcessor.class, myClientSocket);
            myClient.helloWorld();
            try {
                result = myClient.execute("start", new String[0]);
                System.out.println(result);
            }
            catch (Error1 e) {
                System.err.println(e);
            }
            try {
                result = myClient.execute("fault", new String[0]);
                System.out.println(result);
            }
            catch (Error1 e) {
                System.err.println(e);
            }
        }
        finally {
            myClientSocket.close();
            myServerSocket.close();
        }
    }

    public static interface CommandProcessor {
        public int helloWorld();

        public String execute(String var1, String ... var2) throws Error1;
    }

    public static class Error1
    extends Exception {
        private static final long serialVersionUID = 1L;
        public String msg;

        public Error1(String msg) {
            this.msg = msg;
        }

        @Override
        public String toString() {
            return this.msg;
        }
    }
}

