/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.example;

import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;

public class StringVariantBindingExample {
    public static void main(String[] args) throws Exception {
        String str = "Hello World";
        String escapedString = (String)Bindings.STR_VARIANT.create(Bindings.STRING, str);
        String unescapedString = (String)Bindings.STR_VARIANT.getContent(escapedString, Bindings.STRING);
        System.out.println("Unescaped String: " + unescapedString);
        System.out.println("Escaped String: " + escapedString);
        System.out.println();
        str = "http://www.simantics.org/path?query=value";
        escapedString = (String)Bindings.STR_VARIANT.create(Bindings.STRING, str);
        unescapedString = (String)Bindings.STR_VARIANT.getContent(escapedString, Bindings.STRING);
        System.out.println("Unescaped String: " + unescapedString);
        System.out.println("Escaped String: " + escapedString);
        System.out.println();
        Object value = 5;
        escapedString = (String)Bindings.STR_VARIANT.create(Bindings.INTEGER, value);
        Object unescapedObject = (Integer)Bindings.STR_VARIANT.getContent(escapedString, Bindings.INTEGER);
        System.out.println("Unescaped Object: " + unescapedObject);
        System.out.println("Escaped String: " + escapedString);
        System.out.println();
        value = new int[]{1, 2, 3, 4, 5, 6};
        escapedString = (String)Bindings.STR_VARIANT.create(Bindings.INTEGER, value);
        unescapedObject = (int[])Bindings.STR_VARIANT.getContent(escapedString, Bindings.INTEGER);
        System.out.println("Unescaped Object: " + Arrays.toString((int[])unescapedObject));
        System.out.println("Escaped String: " + escapedString);
        System.out.println();
        ArrayBinding binding1 = Bindings.INT_ARRAY;
        Object binding2 = Bindings.getBinding(Integer[].class);
        value = new int[]{1, 2, 3, 4, 5, 6};
        escapedString = (String)Bindings.STR_VARIANT.create(binding1, value);
        unescapedObject = (Integer[])Bindings.STR_VARIANT.getContent(escapedString, (Binding)binding2);
        System.out.println("Unescaped Object: " + Arrays.toString(unescapedObject));
        System.out.println("Escaped String: " + escapedString);
        System.out.println();
        Object rectangleBinding = Bindings.getBinding(Rectangle2D.Double.class);
        value = new Rectangle2D.Double(10.0, 10.0, 200.0, 200.0);
        escapedString = (String)Bindings.STR_VARIANT.create((Binding)rectangleBinding, value);
        unescapedObject = (Rectangle2D)Bindings.STR_VARIANT.getContent(escapedString, (Binding)rectangleBinding);
        System.out.println("Unescaped Object: " + unescapedObject);
        System.out.println("Escaped String: " + escapedString);
        System.out.println();
        value = "Some object";
        String stringVariant = (String)Bindings.adapt(value, Bindings.OBJECT, Bindings.STR_VARIANT);
        Object objectVariant = Bindings.adapt(stringVariant, Bindings.STR_VARIANT, Bindings.OBJECT);
        MutableVariant variantVariant = (MutableVariant)Bindings.adapt(stringVariant, Bindings.STR_VARIANT, Bindings.MUTABLE_VARIANT);
        System.out.println("Object Variant: " + objectVariant + " (" + objectVariant.getClass().getName() + ")");
        System.out.println("String Variant: " + stringVariant);
        System.out.println("Variant Variant: " + variantVariant);
        System.out.println();
    }
}

