/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.reflection;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.type.ArrayType;

public class GenericArrayBinding
extends ArrayBinding {
    Class<?> clazz;
    Class<?> componentClass;

    public GenericArrayBinding(Class<?> clazz, ArrayType type, Binding componentBinding) {
        super(type, componentBinding);
        this.clazz = clazz;
        this.type = type;
        this.componentClass = clazz.getComponentType();
    }

    @Override
    public Object create() {
        return Array.newInstance(this.componentClass, 0);
    }

    @Override
    public Object create(int length, Iterator<Object> values) {
        Object result = Array.newInstance(this.componentClass, length);
        int i = 0;
        while (i < length) {
            Array.set(result, i, values.next());
            ++i;
        }
        return result;
    }

    @Override
    public Object create(Object[] array) throws BindingException {
        int length = array.length;
        Object result = Array.newInstance(this.componentClass, length);
        System.arraycopy(array, 0, result, 0, length);
        return result;
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        try {
            ArrayBinding sb = (ArrayBinding)srcBinding;
            Binding scb = sb.getComponentBinding();
            Binding dcb = this.getComponentBinding();
            Adapter cloner = dcb.isImmutable() ? Bindings.adapterFactory.getAdapter(scb, dcb, false, true) : null;
            int length = Array.getLength(dst);
            if (length != sb.size(src)) {
                throw new BindingException(String.valueOf(this.clazz.getName()) + " is length immutable");
            }
            int i = 0;
            while (i < length) {
                if (dcb.isImmutable()) {
                    Object sc = sb.get(src, i);
                    Object dc = cloner.adapt(sc);
                    this.set(dst, i, dc);
                } else {
                    Object dc = Array.get(dst, i);
                    Object sc = sb.get(src, i);
                    dc = dcb.readFromTry(scb, sc, dc);
                    Array.set(dst, i, dc);
                }
                ++i;
            }
        }
        catch (AdaptException e) {
            throw new BindingException(e);
        }
        catch (AdapterConstructionException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public Object readFromTry(Binding srcBinding, Object src, Object dst) throws BindingException {
        try {
            ArrayBinding sb = (ArrayBinding)srcBinding;
            Binding scb = sb.getComponentBinding();
            Binding dcb = this.getComponentBinding();
            Adapter cloner = Bindings.adapterFactory.getAdapter(scb, dcb, false, true);
            int length = Array.getLength(dst);
            int srcSize = sb.size(src);
            Object d = dst;
            if (length != srcSize || dcb.isImmutable()) {
                d = Array.newInstance(this.componentClass, srcSize);
                if (dcb.isImmutable()) {
                    int i = 0;
                    while (i < srcSize) {
                        Object sc = sb.get(src, i);
                        Object dc = cloner.adapt(sc);
                        this.set(d, i, dc);
                        ++i;
                    }
                } else {
                    int X2 = Math.min(Array.getLength(dst), srcSize);
                    int i = 0;
                    while (i < X2) {
                        Object dc = Array.get(dst, i);
                        Object sc = sb.get(src, i);
                        dc = dcb.readFromTry(scb, sc, dc);
                        Array.set(d, i, dc);
                        ++i;
                    }
                    i = X2;
                    while (i < srcSize) {
                        Object sc = sb.get(src, i);
                        Object dc = cloner.adapt(sc);
                        this.set(d, i, dc);
                        ++i;
                    }
                }
            } else if (dcb.isImmutable()) {
                int i = 0;
                while (i < length) {
                    Object sc = sb.get(src, i);
                    Object dc = cloner.adapt(sc);
                    this.set(d, i, dc);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < length) {
                    Object dc = Array.get(dst, i);
                    Object sc = sb.get(src, i);
                    dc = dcb.readFromTry(scb, sc, dc);
                    Array.set(d, i, dc);
                    ++i;
                }
            }
            return d;
        }
        catch (AdaptException e) {
            throw new BindingException(e);
        }
        catch (AdapterConstructionException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public Object get(Object array, int index) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", " + this.clazz.getSimpleName() + " expected");
        }
        return Array.get(array, index);
    }

    @Override
    public void getAll(Object array, Object[] result) throws BindingException {
        int length = Array.getLength(array);
        System.arraycopy(array, 0, result, 0, length);
    }

    @Override
    public void set(Object array, int index, Object value) throws BindingException {
        if (index < 0 || index > Array.getLength(array)) {
            throw new BindingException("Index out of bounds");
        }
        Array.set(array, index, value);
    }

    @Override
    public int size(Object array) throws BindingException {
        if (!this.isInstance(array)) {
            if (array == null) {
                throw new BindingException("Tried to calculate the size of a null array.");
            }
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", " + this.clazz.getSimpleName() + " expected");
        }
        return Array.getLength(array);
    }

    @Override
    public boolean isInstance(Object obj) {
        return this.clazz.isInstance(obj);
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public void add(Object array, int index, Object element) throws BindingException, IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Object array, int index, int count) throws BindingException, IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSize(Object array, int newSize) throws BindingException {
        int oldSize = Array.getLength(array);
        if (oldSize == newSize) {
            return;
        }
        throw new BindingException(String.valueOf(this.clazz.getName()) + " is length immutable");
    }

    @Override
    public boolean isResizable() {
        return false;
    }
}

