/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.lang.reflect.Array;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.binding.impl.IntegerBindingDefault;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.util.IdentityPair;

public final class IntArrayBinding
extends ArrayBinding {
    public static IntArrayBinding createFrom(ArrayType type) {
        return new IntArrayBinding(type, new IntegerBindingDefault((IntegerType)type.componentType));
    }

    public IntArrayBinding(ArrayType type, Binding componentBinding) {
        super(type, componentBinding);
    }

    @Override
    public Object create() {
        return new int[0];
    }

    @Override
    public Object create(int length, Iterator<Object> values) {
        int[] array = new int[length];
        int i = 0;
        while (i < length) {
            array[i] = (Integer)values.next();
            ++i;
        }
        return array;
    }

    @Override
    public Object create(Object[] values) {
        int[] result = new int[values.length];
        int i = 0;
        while (i < values.length) {
            result[i] = (Integer)values[i];
            ++i;
        }
        return result;
    }

    public Object create(int[] array) {
        return array;
    }

    @Override
    public Object createDefault() throws BindingException {
        NumberType nt = (NumberType)this.type().componentType;
        if (nt.getRange() == null) {
            return new int[this.type().minLength()];
        }
        return super.createDefault();
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        ArrayBinding sb = (ArrayBinding)srcBinding;
        IntegerBinding scb = (IntegerBinding)sb.getComponentBinding();
        int[] d = (int[])dst;
        if (d.length != sb.size(src)) {
            throw new BindingException("int[] is length immutable");
        }
        int i = 0;
        while (i < d.length) {
            d[i] = scb.getValue_(sb.get(src, i));
            ++i;
        }
    }

    @Override
    public Object readFromTry(Binding srcBinding, Object src, Object dst) throws BindingException {
        ArrayBinding sb = (ArrayBinding)srcBinding;
        IntegerBinding scb = (IntegerBinding)sb.getComponentBinding();
        int[] d = (int[])dst;
        int srcSize = sb.size(src);
        if (d.length != srcSize) {
            d = new int[srcSize];
        }
        int i = 0;
        while (i < d.length) {
            d[i] = scb.getValue_(sb.get(src, i));
            ++i;
        }
        return d;
    }

    @Override
    public Object get(Object array, int index) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", int[] expected");
        }
        return ((int[])array)[index];
    }

    @Override
    public void getAll(Object array, Object[] result) throws BindingException {
        int[] a = (int[])array;
        int i = 0;
        while (i < a.length) {
            result[i] = a[i];
            ++i;
        }
    }

    @Override
    public void set(Object array, int index, Object value) throws BindingException {
        int[] a = (int[])array;
        a[index] = (Integer)value;
    }

    @Override
    public int size(Object array) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", int[] expected");
        }
        return ((int[])array).length;
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof int[];
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    public int[] getArray(Object array) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", int[] expected");
        }
        return (int[])array;
    }

    @Override
    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        int result = 1;
        int[] array = (int[])value;
        int i = 0;
        while (i < array.length) {
            result = 31 * result + array[i];
            ++i;
        }
        return result;
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        int[] i1 = (int[])o1;
        int l1 = i1.length;
        int[] i2 = (int[])o2;
        int l2 = i2.length;
        int dif = l1 - l2;
        if (dif != 0) {
            return dif;
        }
        int i = 0;
        while (i < l1) {
            int v1 = i1[i];
            int v2 = i2[i];
            int n = v1 < v2 ? -1 : (dif = v1 == v2 ? 0 : 1);
            if (dif != 0) {
                return dif;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public void add(Object array, int index, Object element) throws BindingException, IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Object array, int index, int count) throws BindingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSize(Object array, int newSize) throws BindingException {
        int oldSize = Array.getLength(array);
        if (oldSize == newSize) {
            return;
        }
        throw new BindingException("int[] is length immutable");
    }

    @Override
    public boolean isResizable() {
        return false;
    }
}

