/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.reflection.VoidBinding;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.RecordType;

public class HashSetBinding
extends MapBinding {
    public HashSetBinding(MapType mapType, Binding elementBinding) {
        super(mapType, elementBinding, VoidBinding.VOID_BINDING);
    }

    public HashSetBinding(Binding elementBinding) {
        super(new MapType(elementBinding.type(), RecordType.VOID_TYPE), elementBinding, VoidBinding.VOID_BINDING);
    }

    @Override
    public void clear(Object set) throws BindingException {
        Set _set = (Set)set;
        _set.clear();
    }

    @Override
    public boolean containsKey(Object set, Object key) throws BindingException {
        Set s = (Set)set;
        Binding kb = this.getKeyBinding();
        for (Object v : s) {
            if (!kb.equals(v, key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object set, Object value) throws BindingException {
        return false;
    }

    @Override
    public Object create() throws BindingException {
        return new HashSet();
    }

    public Object create(Set<?> initialSet) throws BindingException {
        return new HashSet(initialSet);
    }

    public Object create(Map initialMap) throws BindingException {
        return new HashSet(initialMap.keySet());
    }

    @Override
    public Object create(Object[] keys, Object[] values) throws BindingException {
        HashSet<Object> result = new HashSet<Object>(keys.length);
        int i = 0;
        while (i < keys.length) {
            result.add(keys[i]);
            ++i;
        }
        return result;
    }

    @Override
    public Object create(List<Object> keys, List<Object> values) {
        HashSet<Object> result = new HashSet<Object>(keys.size());
        int i = 0;
        while (i < keys.size()) {
            result.add(keys.get(i));
            ++i;
        }
        return result;
    }

    @Override
    public Object get(Object set, Object key) throws BindingException {
        return null;
    }

    public void getAll(Object setFrom, Map to) throws BindingException {
        Map _to = to;
        HashSet _setFrom = (HashSet)setFrom;
        for (Object k : _setFrom) {
            _to.put(k, null);
        }
    }

    @Override
    public void getAll(Object setFrom, Object[] keys, Object[] values) throws BindingException {
        Set _setFrom = (Set)setFrom;
        int i = 0;
        for (Object k : _setFrom) {
            keys[i] = k;
            values[i] = null;
        }
    }

    @Override
    public Object[] getKeys(Object set) throws BindingException {
        Set _set = (Set)set;
        Object[] result = _set.toArray(new Object[_set.size()]);
        Arrays.sort(result, this.getKeyBinding());
        return result;
    }

    public void getKeys(Object set, Set keys) throws BindingException {
        Set s = (Set)set;
        keys.addAll(s);
    }

    @Override
    public int count(Object src, Object from, boolean fromInclusive, Object end, boolean endInclusive) throws BindingException {
        int result = 0;
        Set m = (Set)src;
        for (Object k : m) {
            boolean endMatches;
            boolean fromMatches;
            int fk = this.keyBinding.compare(from, k);
            int ek = this.keyBinding.compare(k, end);
            boolean bl = fromInclusive ? fk <= 0 : (fromMatches = fk < 0);
            boolean bl2 = endInclusive ? ek <= 0 : (endMatches = ek < 0);
            if (!fromMatches || !endMatches) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int getEntries(Object src, Object from, boolean fromInclusive, Object end, boolean endInclusive, ArrayBinding dstKeyArrayBinding, Object dstKeyArray, ArrayBinding dstValueArrayBinding, Object dstValueArray, int limit) throws BindingException {
        return 0;
    }

    @Override
    public Object[] getValues(Object set) throws BindingException {
        Set _set = (Set)set;
        return new Object[_set.size()];
    }

    public void put(Object set, Object key, Object value) throws BindingException {
        if (value != null) {
            throw new BindingException("Cannot put non-null to a Set");
        }
        Set s = (Set)set;
        Binding kb = this.getKeyBinding();
        for (Object e : s) {
            if (!kb.equals(e, key)) continue;
            s.remove(e);
            s.add(value);
            return;
        }
        s.add(key);
    }

    Object getComparableKey(Object set, Object key) {
        Set s = (Set)set;
        Binding kb = this.getKeyBinding();
        for (Object k : s) {
            if (!kb.equals(k, key)) continue;
            return k;
        }
        return key;
    }

    public void putAll(Object setTo, Set from) {
        Set _set = (Set)setTo;
        _set.addAll(from);
    }

    public void putAll(Object setTo, Map from) throws BindingException {
        Set s = (Set)setTo;
        Binding kb = this.getKeyBinding();
        for (Map.Entry e : from.entrySet()) {
            Object k = this.getComparableKey(s, e.getKey());
            s.remove(k);
            s.add(e.getKey());
        }
    }

    @Override
    public Object remove(Object set, Object key) throws BindingException {
        Set _set = (Set)set;
        _set.remove(key);
        return null;
    }

    @Override
    public int size(Object set) throws BindingException {
        Set _set = (Set)set;
        return _set.size();
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof Set;
    }

    @Override
    public Object getCeilingKey(Object set, Object key) {
        Set s = (Set)set;
        if (s.isEmpty()) {
            return null;
        }
        Binding comparator = this.getKeyBinding();
        Object pivot = null;
        for (Object o : s) {
            int c2 = comparator.compare(key, o);
            if (c2 > 0) continue;
            if (pivot == null) {
                pivot = o;
                continue;
            }
            int c1 = comparator.compare(o, pivot);
            if (c1 >= 0) continue;
            pivot = o;
        }
        return pivot;
    }

    @Override
    public Object getFirstKey(Object set) {
        Set s = (Set)set;
        if (s.isEmpty()) {
            return null;
        }
        Binding c = this.getKeyBinding();
        Object result = null;
        for (Object o : s) {
            if (result == null) {
                result = o;
                continue;
            }
            if (c.compare(o, result) >= 0) continue;
            result = o;
        }
        return result;
    }

    @Override
    public Object getFloorKey(Object set, Object key) {
        Set s = (Set)set;
        if (s.isEmpty()) {
            return null;
        }
        Binding comparator = this.getKeyBinding();
        Object pivot = null;
        for (Object o : s) {
            int c2 = comparator.compare(o, key);
            if (c2 == 0) {
                return o;
            }
            if (c2 > 0) continue;
            if (pivot == null) {
                pivot = o;
                continue;
            }
            int c1 = comparator.compare(pivot, o);
            if (c1 >= 0) continue;
            pivot = o;
        }
        return pivot;
    }

    @Override
    public Object getHigherKey(Object set, Object key) {
        Set s = (Set)set;
        if (s.isEmpty()) {
            return null;
        }
        Binding comparator = this.getKeyBinding();
        Object pivot = null;
        for (Object o : s) {
            int c2 = comparator.compare(key, o);
            if (c2 >= 0) continue;
            if (pivot == null) {
                pivot = o;
                continue;
            }
            int c1 = comparator.compare(o, pivot);
            if (c1 >= 0) continue;
            pivot = o;
        }
        return pivot;
    }

    @Override
    public Object getLastKey(Object set) {
        Set s = (Set)set;
        if (s.isEmpty()) {
            return null;
        }
        Binding c = this.getKeyBinding();
        Object result = null;
        for (Object o : s) {
            if (result == null) {
                result = o;
                continue;
            }
            if (c.compare(o, result) <= 0) continue;
            result = o;
        }
        return result;
    }

    @Override
    public Object getLowerKey(Object set, Object key) {
        Set s = (Set)set;
        if (s.isEmpty()) {
            return null;
        }
        Binding comparator = this.getKeyBinding();
        Object pivot = null;
        for (Object o : s) {
            int c2 = comparator.compare(o, key);
            if (c2 >= 0) continue;
            if (pivot == null) {
                pivot = o;
                continue;
            }
            int c1 = comparator.compare(pivot, o);
            if (c1 >= 0) continue;
            pivot = o;
        }
        return pivot;
    }
}

