/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.type.DoubleType;

public class DoubleBindingDefault
extends DoubleBinding {
    public DoubleBindingDefault(DoubleType type) {
        super(type);
    }

    @Override
    public DoubleType type() {
        return (DoubleType)this.type;
    }

    @Override
    public Object create(Double value) {
        return value;
    }

    @Override
    public Object create(double value) {
        return value;
    }

    @Override
    public Object create(Number value) {
        if (value.getClass() == Double.class) {
            return value;
        }
        return value.doubleValue();
    }

    @Override
    public Object create(String value) {
        return Double.parseDouble(value);
    }

    @Override
    public Double getValue(Object o) throws BindingException {
        if (o.getClass() != Double.class) {
            throw new BindingException("Unexpected class " + o.getClass().getSimpleName() + ", Double expected");
        }
        return (Double)o;
    }

    @Override
    public double getValue_(Object o) throws BindingException {
        if (o.getClass() != Double.class) {
            throw new BindingException("Unexpected class " + o.getClass().getSimpleName() + ", Double expected");
        }
        return (Double)o;
    }

    @Override
    public void setValue(Object obj, Number value) throws BindingException {
        throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Double");
    }

    @Override
    public void setValue(Object obj, double value) throws BindingException {
        throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Double");
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof Double;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public int compare(Object o1, Object o2) {
        Double d1 = (Double)o1;
        Double d2 = (Double)o2;
        return d1.compareTo(d2);
    }
}

