/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.java;

import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.ArrayElementAdded;
import org.simantics.databoard.accessor.event.ArrayElementRemoved;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ModificationEvent;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.ArrayInterestSet;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.java.JavaObject;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.type.ArrayType;

public class JavaArray
extends JavaObject
implements ArrayAccessor,
StreamAccessor {
    TreeMap<Integer, SoftReference<JavaObject>> children = new TreeMap();

    public JavaArray(Accessor parent, ArrayBinding binding, Object object, AccessorParams params) {
        super(parent, binding, object, params);
    }

    @Override
    public ArrayBinding getBinding() {
        return (ArrayBinding)this.binding;
    }

    @Override
    public ArrayType type() {
        return this.getBinding().type();
    }

    @Override
    public void add(Binding binding, Object value) throws AccessorException {
        this.add(this.size(), binding, value);
    }

    @Override
    public void addAll(Binding binding, Object[] values) throws AccessorException {
        this.addAll(this.size(), binding, values);
    }

    @Override
    public void add(int index, Binding binding, Object value) throws AccessorException {
        this.writeLock();
        try {
            try {
                boolean lastEntry = index == this.size();
                Binding rcb = binding;
                Binding lcb = this.getBinding().getComponentBinding();
                Object rcv = value;
                Object lcv = this.params.adapterScheme.clone(rcv, rcb, lcb);
                this.getBinding().add(this.object, index, lcv);
                if (!lastEntry && !this.children.isEmpty()) {
                    Integer key = this.children.lastKey();
                    while (key != null && key >= index) {
                        SoftReference<JavaObject> v = this.children.remove(key);
                        if (v.get() != null) {
                            this.children.put(key + 1, v);
                        }
                        key = this.children.lowerKey(key);
                    }
                }
                ListenerEntry le = this.listeners;
                while (le != null) {
                    ArrayInterestSet is = (ArrayInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        MutableVariant newValue = null;
                        if (is.inValues()) {
                            newValue = new MutableVariant(lcb, lcb.isImmutable() ? lcv : lcb.clone(lcv));
                        }
                        ArrayElementAdded e = new ArrayElementAdded(index, newValue);
                        this.emitEvent(le, e);
                    }
                    if (is.componentInterests != null) {
                        Map<Integer, InterestSet> oldCis = is.componentInterests;
                        boolean needUpdates = false;
                        for (Integer i : oldCis.keySet()) {
                            if (needUpdates |= i >= index) break;
                        }
                        if (needUpdates) {
                            HashMap<Integer, InterestSet> newCis = new HashMap<Integer, InterestSet>(oldCis.size());
                            Iterator<Integer> iterator = oldCis.keySet().iterator();
                            while (iterator.hasNext()) {
                                Integer i;
                                Integer oldKey = i = iterator.next();
                                Integer newKey = i >= index ? i + 1 : i;
                                InterestSet oldValue = oldCis.get(oldKey);
                                newCis.put(newKey, oldValue);
                            }
                            is.componentInterests = newCis;
                        }
                    }
                    le = le.next;
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void addAll(int index, Binding binding, Object[] values) throws AccessorException {
        this.writeLock();
        try {
            try {
                int oldCount = this.size();
                int count = values.length;
                Binding rcb = binding;
                Binding lcb = this.getBinding().getComponentBinding();
                boolean lastEntry = index == oldCount;
                int i = 0;
                while (i < values.length) {
                    Object rcv = values[i];
                    Object lcv = this.params.adapterScheme.clone(rcv, rcb, lcb);
                    this.getBinding().add(this.object, i + index, lcv);
                    ++i;
                }
                if (!lastEntry && !this.children.isEmpty()) {
                    Integer key = this.children.lastKey();
                    while (key != null && key >= index) {
                        SoftReference<JavaObject> value = this.children.remove(key);
                        if (value.get() != null) {
                            this.children.put(key + values.length, value);
                        }
                        key = this.children.lowerKey(key);
                    }
                }
                ListenerEntry le = this.listeners;
                while (le != null) {
                    ArrayInterestSet is = (ArrayInterestSet)le.getInterestSet();
                    if (is.componentInterests != null) {
                        Map<Integer, InterestSet> oldCis = is.componentInterests;
                        boolean needUpdates = false;
                        for (Integer i2 : oldCis.keySet()) {
                            if (needUpdates |= i2 >= index) break;
                        }
                        if (needUpdates) {
                            HashMap<Integer, InterestSet> newCis = new HashMap<Integer, InterestSet>(oldCis.size());
                            Iterator<Integer> iterator = oldCis.keySet().iterator();
                            while (iterator.hasNext()) {
                                Integer i3;
                                Integer oldKey = i3 = iterator.next();
                                Integer newKey = i3 >= index ? i3 + count : i3;
                                InterestSet oldValue = oldCis.get(oldKey);
                                newCis.put(newKey, oldValue);
                            }
                            is.componentInterests = newCis;
                        }
                    }
                    le = le.next;
                }
                if (this.listeners != null) {
                    i = 0;
                    while (i < values.length) {
                        Object lcv = this.getBinding().get(this.object, i + index);
                        ListenerEntry le2 = this.listeners;
                        while (le2 != null) {
                            ArrayInterestSet is = (ArrayInterestSet)le2.getInterestSet();
                            if (!is.inNotifications()) continue;
                            MutableVariant newValue = null;
                            if (is.inValues()) {
                                newValue = new MutableVariant(lcb, lcb.isImmutable() ? lcv : lcb.clone(lcv));
                            }
                            ArrayElementAdded e = new ArrayElementAdded(i + index, newValue);
                            this.emitEvent(le2, e);
                        }
                        ++i;
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        if (reference instanceof LabelReference) {
            LabelReference lr = (LabelReference)reference;
            try {
                Integer index = new Integer(lr.label);
                T result = this.getAccessor(index);
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                return result;
            }
            catch (NumberFormatException nfe) {
                throw new ReferenceException(nfe);
            }
        }
        if (reference instanceof IndexReference) {
            IndexReference ref = (IndexReference)reference;
            int index = ref.getIndex();
            T result = this.getAccessor(index);
            if (reference.getChildReference() != null) {
                result = result.getComponent(reference.getChildReference());
            }
            return result;
        }
        throw new ReferenceException(String.valueOf(reference.getClass().getName()) + " is not a reference of an array");
    }

    @Override
    public <T extends Accessor> T getAccessor(int index) throws AccessorConstructionException {
        try {
            int size = this.getBinding().size(this.object);
            if (index < 0 || index >= size) {
                throw new ReferenceException("Element index (" + index + ") out of bounds (" + size + ")");
            }
            JavaObject sa = this.getExistingAccessor(index);
            if (sa == null) {
                this.readLock();
                try {
                    Binding cb = this.getBinding().getComponentBinding();
                    Object cv = this.getBinding().get(this.object, index);
                    sa = JavaArray.createSubAccessor(this, cb, cv, this.params);
                    sa.keyInParent = index;
                    this.children.put(index, new SoftReference<JavaObject>(sa));
                    ListenerEntry le = this.listeners;
                    while (le != null) {
                        InterestSet cis;
                        ArrayInterestSet is = (ArrayInterestSet)le.getInterestSet();
                        InterestSet gis = is.getComponentInterest();
                        if (gis != null) {
                            try {
                                ChildReference childPath = ChildReference.concatenate(le.path, new IndexReference(index));
                                sa.addListener(le.listener, gis, childPath, le.executor);
                            }
                            catch (AccessorException e) {
                                throw new AccessorConstructionException(e);
                            }
                        }
                        if ((cis = is.getComponentInterest(index)) != null) {
                            try {
                                ChildReference childPath = ChildReference.concatenate(le.path, new IndexReference(index));
                                sa.addListener(le.listener, cis, childPath, le.executor);
                            }
                            catch (AccessorException e) {
                                throw new AccessorConstructionException(e);
                            }
                        }
                        le = le.next;
                    }
                }
                finally {
                    this.readUnlock();
                }
            }
            return (T)sa;
        }
        catch (BindingException e) {
            throw new AccessorConstructionException(e);
        }
    }

    JavaObject getExistingAccessor(int index) {
        SoftReference<JavaObject> ref = this.children.get(index);
        if (ref == null) {
            return null;
        }
        JavaObject res = ref.get();
        return res;
    }

    @Override
    public void getAll(Binding valueBinding, Collection<Object> values) throws AccessorException {
        this.readLock();
        try {
            try {
                Adapter adapter = this.params.adapterScheme.getAdapter(this.getBinding().getComponentBinding(), valueBinding, true, true);
                int i = 0;
                while (i < this.size()) {
                    Object o = this.getBinding().get(this.object, i);
                    values.add(adapter.adapt(o));
                    ++i;
                }
            }
            catch (AdapterConstructionException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void getAll(Binding valueBinding, Object[] array) throws AccessorException {
        this.readLock();
        try {
            try {
                Adapter adapter = this.params.adapterScheme.getAdapter(this.getBinding().getComponentBinding(), valueBinding, true, true);
                int i = 0;
                while (i < this.size()) {
                    Object o = this.getBinding().get(this.object, i);
                    array[i] = adapter.adapt(o);
                    ++i;
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (AdapterConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object get(int index, Binding valueBinding) throws AccessorException {
        this.readLock();
        try {
            Adapter adapter = this.params.adapterScheme.getAdapter(this.getBinding().getComponentBinding(), valueBinding, true, true);
            Object o = this.getBinding().get(this.object, index);
            Object object = o = adapter.adapt(o);
            return object;
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void get(int index, Binding valueBinding, Object dst) throws AccessorException {
        this.readLock();
        try {
            try {
                Binding scb = this.getBinding().getComponentBinding();
                Object sv = this.getBinding().get(this.object, index);
                valueBinding.readFrom(scb, sv, dst);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void remove(int index, int count) throws AccessorException {
        if (index < 0 || index + count > this.size()) {
            throw new AccessorException("Index out of bounds");
        }
        this.writeLock();
        try {
            try {
                boolean lastEntry = index == this.size() - count;
                this.getBinding().remove(this.object, index, count);
                JavaObject sa = this.getExistingAccessor(index);
                if (sa != null) {
                    sa.invalidatedNotification();
                    this.children.remove(index);
                    sa = null;
                }
                NavigableMap<Integer, SoftReference<JavaObject>> sm = this.children.subMap(index, true, index + count, false);
                for (Map.Entry e : sm.entrySet()) {
                    JavaObject bo = (JavaObject)((SoftReference)e.getValue()).get();
                    if (bo == null) continue;
                    bo.invalidatedNotification();
                }
                sm.clear();
                if (!lastEntry && !this.children.isEmpty()) {
                    Integer lastKey = this.children.lastKey();
                    Integer key = this.children.higherKey(index);
                    while (key != null && key <= lastKey) {
                        SoftReference<JavaObject> value = this.children.remove(key);
                        if (value.get() != null) {
                            this.children.put(key - count, value);
                        }
                        key = this.children.higherKey(key);
                    }
                }
                ListenerEntry le = this.listeners;
                while (le != null) {
                    ArrayInterestSet is = (ArrayInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        int i = 0;
                        while (i < count) {
                            ArrayElementRemoved e = new ArrayElementRemoved(index);
                            this.emitEvent(le, e);
                            ++i;
                        }
                    }
                    if (is.componentInterests != null) {
                        Map<Integer, InterestSet> oldCis = is.componentInterests;
                        boolean needUpdates = false;
                        for (Integer interestIndex : oldCis.keySet()) {
                            if (needUpdates |= interestIndex >= index) break;
                        }
                        if (needUpdates) {
                            HashMap<Integer, InterestSet> newCis = new HashMap<Integer, InterestSet>(oldCis.size());
                            for (Integer interestIndex : oldCis.keySet()) {
                                if (interestIndex >= index && interestIndex < index + count) continue;
                                Integer oldKey = interestIndex;
                                Integer newKey = interestIndex >= index ? interestIndex + count : interestIndex;
                                InterestSet oldValue = oldCis.get(oldKey);
                                newCis.put(newKey, oldValue);
                            }
                            is.componentInterests = newCis;
                        }
                    }
                    le = le.next;
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void set(int index, Binding binding, Object value) throws AccessorException {
        if (index < 0 || index >= this.size()) {
            throw new AccessorException("Index out of bounds");
        }
        this.writeLock();
        try {
            JavaObject sa = this.getExistingAccessor(index);
            if (sa != null) {
                sa.setValue(binding, value);
                return;
            }
            try {
                Binding lcb = this.getBinding().getComponentBinding();
                Binding rcb = binding;
                Object rcv = value;
                Object lcv = this.params.adapterScheme.clone(rcv, rcb, lcb);
                this.getBinding().set(this.object, index, lcv);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    ArrayInterestSet is = (ArrayInterestSet)le.getInterestSet();
                    if (is.inNotificationsOf(index)) {
                        MutableVariant newValue = null;
                        if (is.inValues()) {
                            newValue = new MutableVariant(lcb, lcb.isImmutable() ? lcv : lcb.clone(lcv));
                        }
                        ValueAssigned e = new ValueAssigned(new IndexReference(index), newValue);
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setValue(Binding arrayBinding, Object newArray) throws AccessorException {
        this.writeLock();
        try {
            try {
                Object elementValue;
                ArrayBinding ab = (ArrayBinding)arrayBinding;
                int newLength = ab.size(newArray);
                int oldLength = this.size();
                int commonLength = Math.min(newLength, oldLength);
                Binding cb = ab.getComponentBinding();
                int i = 0;
                while (i < commonLength) {
                    elementValue = ab.get(newArray, i);
                    this.set(i, cb, elementValue);
                    ++i;
                }
                if (newLength > oldLength) {
                    i = oldLength;
                    while (i < newLength) {
                        elementValue = ab.get(newArray, i);
                        this.add(cb, elementValue);
                        ++i;
                    }
                } else if (newLength < oldLength) {
                    this.remove(newLength, oldLength - newLength);
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setSize(int newSize) throws AccessorException {
        if (newSize < 0) {
            throw new AccessorException("Index out of bounds");
        }
        this.writeLock();
        try {
            try {
                int oldSize = this.getBinding().size(this.object);
                if (newSize > oldSize) {
                    Binding c = this.getBinding().getComponentBinding();
                    int count = newSize - oldSize;
                    Object[] arr = new Object[count];
                    int i = 0;
                    while (i < count) {
                        arr[i] = c.createDefault();
                        ++i;
                    }
                    this.addAll(oldSize, c, arr);
                }
                if (newSize < oldSize) {
                    this.remove(newSize, oldSize - newSize);
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public int size() throws AccessorException {
        this.readLock();
        try {
            int n = this.getBinding().size(this.object);
            return n;
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) throws AccessorException {
        super.addListener(listener, interestSet, path, executor);
        ArrayInterestSet is = (ArrayInterestSet)interestSet;
        for (Integer index : this.children.keySet()) {
            ChildReference childPath;
            JavaObject sa = this.getExistingAccessor(index);
            if (sa == null) continue;
            InterestSet cis = is.getComponentInterest();
            if (cis != null) {
                childPath = ChildReference.concatenate(path, new IndexReference(index));
                sa.addListener(listener, cis, childPath, executor);
            }
            if ((cis = is.getComponentInterest(index)) == null) continue;
            childPath = ChildReference.concatenate(path, new IndexReference(index));
            sa.addListener(listener, cis, childPath, executor);
        }
    }

    @Override
    public void removeListener(Accessor.Listener listener) throws AccessorException {
        ListenerEntry e = this.detachListener(listener);
        if (e == null) {
            return;
        }
        ArrayInterestSet is = (ArrayInterestSet)e.interestSet;
        for (Integer index : this.children.keySet()) {
            JavaObject sa = this.getExistingAccessor(index);
            if (sa == null) continue;
            InterestSet cis = is.getComponentInterest();
            if (cis != null) {
                sa.removeListener(listener);
            }
            if ((cis = is.getComponentInterest(index)) == null) continue;
            sa.removeListener(listener);
        }
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        try {
            ModificationEvent rollback = null;
            if (e instanceof ValueAssigned) {
                ValueAssigned va = (ValueAssigned)e;
                if (makeRollback) {
                    rollback = new ValueAssigned(this.getBinding(), this.getValue(this.getBinding()));
                }
                this.setValue(va.newValue.getBinding(), va.newValue.getValue());
            } else if (e instanceof ArrayElementAdded) {
                ArrayElementAdded aa = (ArrayElementAdded)e;
                this.add(aa.index, aa.value.getBinding(), aa.value.getValue());
                if (makeRollback) {
                    rollback = new ArrayElementRemoved(aa.index);
                }
            } else if (e instanceof ArrayElementRemoved) {
                ArrayElementRemoved ar = (ArrayElementRemoved)e;
                if (ar.index < 0 || ar.index >= this.size()) {
                    throw new AccessorException("Array index out of bounds");
                }
                if (makeRollback) {
                    Binding cb = this.getBinding().getComponentBinding();
                    Object cv = this.getBinding().get(this.object, ar.index);
                    if (!cb.isImmutable()) {
                        cv = cb.clone(cv);
                    }
                    rollback = new ArrayElementAdded(ar.index, new MutableVariant(cb, cv));
                }
                this.remove(ar.index, 1);
            } else {
                throw new AccessorException("Cannot apply " + e.getClass().getName() + " to Array");
            }
            return rollback;
        }
        catch (BindingException be) {
            throw new AccessorException(be);
        }
        catch (AdaptException ae) {
            throw new AccessorException(ae);
        }
    }

    @Override
    public void flush() throws AccessorException {
    }

    @Override
    public void close() throws AccessorException {
    }

    @Override
    public void reset() throws AccessorException {
    }

    @Override
    public void addNoflush(Binding binding, Object value) throws AccessorException {
        this.add(binding, value);
    }

    @Override
    public void addAllNoflush(Binding binding, Object[] values) throws AccessorException {
        this.addAll(binding, values);
    }

    @Override
    public void addAllNoflush(int index, Binding binding, Object[] values) throws AccessorException {
        this.addAll(index, binding, values);
    }

    @Override
    public void addNoflush(int index, Binding binding, Object value) throws AccessorException {
        this.add(index, binding, value);
    }

    @Override
    public void setValueNoflush(Binding binding, Object newValue) throws AccessorException {
        this.setValue(binding, newValue);
    }

    @Override
    public void setNoflush(int index, Binding binding, Object value) throws AccessorException {
        this.set(index, binding, value);
    }

    @Override
    public void removeNoflush(int index, int count) throws AccessorException {
        this.remove(index, count);
    }

    @Override
    public void setSizeNoflush(int newSize) throws AccessorException {
        this.setSize(newSize);
    }

    @Override
    public File file() {
        return null;
    }
}

