/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.binary;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.binary.BinaryObject;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.file.FileRecordAccessor;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.interestset.RecordInterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.binary.Blob;
import org.simantics.databoard.util.binary.RandomAccessBinary;

public class BinaryRecord
extends BinaryObject
implements RecordAccessor,
FileRecordAccessor {
    Reference<BinaryObject>[] children;
    RecordBinding binding;

    public BinaryRecord(BinaryObject parent, Blob blob, RecordType type, AccessorParams params) throws AccessorConstructionException {
        super(parent, blob, type, params);
        if (type.isReferable()) {
            throw new AccessorConstructionException("Refereable record are not supported");
        }
        try {
            this.binding = (RecordBinding)params.bindingScheme.getBinding(type);
        }
        catch (BindingConstructionException e) {
            throw new AccessorConstructionException(e);
        }
        int count = type.getComponentCount();
        this.children = new Reference[count];
    }

    @Override
    public RecordType type() {
        return (RecordType)this.type;
    }

    @Override
    public int count() {
        return this.type().getComponentCount();
    }

    long getStartPosition(int fieldIndex) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            BinaryObject sa = this.getExistingAccessor(fieldIndex);
            if (sa != null) {
                long l = sa.b.getStartPositionInSourceBinary();
                return l;
            }
            int saIndex = -1;
            int i = fieldIndex;
            while (i >= 0) {
                sa = this.getExistingAccessor(i);
                if (sa != null) {
                    saIndex = i;
                    break;
                }
                --i;
            }
            long pos = saIndex == -1 ? 0L : sa.b.getStartPositionInSourceBinary();
            this.b.position(pos);
            if (saIndex < 0) {
                saIndex = 0;
            }
            int i2 = saIndex;
            while (i2 < fieldIndex) {
                Binding cb = this.binding.getComponentBinding(i2);
                Serializer cs = this.params.serializerScheme.getSerializer(cb);
                cs.skip(this.b);
                ++i2;
            }
            long l = this.b.position();
            return l;
        }
        catch (IOException ioe) {
            throw new AccessorException(ioe);
        }
        catch (SerializerConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public <T extends Accessor> T getFieldAccessor(String fieldName) throws AccessorConstructionException {
        int fieldIndex = this.type().getComponentIndex(fieldName);
        if (fieldIndex < 0) {
            throw new AccessorConstructionException("Field " + fieldName + " does not exist");
        }
        return this.getFieldAccessor(fieldIndex);
    }

    @Override
    public <T extends Accessor> T getFieldAccessor(int index) throws AccessorConstructionException {
        if (index < 0 || index >= this.count()) {
            throw new ReferenceException("Field index (" + index + ") out of bounds (" + this.count() + ")");
        }
        assert (this.b.isOpen());
        this.readLock();
        try {
            BinaryObject sa;
            Reference<BinaryObject> ref = this.children[index];
            BinaryObject binaryObject = sa = ref != null ? ref.get() : null;
            if (sa == null) {
                Binding cb = this.binding.getComponentBinding(index);
                Serializer cs = this.params.serializerScheme.getSerializer(cb);
                long pos = this.getStartPosition(index);
                this.b.position(pos);
                cs.skip(this.b);
                long len = this.b.position() - pos;
                sa = this.createSubAccessor(cb.type(), pos, len, this.params);
                this.children[index] = new SoftReference<BinaryObject>(sa);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    RecordInterestSet is = (RecordInterestSet)le.getInterestSet();
                    InterestSet cis = is.getComponentInterest(index);
                    if (cis != null) {
                        try {
                            ChildReference childPath = ChildReference.concatenate(le.path, new IndexReference(index));
                            sa.addListener(le.listener, cis, childPath, le.executor);
                        }
                        catch (AccessorException e) {
                            throw new AccessorConstructionException(e);
                        }
                    }
                    le = le.next;
                }
            }
            BinaryObject binaryObject2 = sa;
            return (T)binaryObject2;
        }
        catch (IOException e) {
            throw new AccessorConstructionException(e);
        }
        catch (AccessorException e) {
            throw new AccessorConstructionException(e);
        }
        catch (SerializerConstructionException e) {
            throw new AccessorConstructionException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    BinaryObject getExistingAccessor(int index) {
        if (index < 0 || index >= this.count()) {
            throw new RuntimeException("Field index (" + index + ") out of bounds (" + this.count() + ")");
        }
        Reference<BinaryObject> ref = this.children[index];
        BinaryObject accessor = ref != null ? ref.get() : null;
        return accessor;
    }

    @Override
    public Object getFieldValue(String fieldName, Binding fieldBinding) throws AccessorException {
        int fieldIndex = this.type().getComponentIndex(fieldName);
        if (fieldIndex < 0) {
            throw new AccessorException("Field " + fieldName + " does not exist");
        }
        return this.getFieldValue(fieldIndex, fieldBinding);
    }

    @Override
    public Object getFieldValue(int index, Binding fieldBinding) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            this.b.position(this.getStartPosition(index));
            ArrayList<Object> ids = new ArrayList<Object>(0);
            Object object = this.params.serializerScheme.getSerializer(fieldBinding).deserialize(this.b, ids);
            return object;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        catch (RuntimeSerializerConstructionException e) {
            throw new AccessorException(e);
        }
        catch (SerializerConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void setFieldValue(String fieldName, Binding fieldBinding, Object value) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            this.setFieldValueNoflush(fieldName, fieldBinding, value);
            this.flush();
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setFieldValueNoflush(String fieldName, Binding fieldBinding, Object value) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            int fieldIndex = this.type().getComponentIndex(fieldName);
            if (fieldIndex < 0) {
                throw new AccessorException("Field " + fieldName + " does not exist");
            }
            this.setFieldValue(fieldIndex, fieldBinding, value);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setFieldValue(int index, Binding fieldBinding, Object value) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            this.setFieldValueNoflush(index, fieldBinding, value);
            this.flush();
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setFieldValueNoflush(int index, Binding cb, Object cv) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            BinaryObject sa = this.getExistingAccessor(index);
            if (sa != null) {
                sa.setValueNoflush(cb, cv);
                return;
            }
            try {
                long pos = this.getStartPosition(index);
                Serializer cs = this.params.serializerScheme.getSerializer(cb);
                if (cs.getConstantSize() == null) {
                    this.b.position(pos);
                    cs.skip(this.b, null);
                    long oldLen = this.b.position() - pos;
                    long newLen = cs.getSize(cv, null);
                    if (newLen > oldLen) {
                        this.b.position(pos + oldLen);
                        this.b.insertBytes(newLen - oldLen, RandomAccessBinary.ByteSide.Left);
                    } else {
                        this.b.position(pos + newLen);
                        this.b.removeBytes(oldLen - newLen, RandomAccessBinary.ByteSide.Left);
                    }
                }
                this.b.position(pos);
                cs.serialize(this.b, null, cv);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    RecordInterestSet is = (RecordInterestSet)le.getInterestSet();
                    if (is.inNotificationsOf(index)) {
                        MutableVariant newValue;
                        MutableVariant mutableVariant = newValue = is.inValuesOf(index) ? new MutableVariant(cb, cv) : null;
                        if (is.inValuesOf(index)) {
                            newValue = new MutableVariant(cb, cb.isImmutable() ? cv : cb.clone(cv));
                        }
                        ValueAssigned e = new ValueAssigned(new IndexReference(index), newValue);
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (SerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) throws AccessorException {
        RecordInterestSet is = (RecordInterestSet)interestSet;
        super.addListener(listener, interestSet, path, executor);
        if (is.componentInterests != null) {
            int i = 0;
            while (i < this.count()) {
                BinaryObject sa;
                InterestSet cis = is.getComponentInterest(i);
                if (cis != null && (sa = this.getExistingAccessor(i)) != null) {
                    ChildReference childPath = ChildReference.concatenate(path, new IndexReference(i));
                    sa.addListener(listener, cis, childPath, executor);
                }
                ++i;
            }
        }
    }

    @Override
    public void removeListener(Accessor.Listener listener) throws AccessorException {
        ListenerEntry e = this.detachListener(listener);
        if (e == null) {
            return;
        }
        RecordInterestSet is = (RecordInterestSet)e.interestSet;
        if (is.componentInterests != null) {
            int i = 0;
            while (i < this.count()) {
                BinaryObject sa;
                InterestSet cis = is.getComponentInterest(i);
                if (cis != null && (sa = this.getExistingAccessor(i)) != null) {
                    sa.removeListener(listener);
                }
                ++i;
            }
        }
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        if (reference instanceof LabelReference) {
            LabelReference lr = (LabelReference)reference;
            String fieldName = lr.label;
            Integer index = this.type().getComponentIndex(fieldName);
            if (index == null) {
                throw new ReferenceException("RecordType doesn't have field by name \"" + fieldName + "\"");
            }
            BinaryObject sa = (BinaryObject)this.getFieldAccessor(index);
            if (reference.getChildReference() != null) {
                sa = (BinaryObject)sa.getComponent(reference.getChildReference());
            }
            return (T)sa;
        }
        if (reference instanceof IndexReference) {
            IndexReference ref = (IndexReference)reference;
            int index = ref.getIndex();
            BinaryObject sa = (BinaryObject)this.getFieldAccessor(index);
            if (reference.getChildReference() != null) {
                sa = (BinaryObject)sa.getComponent(reference.getChildReference());
            }
            return (T)sa;
        }
        if (reference instanceof NameReference) {
            NameReference ref = (NameReference)reference;
            String fieldName = ref.getName();
            Integer index = this.type().getComponentIndex(fieldName);
            if (index == null) {
                throw new ReferenceException("RecordType doesn't have field by name \"" + fieldName + "\"");
            }
            BinaryObject sa = (BinaryObject)this.getFieldAccessor(index);
            if (reference.getChildReference() != null) {
                sa = (BinaryObject)sa.getComponent(reference.getChildReference());
            }
            return (T)sa;
        }
        throw new ReferenceException(reference.getClass() + " is not a subreference of RecordType");
    }

    @Override
    public void setValueNoflush(Binding binding, Object newValue) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                RecordBinding rb = (RecordBinding)binding;
                Serializer rs = this.params.serializerScheme.getSerializer(rb);
                long newSize = rs.getSize(newValue, null);
                this.b.setLength(newSize);
                this.b.position(0L);
                int index = 0;
                while (index < this.count()) {
                    long pos = this.b.position();
                    Binding cb = rb.getComponentBinding(index);
                    Serializer cs = this.params.serializerScheme.getSerializer(cb);
                    Object cv = rb.getComponent(newValue, index);
                    cs.serialize(this.b, cv);
                    long len = this.b.position() - pos;
                    BinaryObject sa = this.getExistingAccessor(index);
                    if (sa != null) {
                        sa.b.setPositionInSource(pos, len);
                    }
                    if (this.listeners != null) {
                        ListenerEntry le = this.listeners;
                        while (le != null) {
                            RecordInterestSet is = (RecordInterestSet)le.getInterestSet();
                            if (is.inNotificationsOf(index)) {
                                ValueAssigned e = new ValueAssigned(new IndexReference(index), cb, is.inValuesOf(index) ? cv : null);
                                this.emitEvent(le, e);
                            }
                            le = le.next;
                        }
                    }
                    ++index;
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (SerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        if (e instanceof ValueAssigned) {
            ValueAssigned va = (ValueAssigned)e;
            ValueAssigned rollback = null;
            if (makeRollback) {
                Object binding = Bindings.getMutableBinding(this.type());
                rollback = new ValueAssigned((Binding)binding, this.getValue((Binding)binding));
            }
            this.setValueNoflush(va.newValue.getBinding(), va.newValue.getValue());
            return rollback;
        }
        throw new AccessorException("Cannot apply " + e.getClass().getName() + " to Record Type");
    }
}

