/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.StreamUtil;
import org.simantics.databoard.util.binary.BinaryFile;
import org.simantics.databoard.util.binary.BinaryReadable;
import org.simantics.databoard.util.binary.ByteBufferReadable;
import org.simantics.databoard.util.binary.ByteBufferWriteable;
import org.simantics.databoard.util.binary.InputStreamReadable;
import org.simantics.databoard.util.binary.OutputStreamWriteable;
import org.simantics.databoard.util.binary.UTF8;

public class Files {
    public static void createTextFile(File file, Binding binding, Object value) throws IOException {
        try {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            String txt = binding.printValueDefinition(value, false);
            FileOutputStream fos = new FileOutputStream(file, false);
            try {
                OutputStreamWriter os = new OutputStreamWriter((OutputStream)fos, UTF8.CHARSET);
                os.append(txt);
                os.flush();
                os.close();
            }
            finally {
                fos.close();
            }
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    public static void createFile(File file, Binding binding, Object value) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        MutableVariant v = new MutableVariant(binding, value);
        Serializer s = Bindings.getSerializerUnchecked(Bindings.MUTABLE_VARIANT);
        s.serialize((Object)v, file);
    }

    public static void createFile(File file) throws IOException, RuntimeSerializerConstructionException {
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        BinaryFile bf = new BinaryFile(file);
        try {
            VariantBinding binding = Bindings.MUTABLE_VARIANT;
            MutableVariant value = new MutableVariant();
            Serializer s = Bindings.getSerializerUnchecked(binding);
            s.serialize(bf, (Object)value);
        }
        finally {
            bf.close();
        }
    }

    public static void createFile(File file, Datatype type) throws IOException, RuntimeSerializerConstructionException {
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        BinaryFile bf = new BinaryFile(file);
        try {
            try {
                VariantBinding binding = Bindings.MUTABLE_VARIANT;
                Object value = binding.createDefault();
                Serializer s = Bindings.getSerializer(binding);
                s.serialize(bf, value);
            }
            catch (BindingException e) {
                throw new IOException(e);
            }
            catch (SerializerConstructionException e) {
                throw new IOException(e);
            }
        }
        finally {
            bf.close();
        }
    }

    public static Object readTextFile(File file, Binding binding) throws IOException, DataTypeSyntaxError, BindingException {
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] data = StreamUtil.readFully(fis);
            String txt = new String(data, UTF8.CHARSET);
            DataValueRepository repo = new DataValueRepository();
            repo.setTypeRepository(Datatypes.datatypeRepository);
            Object object = binding.parseValue(txt, repo);
            return object;
        }
        finally {
            fis.close();
        }
    }

    public static Datatype readFileType(File file) throws IOException {
        BinaryFile rf = new BinaryFile(file);
        try {
            Object datatype_binding = Bindings.getBindingUnchecked(Datatype.class);
            Datatype datatype = (Datatype)Bindings.getSerializerUnchecked(datatype_binding).deserialize(rf);
            return datatype;
        }
        finally {
            rf.close();
        }
    }

    public static Object readFile(File file, Binding binding) throws IOException {
        BinaryFile rf = new BinaryFile(file);
        try {
            Object datatype_binding = Bindings.getBindingUnchecked(Datatype.class);
            Datatype type = (Datatype)Bindings.getSerializerUnchecked(datatype_binding).deserialize(rf);
            if (type.equals(binding.type())) {
                Object object = Bindings.getSerializerUnchecked(binding).deserialize(rf);
                return object;
            }
            Object fileContentBinding = Bindings.getMutableBinding(type);
            Adapter adapter = Bindings.getAdapter(fileContentBinding, binding);
            Object value = Bindings.getSerializerUnchecked(fileContentBinding).deserialize(rf);
            Object object = adapter.adapt(value);
            return object;
        }
        finally {
            rf.close();
        }
    }

    public static void readFile(File file, RecordBinding binding, Object dst) throws IOException {
        block6: {
            BinaryFile rf = new BinaryFile(file);
            try {
                Object datatype_binding = Bindings.getBindingUnchecked(Datatype.class);
                Datatype type = (Datatype)Bindings.getSerializerUnchecked(datatype_binding).deserialize(rf);
                if (type.equals(binding.type())) {
                    Serializer s = Bindings.getSerializerUnchecked(binding);
                    s.deserializeTo(rf, dst);
                    break block6;
                }
                try {
                    Object fileContentBinding = Bindings.getMutableBinding(type);
                    Serializer s = Bindings.getSerializerUnchecked(fileContentBinding);
                    Object tmpObj = s.deserialize(rf);
                    binding.readFrom((Binding)fileContentBinding, tmpObj, dst);
                }
                catch (BindingException e) {
                    throw new IOException(e);
                }
            }
            finally {
                rf.close();
            }
        }
    }

    public static Object readFile(InputStream is, Binding binding) throws IOException {
        BinaryReadable readable = InputStreamReadable.readFully(is);
        Object datatype_binding = Bindings.getBindingUnchecked(Datatype.class);
        Datatype type = (Datatype)Bindings.getSerializerUnchecked(datatype_binding).deserialize(readable);
        if (!type.equals(binding.type())) {
            try {
                Object fileContentBinding = Bindings.getMutableBinding(type);
                Adapter adapter = Bindings.getAdapter(fileContentBinding, binding);
                Object value = Bindings.getSerializerUnchecked(fileContentBinding).deserialize(readable);
                return adapter.adapt(value);
            }
            catch (AdapterConstructionException e) {
                throw new IOException(e);
            }
            catch (AdaptException e) {
                throw new IOException(e);
            }
        }
        return Bindings.getSerializerUnchecked(binding).deserialize(readable);
    }

    public static Object readFile(InputStream is, long streamLength, Binding binding) throws IOException {
        InputStreamReadable readable = new InputStreamReadable(is, streamLength);
        Object datatype_binding = Bindings.getBindingUnchecked(Datatype.class);
        Datatype type = (Datatype)Bindings.getSerializerUnchecked(datatype_binding).deserialize(readable);
        if (!type.equals(binding.type())) {
            try {
                Object fileContentBinding = Bindings.getMutableBinding(type);
                Adapter adapter = Bindings.getAdapter(fileContentBinding, binding);
                Object value = Bindings.getSerializerUnchecked(fileContentBinding).deserialize(readable);
                return adapter.adapt(value);
            }
            catch (AdapterConstructionException e) {
                throw new IOException(e);
            }
            catch (AdaptException e) {
                throw new IOException(e);
            }
        }
        return Bindings.getSerializerUnchecked(binding).deserialize(readable);
    }

    public static void writeFile(File file, Binding binding, Object value) throws IOException {
        BinaryFile rf = new BinaryFile(file);
        try {
            MutableVariant v = new MutableVariant(binding, value);
            Serializer s = Bindings.getSerializerUnchecked(Bindings.MUTABLE_VARIANT);
            s.serialize((Object)v, file);
        }
        finally {
            rf.close();
        }
    }

    public static DataInput openInput(InputStream is) {
        return new InputStreamReadable(is, Long.MAX_VALUE);
    }

    public static DataInput openInput(File file) throws IOException {
        return new BinaryFile(file);
    }

    public static DataInput openInput(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return new ByteBufferReadable(buffer);
    }

    public static DataOutput openOutput(OutputStream os) {
        return new OutputStreamWriteable(os);
    }

    public static DataOutput openOutput(File file) throws IOException {
        return new BinaryFile(file);
    }

    public static DataOutput openOutput(byte[] data) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return new ByteBufferWriteable(buffer);
    }
}

