/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import org.simantics.utils.strings.AlphanumComparator;

public final class ComparablePair<T1 extends Comparable<T1>, T2 extends Comparable<T2>>
implements Comparable<ComparablePair<T1, T2>> {
    public final T1 first;
    public final T2 second;
    private final int hash;

    public static <T1 extends Comparable<T1>, T2 extends Comparable<T2>> ComparablePair<T1, T2> make(T1 t1, T2 t2) {
        return new ComparablePair<T1, T2>(t1, t2);
    }

    public ComparablePair(T1 first, T2 second) {
        if (first == null) {
            throw new IllegalArgumentException("ComparablePair does not accept null values");
        }
        if (second == null) {
            throw new IllegalArgumentException("ComparablePair does not accept null values");
        }
        this.first = first;
        this.second = second;
        this.hash = this.makeHash();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ComparablePair other = (ComparablePair)obj;
        if (!(other.first == this.first || other.first != null && other.first.equals(this.first))) {
            return false;
        }
        return other.second == this.second || other.second != null && other.second.equals(this.second);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "<" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + ">";
    }

    private int makeHash() {
        return (this.first == null ? 0 : this.first.hashCode()) + (this.second == null ? 0 : this.second.hashCode()) * 31;
    }

    @Override
    public int compareTo(ComparablePair<T1, T2> arg0) {
        int firstCompare = AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare(this.first, arg0.first);
        if (firstCompare != 0) {
            return firstCompare;
        }
        return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare(this.second, arg0.second);
    }
}

