/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.elevation.server;

import java.io.Closeable;
import java.nio.file.Path;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.Envelope2D;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.simantics.maps.elevation.server.prefs.MapsElevationServerPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiffInterface
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TiffInterface.class);
    private final Path tifPath;
    private GridCoverage2D coverage;
    private boolean init = false;

    public TiffInterface(Path tifPath) {
        this.tifPath = tifPath;
        this.loadMetadata();
    }

    private void loadMetadata() {
        GeoTiffReader reader = null;
        try {
            try {
                reader = new GeoTiffReader((Object)this.tifPath.toFile());
                this.coverage = reader.read(null);
                this.init = true;
            }
            catch (Exception e) {
                LOGGER.error("Could not load {}", (Object)this.tifPath, (Object)e);
                if (reader != null) {
                    reader.dispose();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }

    public boolean contains(DirectPosition pos) {
        this.ensureInit();
        Envelope2D e = this.coverage.getEnvelope2D();
        try {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)pos.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)this.getCRS(), (boolean)false);
            DirectPosition target = transform.transform(pos, null);
            boolean contains = e.contains(target);
            return contains;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public Number lookup(DirectPosition pos) {
        this.ensureInit();
        Object r = this.coverage.evaluate(pos);
        int dataType = this.coverage.getRenderedImage().getSampleModel().getDataType();
        int pipeDepthUnderGround = MapsElevationServerPreferences.pipeDepthUnderGround();
        switch (dataType) {
            case 0: {
                return ((byte[])r)[0];
            }
            case 1: 
            case 2: 
            case 3: {
                int val = ((int[])r)[0] - pipeDepthUnderGround;
                return val;
            }
            case 4: {
                float val = ((float[])r)[0] - (float)pipeDepthUnderGround;
                return Float.valueOf(val);
            }
            case 5: {
                double val = ((double[])r)[0] - (double)pipeDepthUnderGround;
                return val;
            }
        }
        return null;
    }

    private void ensureInit() {
        if (!this.init) {
            throw new IllegalStateException("Interface is not initialized for " + String.valueOf(this.tifPath));
        }
    }

    @Override
    public void close() {
        this.coverage.dispose(true);
    }

    public Envelope2D getCornerCoords() {
        return this.coverage.getEnvelope2D();
    }

    public CoordinateReferenceSystem getCRS() {
        return this.coverage.getCoordinateReferenceSystem();
    }
}

