/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.route;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.simantics.ObjectIdentitySchedulingRule;
import org.simantics.db.Resource;
import org.simantics.district.route.Route;
import org.simantics.district.route.Router;
import org.simantics.district.route.RouterConfiguration;
import org.simantics.district.route.RoutingException;
import org.simantics.district.route.internal.Activator;
import org.simantics.district.route.internal.RoutePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteJob
extends Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteJob.class);
    public static final List<Resource> CANCELLED_RESULT = Collections.unmodifiableList(Arrays.asList(new Resource[0]));
    private RouterConfiguration config;
    private List<Resource> waypoints;
    private CompletableFuture<List<Resource>> callback;

    public RouteJob(RouterConfiguration config, Route route, CompletableFuture<List<Resource>> callback) {
        this(config, RoutePersistence.toResources(route.waypoints()), callback);
        this.setRule((ISchedulingRule)new ObjectIdentitySchedulingRule((Object)route));
    }

    public RouteJob(RouterConfiguration config, List<Resource> waypoints, CompletableFuture<List<Resource>> callback) {
        super("Compute route");
        Objects.requireNonNull(callback, "Callback must be non-null");
        this.setUser(true);
        this.config = config;
        this.waypoints = waypoints;
        this.callback = callback;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.callback.isCancelled()) {
            this.callback.complete(CANCELLED_RESULT);
            return Status.CANCEL_STATUS;
        }
        List<Router> routers = Activator.getInstance().getRouteService().routers();
        for (Router router : routers) {
            try {
                List<Resource> path = router.findShortestPath(this.config, this.waypoints);
                if (path.isEmpty()) continue;
                this.callback.complete(path);
                return Status.OK_STATUS;
            }
            catch (RoutingException e) {
                LOGGER.error("Routing failed for waypoints {} and router '{}'", new Object[]{this.waypoints, router, e});
                this.callback.completeExceptionally(e);
                return new Status(4, "org.simantics.district.route", e.getMessage());
            }
        }
        String msg = NLS.bind((String)"No router could calculate route between waypoints {0}. Available routers: {1}", this.waypoints, routers);
        LOGGER.info(msg);
        this.callback.completeExceptionally(new RoutingException(msg));
        return new Status(4, "org.simantics.district.route", msg);
    }
}

