/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.route.ontology;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.QueryControl;

public class RouteResource {
    public final Resource Actions;
    public final Resource Actions_SelectRoute;
    public final Resource Actions_ValidateRoute;
    public final Resource Route;
    public final Resource RouteActionContext;
    public final Resource RouteFolder;

    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        }
        catch (DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public RouteResource(ReadGraph graph) {
        this.Actions = RouteResource.getResourceOrNull(graph, "http://www.simantics.org/DistrictNetworkRoutes-1.0/Actions");
        this.Actions_SelectRoute = RouteResource.getResourceOrNull(graph, "http://www.simantics.org/DistrictNetworkRoutes-1.0/Actions/SelectRoute");
        this.Actions_ValidateRoute = RouteResource.getResourceOrNull(graph, "http://www.simantics.org/DistrictNetworkRoutes-1.0/Actions/ValidateRoute");
        this.Route = RouteResource.getResourceOrNull(graph, "http://www.simantics.org/DistrictNetworkRoutes-1.0/Route");
        this.RouteActionContext = RouteResource.getResourceOrNull(graph, "http://www.simantics.org/DistrictNetworkRoutes-1.0/RouteActionContext");
        this.RouteFolder = RouteResource.getResourceOrNull(graph, "http://www.simantics.org/DistrictNetworkRoutes-1.0/RouteFolder");
    }

    public static RouteResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        RouteResource ret = (RouteResource)session.peekService(RouteResource.class);
        if (ret == null) {
            QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
            ret = new RouteResource(qc.getIndependentGraph(graph));
            session.registerService(RouteResource.class, (Object)ret);
        }
        return ret;
    }

    public static RouteResource getInstance(RequestProcessor session) throws DatabaseException {
        RouteResource ret = (RouteResource)session.peekService(RouteResource.class);
        if (ret == null) {
            ret = (RouteResource)session.syncRequest((Read)new Read<RouteResource>(){

                public RouteResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
                    return new RouteResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(RouteResource.class, (Object)ret);
        }
        return ret;
    }

    public static class URIs {
        public static final String Actions = "http://www.simantics.org/DistrictNetworkRoutes-1.0/Actions";
        public static final String Actions_SelectRoute = "http://www.simantics.org/DistrictNetworkRoutes-1.0/Actions/SelectRoute";
        public static final String Actions_ValidateRoute = "http://www.simantics.org/DistrictNetworkRoutes-1.0/Actions/ValidateRoute";
        public static final String Route = "http://www.simantics.org/DistrictNetworkRoutes-1.0/Route";
        public static final String RouteActionContext = "http://www.simantics.org/DistrictNetworkRoutes-1.0/RouteActionContext";
        public static final String RouteFolder = "http://www.simantics.org/DistrictNetworkRoutes-1.0/RouteFolder";
    }
}

