/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.visualisations.model;

import java.awt.Color;
import java.util.List;

public class DynamicColorMap {
    private String label;
    private List<RGBIntensity> intensities;

    public DynamicColorMap(String label, List<RGBIntensity> intensities) {
        this.label = label;
        this.intensities = intensities;
    }

    public String getLabel() {
        return this.label;
    }

    public List<RGBIntensity> getIntensities() {
        return this.intensities;
    }

    public Color getColor(double value, boolean useGradient, double defaultMin, double defaultMax) {
        List<RGBIntensity> intensities = this.getIntensities();
        double gap = defaultMax - defaultMin;
        double singleGap = gap / (double)intensities.size();
        double threshold = defaultMin;
        int i = 0;
        while (i < intensities.size() - 1) {
            if (value <= (threshold += singleGap)) break;
            ++i;
        }
        RGBIntensity intensity = intensities.get(i);
        if (useGradient) {
            RGBIntensity upperLimitIntensity = i + 1 != intensities.size() ? intensities.get(i + 1) : intensity;
            double minRed = intensity.getRed();
            double minGreen = intensity.getGreen();
            double minBlue = intensity.getBlue();
            double maxRed = upperLimitIntensity.getRed();
            double maxGreen = upperLimitIntensity.getGreen();
            double maxBlue = upperLimitIntensity.getBlue();
            double delta = Math.max(value - (defaultMin + singleGap * (double)i), 0.0);
            double d = delta / singleGap;
            double redDelta = (maxRed - minRed) * d;
            double greenDelta = (maxGreen - minGreen) * d;
            double blueDelta = (maxBlue - minBlue) * d;
            return new Color((float)(minRed + redDelta), (float)(minGreen + greenDelta), (float)(minBlue + blueDelta));
        }
        return new Color((float)intensity.getRed(), (float)intensity.getGreen(), (float)intensity.getBlue());
    }

    public static class RGBIntensity {
        private double red;
        private double green;
        private double blue;

        public RGBIntensity(double red, double green, double blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public double getRed() {
            return this.red;
        }

        public double getGreen() {
            return this.green;
        }

        public double getBlue() {
            return this.blue;
        }
    }
}

