/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.techtype.variable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.function.All;
import org.simantics.db.layer0.variable.AbstractChildVariable;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.district.network.techtype.TechTypeUtils;
import org.simantics.district.network.techtype.requests.PossibleTechTypeTable;
import org.simantics.district.network.techtype.requests.TechTypeTableData;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.structural.stubs.StructuralResource2;

public class Functions {
    @SCLValue(type="ValueAccessor")
    public static final ValueAccessor techTypeCodeValueAccessor = new ValueAccessor(){

        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            return All.standardValueAccessor.getValue(graph, context);
        }

        public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
            return All.standardValueAccessor.getValue(graph, context, binding);
        }

        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            All.standardValueAccessor.setValue(graph, context, value);
            Functions.updateComponentProperties(graph, context, value);
        }

        public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
            All.standardValueAccessor.setValue(graph, context, value, binding);
            Functions.updateComponentProperties(graph, context, value);
        }

        public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
            return All.standardValueAccessor.getDatatype(graph, context);
        }
    };

    protected static void updateComponentProperties(WriteGraph graph, Variable context, Object value) throws DatabaseException {
        Variable component = context.getParent((ReadGraph)graph);
        Resource type = component.getPossibleType((ReadGraph)graph, StructuralResource2.getInstance((ReadGraph)graph).Component);
        if (type == null) {
            return;
        }
        TechTypeUtils.updateComponent(graph, component.getRepresents((ReadGraph)graph));
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object techTypeKeys(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        if (!(context instanceof Variable)) {
            return Collections.emptyList();
        }
        Variable var = (Variable)context;
        while (!(var instanceof AbstractChildVariable)) {
            var = var.getParent(graph);
        }
        Resource type = var.getType(graph, StructuralResource2.getInstance((ReadGraph)graph).Component);
        Resource model = var.getIndexRoot(graph);
        if (model == null) {
            return Collections.emptyList();
        }
        Resource table = (Resource)graph.syncRequest((Read)new PossibleTechTypeTable(model, type), (Listener)TransientCacheListener.instance());
        if (table == null) {
            return Collections.emptyList();
        }
        Map data = (Map)graph.syncRequest((Read)new TechTypeTableData(table, true), (Listener)TransientCacheListener.instance());
        ArrayList result = new ArrayList(data.keySet());
        result.sort(TechTypeUtils::compareNatural);
        return result;
    }
}

