/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.techtype.requests;

import java.util.UUID;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.techtype.requests.PossibleTechTypeTable;
import org.simantics.layer0.Layer0;

public final class WriteTechTypeTable
extends WriteRequest {
    private final String data;
    private final Resource componentType;

    public WriteTechTypeTable(Resource componentType, String data) {
        this.data = data;
        this.componentType = componentType;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Resource model = (Resource)graph.syncRequest((Read)new PossibleActiveModel(Simantics.getProjectResource()));
        if (model == null) {
            throw new DatabaseException("No active model for storing tech type data");
        }
        Resource ttt = (Resource)graph.syncRequest((Read)new PossibleTechTypeTable(model, this.componentType), (Listener)TransientCacheListener.instance());
        graph.getSession().markUndoPoint();
        if (ttt == null) {
            ttt = graph.newResource();
            graph.claim(ttt, L0.InstanceOf, DN.TechType_TechTypeTable);
            graph.claimLiteral(ttt, L0.HasName, (Object)UUID.randomUUID().toString());
            graph.claim(model, L0.ConsistsOf, ttt);
            graph.claim(ttt, DN.TechType_TechTypeTable_HasComponentType, this.componentType);
            Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Create tech type table " + String.valueOf(ttt)));
        } else {
            graph.deny(ttt, DN.TechType_TechTypeTable_HasEnabledItems);
            Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Update tech type table " + String.valueOf(ttt)));
        }
        graph.claimLiteral(ttt, DN.TechType_TechTypeTable_HasData, (Object)this.data);
    }
}

