/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.techtype.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.techtype.TechTypeUtils;
import org.simantics.district.network.techtype.requests.TechTypeTableRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TechTypeTableData
extends BinaryRead<Resource, Boolean, Map<String, Map<String, String>>> {
    static final Logger LOGGER = LoggerFactory.getLogger(TechTypeTableData.class);

    public TechTypeTableData(Resource table) {
        super((Object)table, (Object)Boolean.FALSE);
    }

    public TechTypeTableData(Resource table, boolean enabledOnly) {
        super((Object)table, (Object)enabledOnly);
    }

    public Map<String, Map<String, String>> perform(ReadGraph graph) throws DatabaseException {
        Stream<Object> enabled;
        Resource table = (Resource)this.parameter;
        boolean enabledOnly = (Boolean)this.parameter2;
        String keyName = this.getKeyName(graph, table);
        List records = (List)graph.syncRequest((Read)new TechTypeTableRecords(table), (Listener)TransientCacheListener.instance());
        if (records == null || records.size() < 2) {
            return Collections.emptyMap();
        }
        if (enabledOnly) {
            int[] enabledKeys = (int[])graph.getRelatedValue2(table, DistrictNetworkResource.getInstance((ReadGraph)graph).TechType_TechTypeTable_HasEnabledItems, (Binding)Bindings.INT_ARRAY);
            enabled = Arrays.stream(enabledKeys).filter(i -> i >= 0 && i < records.size()).mapToObj(i -> (Map)records.get(i));
        } else {
            enabled = records.stream();
        }
        return enabled.filter(r -> r.containsKey(keyName)).collect(Collectors.toMap(r -> (String)r.get(keyName), r -> r, (p, q) -> p));
    }

    private String getKeyName(ReadGraph graph, Resource table) throws DatabaseException {
        String keyName = TechTypeUtils.getKeyPropertyName(graph, table);
        if (keyName.startsWith("_")) {
            keyName = keyName.substring(1);
        }
        return keyName;
    }
}

