/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.profile;

import java.awt.Color;
import org.simantics.district.network.profile.ColorGradient;

public class Colors {
    public static final ColorGradient cached(ColorGradient cg) {
        return new Cache(cg, 2048);
    }

    public static final ColorGradient hsvGradient(float hue, float saturation) {
        return t -> Color.getHSBColor(hue, saturation, Colors.saturate((float)t));
    }

    private static float saturate(float t) {
        return Math.max(0.0f, Math.min(t, 1.0f));
    }

    private static double saturate(double t) {
        return Math.max(0.0, Math.min(t, 1.0));
    }

    private static class Cache
    implements ColorGradient {
        private final ColorGradient proxy;
        private final int discretization;
        private final Color[] cache;

        public Cache(ColorGradient proxy, int discretization) {
            this.proxy = proxy;
            this.discretization = discretization;
            this.cache = new Color[discretization + 1];
        }

        private int discretize(double t) {
            return (int)(Colors.saturate(t) * (double)this.discretization);
        }

        @Override
        public Color get(double t) {
            int d = this.discretize(t);
            Color cached = this.cache[d];
            if (cached != null) {
                return cached;
            }
            cached = this.cache[d] = this.proxy.get(t);
            return cached;
        }
    }
}

