/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.tile;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.simantics.maps.ProvisionException;
import org.simantics.maps.internal.ImageUtil;
import org.simantics.maps.tile.ITileProvider;
import org.simantics.maps.tile.TileKey;

public class CompoundTileProvider
implements ITileProvider {
    URI source;
    int tileSize;
    List<Provider> providers = new ArrayList<Provider>();
    BufferedImage outOfBoundsImage;

    public CompoundTileProvider(URI source, int tileSize) {
        this.source = source;
        this.tileSize = tileSize;
    }

    @Override
    public URI getSource() {
        return this.source;
    }

    @Override
    public Rectangle2D getExtent() {
        if (this.providers.isEmpty()) {
            return new Rectangle2D.Double();
        }
        boolean first = true;
        Rectangle2D.Double result = new Rectangle2D.Double();
        for (Provider p : this.providers) {
            if (first) {
                result.setFrame(p.provider.getExtent());
                first = false;
                continue;
            }
            Rectangle2D.union(result, p.provider.getExtent(), result);
        }
        return result;
    }

    public void addProvider(ITileProvider provider, int minTileLevel, int maxTileLevel) {
        if (minTileLevel > maxTileLevel) {
            throw new IllegalArgumentException("minTileLevel (" + minTileLevel + ") cannot be larger than maxTileLevel" + maxTileLevel + ")");
        }
        this.providers.add(new Provider(provider, minTileLevel, maxTileLevel));
    }

    @Override
    public Image get(TileKey key) throws ProvisionException {
        int level = key.getLevel();
        int x = key.getX();
        int y = key.getY();
        double xTiles = Math.pow(2.0, level + 1);
        double yTiles = Math.pow(2.0, level);
        if (level < 0) {
            throw new IllegalArgumentException("invalid tile level " + level + " (tile=" + String.valueOf(key) + ")");
        }
        if (x < 0 || x >= (int)xTiles) {
            throw new IllegalArgumentException("tile x out of bounds " + x + " (tile=" + String.valueOf(key) + ")");
        }
        if (y < 0 || y >= (int)yTiles) {
            throw new IllegalArgumentException("tile y out of bounds " + y + " (tile=" + String.valueOf(key) + ")");
        }
        Rectangle2D.Double r = new Rectangle2D.Double();
        double minx = -180.0;
        double miny = -90.0;
        double w = 360.0;
        double h = 180.0;
        double xdelta = w / xTiles;
        double ydelta = h / yTiles;
        double xx = x;
        double yy = yTiles - (double)y - 1.0;
        r.setFrame(minx + xdelta * xx, miny + ydelta * yy, xdelta, ydelta);
        Image result = null;
        Graphics g = null;
        try {
            for (Provider p : this.providers) {
                Rectangle2D extent;
                if (level < p.minTileLevel || !r.intersects(extent = p.provider.getExtent())) continue;
                if (result == null) {
                    result = ImageUtil.createScreenCompatibleImage(this.tileSize, this.tileSize, 1);
                    g = ((BufferedImage)result).createGraphics();
                }
                if (level > p.maxTileLevel) {
                    Rectangle2D.Double helperRect = new Rectangle2D.Double(0.0, 0.0, this.tileSize, this.tileSize);
                    TileTraverser tileTraverser = new TileTraverser();
                    TileKey maxTile = this.findFirstAvailableParentTile(p.maxTileLevel, key, tileTraverser);
                    Image img = p.provider.get(maxTile);
                    helperRect.setFrame(0.0, 0.0, img.getWidth(null), img.getHeight(null));
                    this.traverseRectangle(tileTraverser, helperRect);
                    int sx1 = (int)Math.round(helperRect.getMinX());
                    int sy1 = (int)Math.round(helperRect.getMinY());
                    int sx2 = (int)Math.round(helperRect.getMaxX());
                    int sy2 = (int)Math.round(helperRect.getMaxY());
                    g.drawImage(img, 0, 0, this.tileSize, this.tileSize, sx1, sy1, sx2, sy2, null);
                    continue;
                }
                Image src = p.provider.get(key);
                int srcW = src.getWidth(null);
                int srcH = src.getHeight(null);
                g.drawImage(src, 0, 0, this.tileSize, this.tileSize, 0, 0, srcW, srcH, null);
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        return result != null ? result : this.getOutOfBoundsImage();
    }

    private Image getOutOfBoundsImage() {
        if (this.outOfBoundsImage != null) {
            return this.outOfBoundsImage;
        }
        BufferedImage image = new BufferedImage(1, 1, 5);
        Graphics2D g = image.createGraphics();
        try {
            g.setColor(Color.CYAN);
            g.fillRect(0, 0, 1, 1);
            this.outOfBoundsImage = image;
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            g.dispose();
        }
    }

    TileKey getChildTile(TileKey k, int quadrant) {
        int ox = quadrant == 0 || quadrant == 3 ? 1 : 0;
        int oy = quadrant == 0 || quadrant == 1 ? 1 : 0;
        return new TileKey(k.getLevel() + 1, k.getX() * 2 + ox, k.getY() * 2 + oy);
    }

    TileKey getParentTile(TileKey k) {
        if (k.getLevel() == 0) {
            return null;
        }
        return new TileKey(k.getLevel() - 1, k.getX() / 2, k.getY() / 2);
    }

    Rectangle2D traverseToQuadrant(Rectangle2D r, int quadrant) {
        boolean left = quadrant == 1 || quadrant == 2;
        boolean top = quadrant == 1 || quadrant == 0;
        r.setFrame(left ? r.getMinX() : r.getCenterX(), top ? r.getMinY() : r.getCenterY(), r.getWidth() / 2.0, r.getHeight() / 2.0);
        return r;
    }

    int findTilePos(int level, double t, double tileSize) {
        double dt = t - 0.0;
        double p = dt / tileSize;
        int tt = (int)Math.floor(p);
        return tt;
    }

    private TileKey findFirstAvailableParentTile(int maxLevel, TileKey tile, TileTraverser traverser) {
        traverser.clear();
        traverser.add(tile);
        TileKey parent = this.getParentTile(tile);
        while (parent != null) {
            if (parent.getLevel() <= maxLevel) {
                return parent;
            }
            traverser.add(parent);
            parent = this.getParentTile(parent);
        }
        return null;
    }

    private void traverseRectangle(TileTraverser traverser, Rectangle2D rect) {
        int i = traverser.size() - 1;
        while (i >= 0) {
            this.traverseToQuadrant(rect, traverser.getQuadrant(i));
            --i;
        }
    }

    static class Provider {
        final ITileProvider provider;
        final int minTileLevel;
        final int maxTileLevel;

        public Provider(ITileProvider provider, int minTileLevel, int maxTileLevel) {
            this.provider = provider;
            this.minTileLevel = minTileLevel;
            this.maxTileLevel = maxTileLevel;
        }
    }

    static class TileTraverser {
        List<TileKey> tile = new ArrayList<TileKey>(4);
        List<Integer> quadrant = new ArrayList<Integer>(4);

        TileTraverser() {
        }

        static int getTileQuadrant(TileKey k) {
            int x = k.getX();
            int y = k.getY();
            if ((x & 1) == 0) {
                return (y & 1) == 0 ? 1 : 2;
            }
            return (y & 1) == 0 ? 0 : 3;
        }

        void clear() {
            this.tile.clear();
            this.quadrant.clear();
        }

        void add(TileKey tile) {
            this.tile.add(tile);
            this.quadrant.add(TileTraverser.getTileQuadrant(tile));
        }

        int size() {
            return this.tile.size();
        }

        TileKey getTile(int i) {
            return this.tile.get(i);
        }

        int getQuadrant(int i) {
            return this.quadrant.get(i);
        }
    }
}

