/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.simantics.maps.IProxyUtil;
import org.simantics.maps.pojo.AppletProxyUtil;

public class WebService {
    protected URI uri;
    protected URL service;

    public WebService(String address) throws URISyntaxException, MalformedURLException {
        this.uri = new URI(address);
        this.service = this.uri.toURL();
    }

    private IProxyUtil getProxyUtil() {
        IProxyUtil util = null;
        try {
            Class<?> proxyClass = Class.forName("org.simantics.maps.eclipse.EclipseProxyUtil");
            util = (IProxyUtil)proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
        if (util == null) {
            util = new AppletProxyUtil();
        }
        return util;
    }

    public URI getURI() {
        return this.uri;
    }

    public HttpURLConnection openConnection(String file, String query) throws MalformedURLException, IOException {
        URLConnection con;
        HttpURLConnection connection = null;
        Object suffix = query != null ? "?" + query : "";
        URL url = new URL(this.service.getProtocol(), this.service.getHost(), this.service.getPort(), this.service.getFile() + file + (String)suffix);
        Properties systemProperties = System.getProperties();
        Proxy proxy = this.getProxyUtil().getProxyService(url.toString());
        if (proxy != null && (InetSocketAddress)proxy.address() != null) {
            systemProperties.setProperty("http.proxyHost", ((InetSocketAddress)proxy.address()).getHostName());
            systemProperties.setProperty("http.proxyPort", "" + ((InetSocketAddress)proxy.address()).getPort());
        }
        if ((con = url.openConnection()) instanceof HttpURLConnection) {
            connection = (HttpURLConnection)con;
            connection.setConnectTimeout(10000);
            connection.connect();
        }
        return connection;
    }
}

