/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableFactory;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.graph.adapter.DoubleArrayCellVariable;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.utils.datastructures.datatype.RGBInt8;

public class DoubleArrayCells
implements VariableFactory {
    private Binding RGB = Bindings.getBindingUnchecked(RGBInt8.class);
    private Resource configuration;
    final String[] propertyNames = new String[]{"content", "foreground", "background", "HasLabel", "immutable"};
    final Binding[] bindings = new Binding[]{Bindings.VARIANT, this.RGB, this.RGB, Bindings.STRING, Bindings.BOOLEAN};

    public DoubleArrayCells(Resource configuration) {
        this.configuration = configuration;
    }

    private Collection<Variable> toVariables(ReadGraph graph, Variable variable, double[] data, int width) throws DatabaseException {
        SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
        String location = (String)graph.getPossibleRelatedValue(this.configuration, sr.HasLocation, (Binding)Bindings.STRING);
        if (location == null) {
            return Collections.emptyList();
        }
        int rows = data.length / width;
        RGBInt8 fore = new RGBInt8(255, 255, 255);
        RGBInt8 back = new RGBInt8(80, 130, 190);
        ArrayList<Variable> result = new ArrayList<Variable>();
        int offset = 0;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < width) {
                double value = data[offset++];
                String valueLocation = Spreadsheets.offset((String)location, (int)i, (int)j);
                result.add((Variable)new DoubleArrayCellVariable(variable, valueLocation, this.propertyNames, this.bindings, Variant.ofInstance((Object)value), fore, back, this.configuration, String.valueOf(value), false));
                ++j;
            }
            ++i;
        }
        return result;
    }

    private Collection<Variable> error(ReadGraph graph, Variable variable, String message) throws DatabaseException {
        SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
        String location = (String)graph.getPossibleRelatedValue(this.configuration, sr.HasLocation, (Binding)Bindings.STRING);
        if (location == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ConstantChildVariable(variable, location, this.propertyNames, this.bindings, new Object[]{message}));
    }

    public Collection<Variable> evaluate(ReadGraph graph, Variable variable) throws DatabaseException {
        SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
        double[] data = (double[])graph.getPossibleRelatedValue(this.configuration, sr.DoubleArrayCell_HasDoubleArray, (Binding)Bindings.DOUBLE_ARRAY);
        if (data == null) {
            return this.error(graph, variable, "No double array data.");
        }
        Integer width = (Integer)graph.getPossibleRelatedValue(this.configuration, sr.DoubleArrayCell_HasWidth, (Binding)Bindings.INTEGER);
        if (width == null) {
            return this.error(graph, variable, "Invalid width for double array.");
        }
        return this.toVariables(graph, variable, data, width);
    }
}

