/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.representation;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.TransferableGraphUtils;
import org.simantics.graph.representation.Value;

public class TransferableGraphQueries {
    private static final int NOT_FOUND = -2;
    private final TransferableGraph1 tg;
    private final TIntObjectHashMap<Identity> internalIdentities = new TIntObjectHashMap(10, 0.5f, -2);
    private final TIntObjectHashMap<Identity> externalIdentities = new TIntObjectHashMap(10, 0.5f, -2);
    private final TIntObjectHashMap<Identity> rootIdentities = new TIntObjectHashMap(10, 0.5f, -2);
    private final TObjectIntHashMap<String> internalIdentitiesByURI = new TObjectIntHashMap();
    private final TObjectIntHashMap<String> externalIdentitiesByURI = new TObjectIntHashMap();
    private final TObjectIntHashMap<String> rootIdentitiesByURI = new TObjectIntHashMap();
    private final TIntObjectHashMap<TIntArrayList> statementsCache = new TIntObjectHashMap(10, 0.5f, -2);
    private static final Comparator<Identity> IDENTITY_NAME_COMPARATOR = new Comparator<Identity>(){

        @Override
        public int compare(Identity o1, Identity o2) {
            if (o1.definition instanceof Internal && o2.definition instanceof Internal) {
                Internal i1 = (Internal)o1.definition;
                Internal i2 = (Internal)o2.definition;
                return i1.name.compareTo(i2.name);
            }
            if (o1.definition instanceof External && o2.definition instanceof External) {
                External e1 = (External)o1.definition;
                External e2 = (External)o2.definition;
                return e1.name.compareTo(e2.name);
            }
            throw new IllegalArgumentException(String.valueOf(o1) + " " + String.valueOf(o2));
        }
    };

    public TransferableGraphQueries(TransferableGraph1 graph) {
        this.tg = graph;
        this.initializeIdentities();
    }

    private void initializeIdentities() {
        Identity[] identityArray = this.tg.identities;
        int n = this.tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            IdentityDefinition definition = identity.definition;
            if (definition instanceof Internal) {
                Internal cfr_ignored_0 = (Internal)definition;
                this.internalIdentities.put(identity.resource, (Object)identity);
                this.internalIdentitiesByURI.put((Object)this.getURI(identity), identity.resource);
            } else if (definition instanceof External) {
                External cfr_ignored_1 = (External)definition;
                this.externalIdentities.put(identity.resource, (Object)identity);
                this.externalIdentitiesByURI.put((Object)this.getURI(identity), identity.resource);
            } else if (definition instanceof Root) {
                Root cfr_ignored_2 = (Root)definition;
                this.rootIdentities.put(identity.resource, (Object)identity);
                this.rootIdentitiesByURI.put((Object)this.getURI(identity), identity.resource);
            }
            ++n2;
        }
    }

    public String getURI(Identity identity) {
        IdentityDefinition definition = identity.definition;
        if (definition instanceof External) {
            External def = (External)definition;
            if (def.parent == -1) {
                return "http:/";
            }
            return this.getURI(def.parent) + "/" + URIStringUtils.escape((String)def.name);
        }
        if (definition instanceof Root) {
            Root def = (Root)definition;
            if (def.name.isEmpty()) {
                return "http:/";
            }
            return def.name;
        }
        if (definition instanceof Internal) {
            Internal def = (Internal)definition;
            return this.getURI(def.parent) + "/" + URIStringUtils.escape((String)def.name);
        }
        return "";
    }

    public String getURI(int id) {
        Identity identity = this.getIdentity(id);
        if (identity == null) {
            return "<internal reference " + id + ">:";
        }
        return this.getURI(identity);
    }

    public Set<Identity> getChildren(Identity parent) {
        TreeSet<Identity> children = new TreeSet<Identity>(IDENTITY_NAME_COMPARATOR);
        this.internalIdentities.forEachEntry((resource, identity2) -> {
            Internal internal = (Internal)identity2.definition;
            if (internal.parent == identity.resource) {
                children.add((Identity)identity2);
            }
            return true;
        });
        return children;
    }

    public Identity findInternalByName(String name) {
        int internal = this.internalIdentitiesByURI.get((Object)name);
        if (internal == -2) {
            return null;
        }
        return (Identity)this.internalIdentities.get(internal);
    }

    private Identity findExternalByName(String name) {
        int external = this.externalIdentitiesByURI.get((Object)name);
        if (external == -2) {
            return null;
        }
        return (Identity)this.externalIdentities.get(external);
    }

    private Identity findExternalByNameAndParent(String name, int parent) {
        Identity external = this.findExternalByName(name);
        if (external.resource == parent) {
            return external;
        }
        return null;
    }

    public Identity findExternalByURI(String uri) {
        int v = this.externalIdentitiesByURI.get((Object)uri);
        if (v == -2) {
            return null;
        }
        return (Identity)this.externalIdentities.get(v);
    }

    public Identity findRootByName(String name) {
        int root = this.rootIdentitiesByURI.get((Object)name);
        if (root == -2) {
            return null;
        }
        return (Identity)this.rootIdentities.get(root);
    }

    public String getName(Identity identity) {
        return TransferableGraphUtils.getName(identity);
    }

    public void forIdentities(TObjectProcedure<Identity> procedure) {
        Identity[] identityArray = this.tg.identities;
        int n = this.tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            if (!procedure.execute((Object)identity)) break;
            ++n2;
        }
    }

    public Identity getIdentity(int resource) {
        Identity result = (Identity)this.rootIdentities.get(resource);
        if (result == null) {
            result = (Identity)this.externalIdentities.get(resource);
        }
        if (result == null) {
            result = (Identity)this.internalIdentities.get(resource);
        }
        return result;
    }

    public Value findValue(int object) {
        return TransferableGraphUtils.findValue(this.tg, object);
    }

    public TreeMap<String, TreeSet<Integer>> sortByPredicateUniqueStatements(int resource) {
        TreeMap<String, TreeSet<Integer>> results = new TreeMap<String, TreeSet<Integer>>();
        TIntArrayList statements = this.getStatements(resource);
        int i = 0;
        while (i < statements.size()) {
            int predicate = statements.get(i);
            String predicateURI = this.getURI(predicate);
            TreeSet<Integer> objects = results.get(predicateURI);
            if (objects == null) {
                objects = new TreeSet();
            }
            objects.add(statements.get(i + 1));
            results.put(predicateURI, objects);
            i += 2;
        }
        return results;
    }

    public TIntArrayList getStatements(int resource) {
        TIntArrayList statements = (TIntArrayList)this.statementsCache.get(resource);
        if (statements == null) {
            statements = TransferableGraphUtils.getStatements(this.tg, resource);
            this.statementsCache.put(resource, (Object)statements);
        }
        return statements;
    }

    public int getPossibleObject(int subject, Identity predicate) {
        return TransferableGraphUtils.getPossibleObject2(this.tg, subject, predicate);
    }

    public TransferableGraph1 getGraph() {
        return this.tg;
    }
}

